package gov.va.med.pharmacy.jaxrs.vistaoutboundmsg.service.impl;

import java.io.StringReader;
import java.util.Date;

import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.xml.bind.JAXB;

import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.pharmacy.jaxrs.vistaoutboundmsg.model.VistaOutboundResponse;
import gov.va.med.pharmacy.jaxrs.vistaoutboundmsg.service.VistaOutboundMsg;
import gov.va.med.pharmacy.ncpdpmsgs.MessageType;
import gov.va.med.pharmacy.persistence.model.OutboundNcpdpMsgEntity;
import gov.va.med.pharmacy.persistence.service.OutboundNcpdpMsgService;

/**
 * A class that implement saves vista outbound message which are coming from vista and sends response back in JSON.
 *
 */

@Consumes("application/x-www-form-urlencoded")
@Produces("application/xml")
public class VistaOutboundMsgImpl implements VistaOutboundMsg {

	
	private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(VistaOutboundMsgImpl.class);
	
	@Autowired
	private OutboundNcpdpMsgService outboundNcpdpMsgService;
	
	@POST
	@Path("/processMessage/")
	public VistaOutboundResponse persistMessage(@FormParam("xmlRequest") String messageStr) {

		VistaOutboundResponse wsResponse = new VistaOutboundResponse();
		try {
			
			//System.out.println("------ getting status message");
			
			//System.out.println("code ====: "+message.getBody());

			OutboundNcpdpMsgEntity  outboundMsg = new OutboundNcpdpMsgEntity();
			
			StringReader reader = new StringReader(messageStr);
		      
			outboundMsg.setMessage(JAXB.unmarshal(reader, MessageType.class));
			
			outboundMsg.setErxStatus("0000");
			
			outboundMsg.setPharmacyId(0);
			
			Date date = new Date();
			
			outboundMsg.setCreatedDate(date);

			outboundMsg.setUpdatedDate(date);

			outboundMsg.setReceivedDate(date);
			
			outboundNcpdpMsgService.saveOutboundMsg(outboundMsg);
			
			// now convert to string for persistence.
			/*JAXBContext jaxbContext = JAXBContext.newInstance(MessageType.class);
			Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
			//pretty printed
			jaxbMarshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
			
			StringWriter stringWriter = new StringWriter();
			
			jaxbMarshaller.marshal(message, stringWriter);
			
			String xmlString = stringWriter.toString();
			

			System.out.println("----- message as string ---"+xmlString);*/
			
			
			wsResponse.setErrorMessage(null);
			
			wsResponse.setSuccess(true);		
					

		} catch (Exception e) {

			LOG.error("Error in VistaOutboundMsgImpl:"+e.getMessage());
			
			wsResponse.setSuccess(false);

			wsResponse.setErrorMessage("Error while saving vista outbound message: " + e.getMessage());
		}

		return wsResponse;
	}


}
