package gov.va.med.pharmacy.jaxrs.outboundncpdpmessage.service.impl;

import java.io.InputStream;
import java.util.Properties;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.pharmacy.jaxrs.outboundncpdpmessage.model.OutboundNCPDPMessageRequest;
import gov.va.med.pharmacy.jaxrs.outboundncpdpmessage.model.OutboundNCPDPMessageResponse;
import gov.va.med.pharmacy.jaxrs.outboundncpdpmessage.service.OutboundNCPDPMessageService;
import gov.va.med.pharmacy.ncpdpmsgs.MessageType;
import gov.va.med.pharmacy.persistence.model.OutboundNcpdpMsgEntity;
import gov.va.med.pharmacy.persistence.service.OutboundNcpdpMsgService;
import gov.va.med.pharmacy.utility.StreamUtilities;

import org.apache.cxf.jaxrs.client.WebClient;


/**
 * A class that implement saves vista outbound message which are coming from vista and sends response back in JSON.
 *
 */

@Consumes("application/json")
@Produces("application/json")
public class OutboundNCPDPMessageServiceImpl implements OutboundNCPDPMessageService {

	
	private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(OutboundNCPDPMessageServiceImpl.class);
	
	@Autowired
	private OutboundNcpdpMsgService outboundNcpdpMsgService;
	
	@POST
	@Path("/outBoundNCPDPMessage/")
	public OutboundNCPDPMessageResponse sendOutboundMessage(OutboundNCPDPMessageRequest outboundRequest ) {

		OutboundNCPDPMessageResponse wsResponse = new OutboundNCPDPMessageResponse();
		try {
			
			System.out.println("------ getting outbound entity ---- ");
			
			OutboundNcpdpMsgEntity outboundMsgEntity = null; 
			
			outboundMsgEntity = outboundNcpdpMsgService.findById(outboundRequest.getOutboundNcpdpMsgId().longValue()); 
			
			
			// if outboundMsg has value then only proceed further.
			
			if(outboundMsgEntity!=null){
				
				wsResponse.setErrorMessage(null);
				
				wsResponse.setSuccess(true);
				
				System.out.println("------ entity id returned---- :"+outboundMsgEntity.getOutboundNcpdpMsgId());
				
				MessageType outboundMessage = null;
				
				outboundMessage = outboundMsgEntity.getMessage();
				
				// if message is not null then send to DAS.
				
				if(null!=outboundMessage){
					
				//TODO - make the url property driven. clean console prints and console loggings from context xml for performance.	
					
					//TODO - Asynchronous invocation with future......
					
					
				 Properties properties = new Properties();
					
				 InputStream inputStream = null;
				 try {
						inputStream = this.getClass().getClassLoader().getResourceAsStream("gov.va.med.pharmacy.wsclients.properties");
						if (null != inputStream) {
							properties.load(inputStream);
						}
					} finally {
						if (null != inputStream) {
							StreamUtilities.safeClose(inputStream);
						}
					}	
				 
				 String dasOutboundEndpoint = properties.getProperty("das.outbound.endpoint").trim();
					
				 WebClient client = WebClient.create(dasOutboundEndpoint);	
				
				 client.path("OutboundErxMessages").accept("text/xml");
				 
				 Response res = client.post(outboundMessage);
				 
				 System.out.println("--------------- DAS Web Service Response Start ------ ");
				 
				 System.out.println(res.getStatus());
				 
				 System.out.println("--------------- DAS Web Service Response End ------ ");
				 
				 
				 
				}
				
			}
			else{
				
				wsResponse.setErrorMessage("Not record found");
				
				wsResponse.setSuccess(false);	
			}
			

		} catch (Exception e) {

			LOG.error("Error in OutboundNCPDPMessageServiceImpl:"+e.getMessage());
			
			wsResponse.setSuccess(false);

			wsResponse.setErrorMessage("Error while processing outbound message: " + e.getMessage());
		}

		return wsResponse;
	}


}
