package gov.va.med.pharmacy.jaxrs.inboundncpdpmessage.service.impl;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.pharmacy.jaxrs.inboundncpdpmessage.service.InboundNCPDPMessageService;
import gov.va.med.pharmacy.jms.messaging.InboundMsgProducer;
import gov.va.med.pharmacy.ncpdpmsgs.MessageType;


/**
 * A class that accepts incoming NCPDP message from change healthcare and returns a response.
 *
 */

@Consumes({"application/xml", "text/xml"})
@Produces("application/xml")
public class InboundNCPDPMessageServiceImpl implements InboundNCPDPMessageService {

	
	private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(InboundNCPDPMessageServiceImpl.class);
	
	//TODO - Enqueue in JMS.
	
	@Autowired
	private InboundMsgProducer inboundMessageProducer;
	
	@POST
	@Path("/inBoundNCPDPMessage/")
	public String  getInboundMessage(MessageType incomingMessage ) {

		String response = null;
		try {
			
			
			//TODO - Enqueue in JMS.
			
			inboundMessageProducer.enqueueERxMessage(incomingMessage);
			
			response ="<Message version=\"010\" release=\"006\" xmlns=\"http://www.changehealthcare.com\">"
					+ "<Header>"
					+ "<To Qualifier=\"P\">3323778</To>"
					+ "<From Qualifier=\"D\">6208890924002</From>"
					+ "<MessageID>ae58e3d87e414985949361728cfc9385</MessageID>"
					+ "<RelatesToMessageID>4016216120.20160226204656</RelatesToMessageID>"
					+ "<SentTime>2016-02-26T20:46:57.7Z</SentTime>"
					+ "<TestMessage>0</TestMessage>"
					+ "</Header>"
					+ "<Body>"
					+ "<Status>"
					+ "<Code>000</Code>"
					+ "</Status>"
					+ "</Body>"
					+ "</Message>";
			
			

		} catch (Exception e) {

			LOG.error("Error in InboundNCPDPMessageServiceImpl:"+e.getMessage());
			
			response ="<Message version=\"010\" release=\"006\" xmlns=\"http://www.changehealthcare.com\">"
					+ "<Header>"
					+ "<To Qualifier=\"P\">3323778</To>"
					+ "<From Qualifier=\"D\">6208890924002</From>"
					+ "<MessageID>ae58e3d87e414985949361728cfc9385</MessageID>"
					+ "<RelatesToMessageID>4016216120.20160226204656</RelatesToMessageID>"
					+ "<SentTime>2016-02-26T20:46:57.7Z</SentTime>"
					+ "<TestMessage>0</TestMessage>"
					+ "</Header>"
					+ "<Body>"
					+ "<Error>"
					+ "<Code>600</Code>"
					+ "<DescriptionCode>001</DescriptionCode>"
					+ "<DescriptionCode>001</DescriptionCode>"
					+ "<Description> Application Error </Description>"
				    + "</Error>"
					+  "</Body>"
					+ "</Message>";
			
		}

		return response;
	}

	

}
