package gov.va.med.pharmacy.web.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.pharmacy.persistence.model.UserRoles;
import gov.va.med.pharmacy.persistence.model.Users;
import gov.va.med.pharmacy.persistence.service.UserService;



@Service("inboundUserDetailsService")
public class InboundUserDetailsService implements UserDetailsService{

	@Autowired
	private UserService userService;
	
	@Transactional(readOnly=true)
	public UserDetails loadUserByUsername(String networkID)	 {
		Users user = userService.findByVAUserID(networkID);
		
		//System.out.println("----- User : "+user);
		
		if(user==null){
			
			//System.out.println("---User not found");
			
			return new User(networkID, "",	true, true, true, true, getViewOnlyGrantedAuthorities());
		}
			return new User(user.getVaUserid(), "",	 (user.getEnabled() ==1), true, true, true, getGrantedAuthorities(user));
	}

	
	private List<GrantedAuthority> getGrantedAuthorities(Users user){
		List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
		
		for(UserRoles userRole : user.getUserRoleses()){
			//System.out.println("---UserRole : "+userRole);
			authorities.add(new SimpleGrantedAuthority("ROLE_"+userRole.getRoles().getRoleName()));
		}
		//System.out.print("---- authorities :"+authorities);
		return authorities;
	}
	
	private List<GrantedAuthority> getViewOnlyGrantedAuthorities(){
		List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
						
		authorities.add(new SimpleGrantedAuthority("ROLE_READONLY"));
		
		//System.out.print("----  Readonly authorities :"+authorities);
		
		return authorities;
	}
	
}
