package gov.va.med.pharmacy.web.auth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.owasp.esapi.ESAPI;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import gov.va.med.pharmacy.web.Constants;
@Controller
public class LogoutController {

    @RequestMapping(value = "/logout")
    public ModelAndView logout(HttpServletRequest request) {

        HttpSession session = request.getSession(false);
        
        String logoutURL= validateInput((String) session.getAttribute(Constants.SSOI_LANDING_URL));
       
        session.removeAttribute(Constants.SESSION_USER);
        
        session.invalidate();
       
        String logoutMessage;
        

        logoutMessage = "You have been logged out of the Inbound eRx application.";
        
       
        
        if(logoutURL!=null){
        	
        	return new ModelAndView("redirect:"+logoutURL);
        }
        else{
        	
        	 return new ModelAndView("logout", "logoutMessage", logoutMessage);
        }
        
       
    }
    
    /**
     * Make sure url string is max 300 in length and matches the regex in EASPI properties. The regex checks that domain name is va.gov for security.
     * 
     * @param logoutURL
     * @return String
     */
    private String validateInput(String logoutURL) {
    	
    	 String value = null;
    	
    	 if(logoutURL== null){
    		 return null;
    	 }
    	 
    	 try 
    	 {
			value = ESAPI.validator().getValidInput("IAMLogout", logoutURL, "IAMLogout", 300, false);
		
		 } catch (Exception e) {

			e.printStackTrace();
			
			throw new RuntimeException("Invalid logoutURL.");
		}
    	 
    	 return value;
    	
    }

   
}
