package gov.va.med.pharmacy.web.auth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang3.StringUtils;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.errors.IntrusionException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import gov.va.med.pharmacy.web.Constants;
import gov.va.med.pharmacy.web.service.InboundUserDetailsService;

@Controller
public class LoginController implements InitializingBean  {

	
	@Autowired
	private InboundUserDetailsService inboundUserDetailsService;
	
	
	@RequestMapping(value = "/homepage")
	public String getHomePage(HttpServletRequest request) {
		
		String tilesView ="inberx.homepage";
				
		return tilesView;
	}
	
	@RequestMapping(value = "/index")
	public String index(HttpServletRequest request) {
		
		String tilesView ="inberx.homepage";
		
		boolean isValid = authenticateUser(request);
		
		if(isValid == true){
			tilesView = "inberx.homepage";
		}
		else{
			tilesView = "inberx.landingPageWithErrors";	
		}
		
		return tilesView;
	}

	private boolean authenticateUser(HttpServletRequest request) {
		
		HttpSession session = request.getSession(false);

		 boolean isValid = false;   
		 
		 // get network login name.
		 if(request.getHeader("ADSAMACCOUNTNAME")!=null) 
		 {
			 
			 String  userId = request.getHeader("ADSAMACCOUNTNAME");
			 
			 //System.out.println("---------- user network id from IAM:"+request.getHeader("ADSAMACCOUNTNAME"));
			 
			 if(StringUtils.isNotBlank(userId)){
				 
			
			 
			 if(request.getHeader(Constants.SSOI_LANDING_URL)!=null)
			 {
				 String logoutURL = request.getHeader(Constants.SSOI_LANDING_URL);
				 
				 if(ESAPI.validator().isValidInput("IAMLogout", logoutURL, "IAMLogout", 300, false, false))
				 {
					 session.removeAttribute(Constants.SSOI_LANDING_URL);
					 
					 session.setAttribute(Constants.SSOI_LANDING_URL, logoutURL);
				  }			 
				 
			 }
			 
			 
			    if(ESAPI.validator().isValidInput("user", userId, "AccountName", 20, false, false))
			    {
			    	userId = userId.toUpperCase();
			     }
			     else
			     {
			    	 		    	 
			    	 session.removeAttribute("loginErrorMessage");
					 
					 session.setAttribute("loginErrorMessage", "Unable to login. Invalid Credentials. Please contact production suppport.");
					 
					 return isValid;

			     }
			 
			 
			  UserDetails user = inboundUserDetailsService.loadUserByUsername(userId);
				
				 if(user != null){
					
					 //System.out.println("---user after login detail service is:" + user.getUsername());	 
					
					 session.removeAttribute(Constants.SESSION_USER);
				     try {
						session.setAttribute(Constants.SESSION_USER, user);
					} catch (IntrusionException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				     session.removeAttribute("loginErrorMessage");
				     
				     isValid = true;
				     
				     // We need to set the security context of authenticated users, otherwise spring security thinks user is not authenticated and redirects to login page.
				     
				     UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken(user.getUsername(), user.getPassword(), user.getAuthorities());
				     
				     SecurityContextHolder.getContext().setAuthentication(authRequest);
				 }
				 
				 else{
					 
					 session.removeAttribute(Constants.SESSION_USER);
					 
					 session.removeAttribute("loginErrorMessage");
					 
					 session.setAttribute("loginErrorMessage", "Unable to login. Invalid Credentials. Please contact production suppport.");

				     isValid = false;
					 
				 }
				 
			 }
			 
			 else{
				 
				 session.removeAttribute(Constants.SESSION_USER);
				 
				 session.removeAttribute("loginErrorMessage");
				 
				 session.setAttribute("loginErrorMessage", "Unable to login. Invalid Credentials. Please contact production suppport.");

			     isValid = false;
				 
			 }
		 }
		 else{
			 session.setAttribute("loginErrorMessage", "Unable to login. Invalid Credentials. Please contact production suppport.");

		     isValid = false;
			 
		 }
	     
				 
           return isValid;			  
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		// TODO Auto-generated method stub
		
	}

	
	

}
