dojo.require("dojox.grid.EnhancedGrid");
dojo.require("dojox.grid.enhanced.plugins.IndirectSelection");
dojo.require("dojo.dom-construct");
dojo.require("dojo.hash");
dojo.require("dijit.registry")

function buildTrackGridDataSource(dataSourceURL, query) {
	try {
		var dataSource = new dojox.data.JsonQueryRestStore({
			target : dataSourceURL,
			idAttribute : "key"
		});		
		return dataSource;
	} catch (err) {
		alert(err.message);
	}
}

function onKeyEvent(event) {
	return false;
}


function createLinktoMessage(fields) {
	if (fields == null || fields == "null" || fields == "") {
		return "";
	}
	var id = fields[0],
	msg_id = fields[1];

	return "<a href=\"#\" onclick=\"getMessage('" + id + "')\">" + msg_id	+ "</a>";
};

function buildTrackGridLayout(servlet, target) {
	var layout = new Array();
	
	obj = new Object();
	obj["field"] = 'inboundNcpdpMsgId';
	obj["name"] = "eRx Reference #";
	obj["width"] = '63px';
	//obj["noresize"] = 'false';
	//obj["formatter"] = formatSelectable;
	//obj["formatter"] = createLinktoMessage;
	layout.push(obj);
	
	obj = new Object();
	//obj["field"] = 'rxMessageId';
	obj["fields"] = ["inboundNcpdpMsgId", "rxMessageId"];
	obj["name"] = "Message Id";
	obj["width"] = '159px';
	//obj["noresize"] = 'false';
	//obj["formatter"] = formatSelectable;
	obj["formatter"] = createLinktoMessage;
	layout.push(obj);
	
	obj = new Object();
	obj["field"] = 'messageType';
	obj["name"] = 'Message Type';
	obj["width"] = '85px';
//	obj["noresize"] = 'true';
	//obj["formatter"] = formatSelectable;
	layout.push(obj);
	
	var obj = new Object();
	obj["field"] = 'prescriberName';
	obj["name"] = 'Prescriber Name';
	obj["width"] = "250px";
	//obj["noresize"] = 'true';
	layout.push(obj);
	
	var obj = new Object();
	obj["field"] = 'pharmacyName';
	obj["name"] = 'Pharmacy Name';
	obj["width"] = "80px";
	//obj["noresize"] = 'true';
	layout.push(obj);

	var obj = new Object();
	obj["field"] = 'pharmacyAddr1';
	obj["name"] = 'Address';
	obj["width"] = "80px";
	//obj["noresize"] = 'true';
	layout.push(obj);
	
	var obj = new Object();
	obj["field"] = 'patientName';
	obj["name"] = 'Patient Name';
	obj["width"] = "80px";
	//obj["noresize"] = 'true';
	layout.push(obj);
	
	
	var obj = new Object();
	obj["field"] = 'rxDrugPrescribed';
	obj["name"] = 'Drug Prescribed';
	obj["width"] = "80px";
	//obj["noresize"] = 'true';
	layout.push(obj);

	obj = new Object();
	obj["field"] = 'relToMessageid';
	obj["name"] = "Relates to Message ID";
	obj["width"] = '80px';
	//obj["noresize"] = 'false';
	//obj["formatter"] = formatSelectable;
	layout.push(obj);
	

	obj = new Object();
	obj["field"] = 'receivedDate';
	obj["name"] = "Received Date";
	obj["width"] = '80px';
	//obj["noresize"] = 'false';
	//obj["formatter"] = formatSelectable;
	layout.push(obj);
	
	obj = new Object();
	obj["field"] = 'patient_chk_status';
	obj["name"] = "Patient AutoCheck Status";
	obj["width"] = '100px';
	//obj["noresize"] = 'false';
	//obj["formatter"] = formatSelectable;
	layout.push(obj);
	
	obj = new Object();
	obj["field"] = 'provider_chk_status';
	obj["name"] = "Provider AutoCheck Status";
	obj["width"] = '100px';
	//obj["noresize"] = 'false';
	//obj["formatter"] = formatSelectable;
	layout.push(obj);
	
	obj = new Object();
	obj["field"] = 'drug_chk_status';
	obj["name"] = "Drug AutoCheck Status";
	obj["width"] = '100px';
	//obj["noresize"] = 'false';
	//obj["formatter"] = formatSelectable;
	layout.push(obj);
	
	obj = new Object();
	obj["field"] = 'message_status';
	obj["name"] = "Message Status";
	obj["width"] = '100px';
	//obj["noresize"] = 'false';
	//obj["formatter"] = formatSelectable;
	layout.push(obj);
	
	
	return layout;
}

function trackDataGridInit(servlet, parentContainer, dataSourceURL) {
	try {
		var gridData =  buildPharmacyGridDataSource("/inbound/" + servlet + "/" + dataSourceURL);
			
		var gridId = parentContainer + 'Grid';
		
		var grid = dijit.byId(gridId);

		// If the DataGrid already exists, just clear any selected rows and
		// replace the store.
		if (grid != null) {
			if (grid.selection != null) {
				grid.selection.clear();
			}
			grid.setStore(gridData);
				
		} else {
			// DataGrid does not exist.
			var gridLayout = buildTrackGridLayout(servlet, parentContainer);
			grid = new dojox.grid.DataGrid({
				id : gridId,
				showTitle : true,
				columnReordering : true,
				loadingMessage : "Query In Progress...",
				noDataMessage : "Your Query Returned No Results",
				onFetchError : gridFetchError,
				selectionMode : 'single',
				selectable : false,
				showFooter: false,
				sort : false,
				//autoHeight: true,
				onKeyEvent : onKeyEvent
			}, document.createElement('div'));
			dojo.byId(parentContainer).appendChild(grid.domNode);
			
			grid.setStore(gridData);
			
			grid.setStructure(gridLayout);
			
			//grid.canSort = function(){return false};  //turn off sorting for now
			
			grid.startup();
			
			// hide the inbound_ncpdp_msg_id
			//grid.layout.setColumnVisibility(0, false);
			
		}
	} catch (err) {
		var txt = "An error occured while building the dataGrid.  The error is: "
				+ err.message + ".";
		alert(txt);
	}

};

dojo.ready(function() {
	
	 getTrackGrid();
		
	
});	


function getTrackGrid() {
	var formId = "searchCriteriaForm";
	var formObject = dojo.formToObject(formId);
	

	trackDataGridInit("inb-erx","messageList", "track/getMessages?json=" + dojo.toJson(formObject) );
	
	//console.log("done");
	
	
}


function getTrackAuditListCSV() {
	var formId = "searchCriteriaForm";
	var formObject = dojo.formToObject(formId);
	
	var getCSVUrl ="/inbound/inb-erx/track/getTrackAuditListCSV?json=" + dojo.toJson(formObject);
	
	location.href= getCSVUrl;
	
}