package gov.va.med.pharmacy.persistence.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.pharmacy.persistence.dao.UserDao;
import gov.va.med.pharmacy.persistence.model.Users;
import gov.va.med.pharmacy.persistence.service.UserService;

@Service("userService")
@Transactional
public class UserServiceImpl implements UserService{

	
	@Autowired
    private UserDao userDao;
	
	@Override
	public Users findById(long id) {
		
		return userDao.findById(id);
	}

	@Override
	public Users findByVAUserID(String networkID) {
		
		return userDao.findByVAUserID(networkID);
	}

}
