package gov.va.med.pharmacy.persistence.model;



import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * InboundNcpdpMsgHist generated by hbm2java
 */
@Entity
@Table(name = "INBOUND_NCPDP_MSG_HIST", schema = "ERX")
public class InboundNcpdpMsgHist implements java.io.Serializable {

	private static final long serialVersionUID = -6112070405787271300L;
	
	private long inboundNcpdpMsgHistId;
	private InboundNcpdpMsg inboundNcpdpMsg;
	private String messageStatus;
	private String patientChkStatus;
	private String patientMatchDetails;
	private String providerChkStatus;
	private String providerMatchDetails;
	private String drugChkStatus;
	private String drugMatchDetails;
	private Date updatedDate;
	private Date createdDate;

	public InboundNcpdpMsgHist() {
	}

	public InboundNcpdpMsgHist(long inboundNcpdpMsgHistId, InboundNcpdpMsg inboundNcpdpMsg) {
		this.inboundNcpdpMsgHistId = inboundNcpdpMsgHistId;
		this.inboundNcpdpMsg = inboundNcpdpMsg;
	}

	public InboundNcpdpMsgHist(long inboundNcpdpMsgHistId, InboundNcpdpMsg inboundNcpdpMsg, String messageStatus,
			String patientChkStatus, String patientMatchDetails, String providerChkStatus, String providerMatchDetails,
			String drugChkStatus, String drugMatchDetails, Date updatedDate, Date createdDate) {
		this.inboundNcpdpMsgHistId = inboundNcpdpMsgHistId;
		this.inboundNcpdpMsg = inboundNcpdpMsg;
		this.messageStatus = messageStatus;
		this.patientChkStatus = patientChkStatus;
		this.patientMatchDetails = patientMatchDetails;
		this.providerChkStatus = providerChkStatus;
		this.providerMatchDetails = providerMatchDetails;
		this.drugChkStatus = drugChkStatus;
		this.drugMatchDetails = drugMatchDetails;
		this.updatedDate = updatedDate;
		this.createdDate = createdDate;
	}

	@Id

	@Column(name = "INBOUND_NCPDP_MSG_HIST_ID", unique = true, nullable = false, precision = 22, scale = 0)
	public long getInboundNcpdpMsgHistId() {
		return this.inboundNcpdpMsgHistId;
	}

	public void setInboundNcpdpMsgHistId(long inboundNcpdpMsgHistId) {
		this.inboundNcpdpMsgHistId = inboundNcpdpMsgHistId;
	}

	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "INBOUND_NCPDP_MSG_ID", nullable = false)
	public InboundNcpdpMsg getInboundNcpdpMsg() {
		return this.inboundNcpdpMsg;
	}

	public void setInboundNcpdpMsg(InboundNcpdpMsg inboundNcpdpMsg) {
		this.inboundNcpdpMsg = inboundNcpdpMsg;
	}

	@Column(name = "MESSAGE_STATUS", length = 4)
	public String getMessageStatus() {
		return this.messageStatus;
	}

	public void setMessageStatus(String messageStatus) {
		this.messageStatus = messageStatus;
	}

	@Column(name = "PATIENT_CHK_STATUS", length = 4)
	public String getPatientChkStatus() {
		return this.patientChkStatus;
	}

	public void setPatientChkStatus(String patientChkStatus) {
		this.patientChkStatus = patientChkStatus;
	}

	@Column(name = "PATIENT_MATCH_DETAILS", length = 2000)
	public String getPatientMatchDetails() {
		return this.patientMatchDetails;
	}

	public void setPatientMatchDetails(String patientMatchDetails) {
		this.patientMatchDetails = patientMatchDetails;
	}

	@Column(name = "PROVIDER_CHK_STATUS", length = 4)
	public String getProviderChkStatus() {
		return this.providerChkStatus;
	}

	public void setProviderChkStatus(String providerChkStatus) {
		this.providerChkStatus = providerChkStatus;
	}

	@Column(name = "PROVIDER_MATCH_DETAILS", length = 2000)
	public String getProviderMatchDetails() {
		return this.providerMatchDetails;
	}

	public void setProviderMatchDetails(String providerMatchDetails) {
		this.providerMatchDetails = providerMatchDetails;
	}

	@Column(name = "DRUG_CHK_STATUS", length = 4)
	public String getDrugChkStatus() {
		return this.drugChkStatus;
	}

	public void setDrugChkStatus(String drugChkStatus) {
		this.drugChkStatus = drugChkStatus;
	}

	@Column(name = "DRUG_MATCH_DETAILS", length = 2000)
	public String getDrugMatchDetails() {
		return this.drugMatchDetails;
	}

	public void setDrugMatchDetails(String drugMatchDetails) {
		this.drugMatchDetails = drugMatchDetails;
	}

	@Temporal(TemporalType.DATE)
	@Column(name = "UPDATED_DATE", length = 7)
	public Date getUpdatedDate() {
		return this.updatedDate;
	}

	public void setUpdatedDate(Date updatedDate) {
		this.updatedDate = updatedDate;
	}

	@Temporal(TemporalType.DATE)
	@Column(name = "CREATED_DATE", length = 7)
	public Date getCreatedDate() {
		return this.createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

}
