package gov.va.med.pharmacy.persistence.dao.impl;

import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import gov.va.med.pharmacy.persistence.BaseDao;
import gov.va.med.pharmacy.persistence.dao.PharmacyDao;
import gov.va.med.pharmacy.persistence.managepharmacy.ManagePharmacyFilter;
import gov.va.med.pharmacy.persistence.model.PharmacyEntity;



@Repository("pharmacy")
public class PharmacyDaoImpl extends BaseDao<Integer, PharmacyEntity> implements PharmacyDao{
   
	@SuppressWarnings("unchecked")
	@Override
	public List<PharmacyEntity> find(ManagePharmacyFilter pharmacyFilterModel){
		
		Criteria criteria = createEntityCriteria().addOrder(Order.asc("divisionName"));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);// for unique results 
        if (pharmacyFilterModel != null){
        	if (pharmacyFilterModel.getVisn().length() > 0){ //check for All value
    			criteria.add(Restrictions.eq("visn", pharmacyFilterModel.getVisn()));
    		}
        }       
        criteria.setProjection(Projections.projectionList()
        		.add(Projections.property("visn"),"visn")
        		.add(Projections.property("vaStationId"),"vaStationId")
        		.add(Projections.property("ncpdpId"),"ncpdpId")
        		.add(Projections.property("divisionName"),"divisionName")
        		.add(Projections.property("pharmacyAddressLine1"),"pharmacyAddressLine1")
        		.add(Projections.property("pharmacyAddressLine1"),"pharmacyAddressLine1")
        		.add(Projections.property("pharmacyCity"),"pharmacyCity")
        		.add(Projections.property("pharmacyState"),"pharmacyState")
        		.add(Projections.property("storeName"),"storeName")
        		.add(Projections.property("activeStartTime"),"activeStartTime")
        		.add(Projections.property("pharmacyPhoneNumber"),"pharmacyPhoneNumber")
        		.add(Projections.property("inboundErxEnabled"),"inboundErxEnabled")
        		);
        
        criteria.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP);
        
        List<PharmacyEntity> pharmacies =  criteria.list();
        
        return pharmacies;
		
	}

	@Override
	public PharmacyEntity findByNCPDPId(String NCPDPId) {
		
		Criteria criteria = createEntityCriteria();
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY); // for unique results 
       
        if (NCPDPId != null){
        	
    		criteria.add(Restrictions.eq("ncpdpId", NCPDPId));    		
        }       
        
            
        PharmacyEntity pharmacy =  (PharmacyEntity) criteria.uniqueResult();
		
		return pharmacy;
	}
	
	@Override
	public PharmacyEntity findById(Long pharmacyId) {
		
		PharmacyEntity pharmacy= getByKey(pharmacyId);
		
		return pharmacy;		
		
	}
	
	@Override
	public void save(PharmacyEntity pharmacy) {
		persist(pharmacy);	
	}
	
	@Override
	public void updatePharmacyInfo(PharmacyEntity pharmacy) {
		
		update(pharmacy);	
	}

	
	
	
	
	

};
