create or replace view erx.summary_report_vw as (
select pharm.ncpdp_id pharmacy_ncpdp_id, pharm.va_station_id pharmacy_va_station_id, pharm.division_name pharmacy_division_name,
pharm.visn visn,
pharm.pharmacy_address_line_1||' '||
pharm.pharmacy_address_line_2||' '||pharm.pharmacy_city||', '||pharm.pharmacy_state||' '||pharm.pharmacy_zipcode pharmacy_address,
sum(decode(inbmsg.message_type, 'NewRx', 1, 0)) new_rx_cnt,
sum(decode(inbmsg.message_status, '3010', 1, 0)) new_rx_pharm_disabled_at_hub,
sum(decode(inbmsg.message_status, '3006', 1, 0)) new_rx_rejected_at_hub,
sum(decode((decode(inbmsg.patient_chk_status,'0101',1,0) + decode(inbmsg.provider_chk_status,'2001',1,0) + decode(inbmsg.drug_chk_status,'1001',1,0)), 3, 1, 0)) new_rx_pass_auto_chk,
sum(decode((decode(inbmsg.patient_chk_status,'0101',1,0) + decode(inbmsg.provider_chk_status,'2001',1,0) + decode(inbmsg.drug_chk_status,'1001',1,0)), 3, 0, 1))
- (sum(decode(inbmsg.message_status, '3006', 1, 0)) + sum(decode(inbmsg.message_status, '3010', 1, 0))) new_rx_fail_auto_chk,
sum(0 + 0) new_rx_rejected_by_pharmacist,
sum(0 + 0) new_rx_filled,
sum(0 + 0) new_rx_in_process,
trunc(inbmsg.created_date) new_rx_message_date
from erx.inbound_ncpdp_msg inbmsg, erx.pharmacy pharm
where inbmsg.pharmacy_id = pharm.pharmacy_id
and inbmsg.MESSAGE_STATUS NOT IN ('0000') and inbmsg.message_type in ('NewRx')
group by pharm.ncpdp_id, pharm.va_station_id, pharm.visn, pharm.division_name,
pharm.pharmacy_address_line_1,pharm.pharmacy_address_line_2,pharm.pharmacy_city,pharm.pharmacy_state,pharm.pharmacy_zipcode,trunc(inbmsg.created_date));