CREATE OR REPLACE TRIGGER ERX.IB_NCPDP_MSG_HIST_INS_TRG 
    AFTER UPDATE ON ERX.INBOUND_NCPDP_MSG 
    FOR EACH ROW 
DECLARE rec INBOUND_NCPDP_MSG_HIST%ROWTYPE;
  blank INBOUND_NCPDP_MSG_HIST%ROWTYPE;
  BEGIN
    rec := blank;
    IF UPDATING THEN
      rec.INBOUND_NCPDP_MSG_ID   := :NEW.INBOUND_NCPDP_MSG_ID;
      rec.PATIENT_CHK_STATUS     := :NEW.PATIENT_CHK_STATUS;
      rec.PATIENT_MATCH_DETAILS  := :NEW.PATIENT_MATCH_DETAILS;
      rec.PROVIDER_CHK_STATUS    := :NEW.PROVIDER_CHK_STATUS;
      rec.PROVIDER_MATCH_DETAILS := :NEW.PROVIDER_MATCH_DETAILS;
      rec.DRUG_CHK_STATUS        := :NEW.DRUG_CHK_STATUS;
      rec.DRUG_MATCH_DETAILS     := :NEW.DRUG_MATCH_DETAILS;
      rec.MESSAGE_STATUS         := :NEW.MESSAGE_STATUS;
      rec.UPDATED_DATE            := :NEW.UPDATED_DATE;
      rec.CREATED_DATE           := :NEW.CREATED_DATE;
    END IF;
    INSERT INTO INBOUND_NCPDP_MSG_HIST VALUES rec;
  END; 
/


