package gov.va.med.pharmacy.jaxrs.tovista.dao.impl;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import gov.va.med.pharmacy.jaxrs.tovista.dao.impl.VistaInboundNcpdpMsgDaoImpl;
import gov.va.med.pharmacy.jaxrs.tovista.model.VistaInbound;
import gov.va.med.pharmacy.jaxrs.tovista.model.VistaInboundNcpdpMsg;
import gov.va.med.pharmacy.utility.StreamUtilities;
import gov.va.med.pharmacy.utility.VistaLinkConnectionUtility;
import gov.va.med.vistalink.rpc.RpcResponse;

/**
 * This class makes RPC call to Vista to send the Inbound NCPDP message.
 *
 */
public class VistaInboundRpc {
	
	private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(VistaInboundRpc.class);
	private VistaInboundNcpdpMsgDaoImpl vistaInboundNcpdpMsgDao;
	private VistaLinkConnectionUtility vistaLinkConnectionUtility;
	
	public VistaInboundNcpdpMsgDaoImpl getVistaInboundNcpdpMsgDao() {
		return vistaInboundNcpdpMsgDao;
	}
	public void setVistaInboundNcpdpMsgDao(VistaInboundNcpdpMsgDaoImpl vistaInboundNcpdpMsgDao) {
		this.vistaInboundNcpdpMsgDao = vistaInboundNcpdpMsgDao;
	}
	public VistaLinkConnectionUtility getVistaLinkConnectionUtility() {
		return vistaLinkConnectionUtility;
	}
	public void setVistaLinkConnectionUtility(VistaLinkConnectionUtility vistaLinkConnectionUtility) {
		this.vistaLinkConnectionUtility = vistaLinkConnectionUtility;
	}
	
	
	public VistaInbound sendMessage(VistaInbound sendObj) throws Exception {

		
		VistaInbound searchResults = new VistaInbound();
		
		VistaInboundNcpdpMsg vistaInboundNcpdpMsg = new VistaInboundNcpdpMsg();

		RpcResponse rpcResponse;
		
		String rpcName ="PSOERXA1 INCERX";
		
		String rpcContext ="PSO WEB SERVICES OPTION";
		
		ArrayList<Object> params = new ArrayList<Object>();

		vistaInboundNcpdpMsg = vistaInboundNcpdpMsgDao.findById(sendObj.getxmlInboundMessageId());
	
		/* transform xml from string to array holding one element per line for VistA*/
		 ArrayList<String> xmlList = new ArrayList<String>();

	        Reader reader = vistaInboundNcpdpMsg.getMessage().getCharacterStream();
	        BufferedReader br = new BufferedReader(reader);
	        String line = null;
	        int i = 0;
	        try{
	        	while(null != (line = br.readLine())) {
	        		xmlList.add(i, line.trim()+ "\r\n");
	        		System.out.println("xml("+ i +")=" +line.trim());
	        		i++;
	        	}
	        }
	        finally{
	        	if (null != br) {
	        		StreamUtilities.safeClose(br);
	        	}
	        }
	    List<String> providerMatchDetailsList = Arrays.asList(vistaInboundNcpdpMsg.getProviderMatchDetails().split("^"));
	    List<String> drugMatchDetailsList = Arrays.asList(vistaInboundNcpdpMsg.getDrugMatchDetails().split("^"));
	    List<String> patientMatchDetailsList = Arrays.asList(vistaInboundNcpdpMsg.getPatientMatchDetails().split("^"));
		
		//set the VistA parameters in proper order
        params.add(xmlList); //XML - xml text 
        params.add(providerMatchDetailsList); //PRCHK - provider check information 
        params.add(patientMatchDetailsList);  //PACHK - patient check information 
        params.add(drugMatchDetailsList); //DACHK - drug auto check
        params.add(vistaInboundNcpdpMsg.getMessageFrom()); //FROM  - from value within the XML
        //params.add(""); //TO  - from value within the XML ---maybe added---
        params.add(vistaInboundNcpdpMsg.getMessageId());  //MID   - message ID from the XML       
		if (vistaInboundNcpdpMsg.getRelToMessageId() != null) {
			params.add(vistaInboundNcpdpMsg.getRelToMessageId()); 
		} else {
			params.add(""); // PMID - parent message id (relates to message ID field from XML)										
		}
                 
		try {
			rpcResponse = vistaLinkConnectionUtility.sendRequest(rpcContext, rpcName, params);
		} catch (Exception e) {
			LOG.error("Error in VistaInboundRPC RPC:"+e.getMessage());
			throw new Exception(e);
		}

		//LOG.debug("XML Response is: " + rpcResponse.getResults());

		String response = rpcResponse.getResults(); 
		
		
		if(StringUtils.isNotEmpty(response) && (!StringUtils.startsWith(response, "0") ) )  
		{
			searchResults.setSuccess(true);
		}
		else{
			searchResults.setVistaMessage(response.substring(response.indexOf("^")+1,response.length() ));
			searchResults.setSuccess(false);
		}
		return searchResults;


	}

}
