package gov.va.med.pharmacy.web.reports;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import gov.va.med.pharmacy.persistence.model.SummaryReportVw;
import gov.va.med.pharmacy.persistence.report.StationIdSelectModel;
import gov.va.med.pharmacy.persistence.report.SummaryReportFilterModel;
import gov.va.med.pharmacy.persistence.service.SummaryReportService;

@Controller
@RequestMapping(value = "/summaryReport")
public class SummaryReportController {
 
	
	@Autowired
	private SummaryReportService summaryReportService;
	private SummaryReportFilterModel summaryReportFilterModel;

	
	@RequestMapping(value = "/getSummary",  method = RequestMethod.GET)
    @ResponseBody
    public List<SummaryReportVw> getSummaryReport(HttpServletRequest request, @RequestParam("json") String json) throws JsonParseException, JsonMappingException, IOException {
		
        List<SummaryReportVw> summaryReportVwList = new ArrayList<SummaryReportVw>();

        System.out.println("json is:"+ json);
        ObjectMapper jsonMapper = new ObjectMapper();
       // jsonMapper.configure(com.fasterxml.jackson.databind.DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false);
        
       summaryReportFilterModel = jsonMapper.readValue(json, SummaryReportFilterModel.class);
      
       summaryReportVwList.addAll(summaryReportService.find(summaryReportFilterModel));
        
        return summaryReportVwList;
    }
	
	@RequestMapping(value = "/getStationIdSelect",  method = RequestMethod.GET, produces="application/json")
    @ResponseBody
    public List<StationIdSelectModel> getStationIdSelect(HttpServletRequest request, @RequestParam("visn") String visn) throws JsonParseException, JsonMappingException, IOException {
		
		List<StationIdSelectModel> stationIdSelectModelList = new ArrayList<StationIdSelectModel>();
		
		List<SummaryReportVw> summaryReportVwList = new ArrayList<SummaryReportVw>();
		if (visn.equalsIgnoreCase("/")){
			visn = "";
		}

        System.out.println("visn is:  "+ visn);

       summaryReportVwList.addAll(summaryReportService.find(visn));
       
             
       int i = 0;
       while ( i < summaryReportVwList.size()){
    	   StationIdSelectModel stationIdSelectModel = new StationIdSelectModel();
    	   System.out.println("station id:  " + summaryReportVwList.get(i).getPharmacyVaStationId());
    	   stationIdSelectModel.setId(summaryReportVwList.get(i).getPharmacyVaStationId());
    	   stationIdSelectModel.setLabel(summaryReportVwList.get(i).getPharmacyVaStationId());
           stationIdSelectModelList.add(i, stationIdSelectModel);
    	   i++;
       }
       System.out.println("list index: " + i);
       StationIdSelectModel stationIdSelectModel = new StationIdSelectModel();
       stationIdSelectModel.setId("All");
	   stationIdSelectModel.setLabel(" All ");
	   stationIdSelectModelList.add(i, stationIdSelectModel);
       
       
        return stationIdSelectModelList;
    }

}

