package gov.va.med.pharmacy.web.auth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import gov.va.med.pharmacy.persistence.model.Users;
import gov.va.med.pharmacy.persistence.service.UserService;
import gov.va.med.pharmacy.web.Constants;

@Controller
public class LoginController implements InitializingBean  {

	@Autowired
	private UserService userService;
	
	
	@RequestMapping(value = "/homepage")
	public String getHomePage(HttpServletRequest request) {
		
		String tilesView ="inberx.homepage";
				
		return tilesView;
	}
	
	@RequestMapping(value = "/index")
	public String index(HttpServletRequest request, @RequestParam("userId") String userId) {
		
		String tilesView ="inberx.homepage";
		
		//ModelAndView view = new ModelAndView(tilesView);
		
		boolean isValid = authenticateUser(request, userId);
		
		if(isValid == true){
			tilesView = "inberx.homepage";
		}
		else{
			tilesView = "inberx.landingPageWithErrors";	
		}
		
		return tilesView;
	}

	private boolean authenticateUser(HttpServletRequest request, String userId) {
		 HttpSession session = request.getSession(false);
	   
		 boolean isValid = false;   
		
	     if(userId!=null && userId.length()>0){
	    	 userId = userId.toUpperCase();
	     }
	     else{
	    	 return isValid;	
	     }
	     
	     Users user = userService.findByVAUserID(userId);
		
		 if(user!=null){
			System.out.println("user is:"+user.getVaUserid());	 
			
			 session.removeAttribute(Constants.SESSION_USER);
		     session.setAttribute(Constants.SESSION_USER, user.getVaUserid());
		     session.removeAttribute("loginErrorMessage");
		     
		     isValid = true;
		 }
		 
		 else{
			 
			 session.removeAttribute(Constants.SESSION_USER);
			 
			 session.setAttribute("loginErrorMessage", "Invalid userid");
		     
			 
		     //session.setAttribute(Constants.SESSION_USER, "test");
		     
		     isValid = false;
			 
		 }
				 
           return isValid;			  
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		// TODO Auto-generated method stub
		
	}

	
	

}
