dojo.require("dojo.hash");
dojo.require("dijit.registry")

dojo.addOnLoad(function() {
	dojo.style(dojo.byId('summaryReport'), "display", "none");
    dojo.style(dojo.byId('summaryReportFilter'), "display", "none");
    
   
});



dojo.ready(function() {
	var selectBox = dojo.byId("reportSelection");
	var selected = null;
	
	dojo.connect(selectBox, "onchange", null, function(event) {
		selected = getSelected(selectBox);
		
		if (selected == "SUMMRPT") {	
			getSummaryReport();
			getStationIdSelect();
			toggleDivs(selected);				
		}
		if (selected == "DETLRPT") {
			toggleDivs(selected);
		}
		else{
			toggleDivs(selected);
		}
		
	});
	
});	




// drop down selection.
function getSelected(selectBox) {
	var selectedIndex = selectBox.options.selectedIndex;
	var selected = selectBox.options[selectedIndex].value;
	return selected;
}



function getSummaryReport() {
	var formId = "summaryReportForm";
	var formObject = dojo.formToObject(formId);
	
	summaryReportDataGridInit("inb-erx","summaryReport", "summaryReport/getSummary?json=" + dojo.toJson(formObject) );
	buildSummaryReportTotalsGrid("summaryReportTotals");
	dojo.byId("reportRunDateTime").innerHTML = "Report as of:  " + getCurrentDateTimeForDisplay();
	console.log("done");
}

function getStationIdSelect(visn) {
	
	var formId = "summaryReportForm";
	var formObject = dojo.formToObject(formId);
	var visn = formObject.visn
	
	summaryReportSelectInit("inb-erx","summaryReportForm", "summaryReport/getStationIdSelect?visn=" + visn);
	console.log("done building select");
}

function getVisnSelect() {

	
	visnSelectInit();
	console.log("done building visn select");
}

	 

function toggleDivs(selected){
  if( selected == "SUMMRPT"){
	  dojo.style(dojo.byId('summaryReportFilter'), "display", "block");
      dojo.style(dojo.byId('summaryReport'), "display", "block"); 
      dojo.style(dojo.byId('summaryReportTotals'), "display", "block");
  } else {
      dojo.style(dojo.byId('summaryReportFilter'), "display", "none");
      dojo.style(dojo.byId('summaryReport'), "display", "none");
      dojo.style(dojo.byId('summaryReportTotals'), "display", "none");
  }
}


function getCurrentDateTimeForDisplay(){
	var d = new Date(),
    minutes = d.getMinutes().toString().length == 1 ? '0'+d.getMinutes() : d.getMinutes(),
    hours = d.getHours().toString().length == 1 ? '0'+d.getHours() : d.getHours(),
    //ampm = d.getHours() >= 12 ? 'pm' : 'am',
    months = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'],
    days = ['Sun','Mon','Tue','Wed','Thu','Fri','Sat'];
return days[d.getDay()]+' '+months[d.getMonth()]+' '+d.getDate()+' '+d.getFullYear()+' '+hours+':'+minutes;
}