<%@ tag language="java" pageEncoding="ISO-8859-1"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ attribute name="name" required="true"%>
<%@ attribute name="path" required="true"%>
<%@ attribute name="permissions" required="false" %>
<%@ attribute name="id" required="false" %>

<c:set var="user" value="${ sessionScope.sessionUser}" />
<c:if test="${not empty user }">
<c:choose> 
<c:when test="${empty permissions }">
	 <li ><a id="${id }" href="${pageContext.request.contextPath}/${path}" >${name}</a></li>
</c:when>
<c:otherwise>
	<c:forTokens items="${permissions}" var="permission"  delims=",">
		<c:if test="${permission eq 'readonly' and user.readonly }" >
			<c:set value="true" var="show" scope="page"/>
		</c:if>

		<c:if test="${permission eq 'pharmacist' and user.pharmacist }" >
			<c:set value="true" var="show" scope="page"/>
		</c:if>
		<c:if test="${permission eq 'technician' and user.technician }" >
			<c:set value="true" var="show" scope="page"/>
		</c:if>
		<c:if test="${permission eq 'manager' and user.manager }" >
			<c:set value="true" var="show" scope="page"/>
		</c:if>	
	</c:forTokens>

	<c:if test="${show eq 'true'}" >
	<li ><a id="${id }" href="${pageContext.request.contextPath}/${path}" >${name}</a></li>
	 </c:if>
</c:otherwise>
</c:choose>
</c:if>
