<%@ taglib prefix="tiles" uri="http://tiles.apache.org/tags-tiles"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://www.springframework.org/tags" prefix="spring" %>
<tiles:importAttribute name="stylesheets" />
<spring:url value="/style/print.css" var="print"/>
<link rel="stylesheet" type="text/css" href="<c:url value="/inb-erx/resources/dojo/resources/dojo.css"/>">
<link rel="stylesheet" type="text/css" href="<c:url value="/inb-erx/resources/dijit/themes/claro/claro.css"/>">
<link rel="stylesheet" type="text/css" href="<c:url value="/inb-erx/resources/dojox/grid/resources/claroGrid.css"/>">
<link rel="stylesheet" type="text/css" href="<c:url value="/inb-erx/resources/dojox/grid/enhanced/resources/EnhancedGrid.css"/>">
<link rel="stylesheet" type="text/css" href="<c:url value="/inb-erx/resources/dojox/grid/enhanced/resources/claro/EnhancedGrid.css"/>">
<link rel="stylesheet" type="text/css" href="<c:url value="/inb-erx/resources/dojox/editor/plugins/resources/css/Save.css"/>">
<link type="text/css" rel="stylesheet" media="print" href="${print }" />


<c:forEach var="stylesheet" items="${stylesheets}">
	<link rel="stylesheet" type="text/css" href="<spring:url value="/style/${stylesheet.value}"/>">
</c:forEach>

<%-- 
Temporary place for js for page imports
--%>

<script type="text/javascript" src="<c:url value="/inb-erx/resources/dojo/dojo.js" />"> </script>
<script type="text/javascript" src="<c:url value="/scripts/component/dataGridSupport.js" />"> </script>
<script type="text/javascript" src="<c:url value="/scripts/component/dataGrid.js" />"> </script>
<script type="text/javascript" src="<c:url value="/scripts/component/formSelect.js" />"> </script>

<script type="text/javascript" src="<c:url value="/scripts/inbound.js" />"> </script>

<script type="text/javascript" src="<c:url value="/scripts/reports.js" />"> </script>
 
<script type="text/javascript">
	/*
	var hideLoader = function() {
		dojo.fadeOut({
			node : "preloader",
			duration : 700,
			onEnd : function() {
				dojo.style("preloader", "display", "none");
			}
		}).play();
	};

	*/
	
	
	dojo.addOnLoad(function() {
		dojo.require("dojo.parser");
		// notice the second onLoad here:
		dojo.addOnLoad(function() {
			dojo.parser.parse();
			//hideLoader();
		});
	});
</script>
<script type="text/javascript">
var sessionTime = null;
	dojo.addOnLoad(function() {
		
		setSessionWarningTimer();
		highlightTab();
	
	});
function highlightTab(){
	var path = location.pathname;
	//console.log(path);
	if ((path.match("index") != null) || (path.match("homepage")) )
	{
        dojo.addClass(dojo.byId("index"), "activeTab");
    }
	else if (path.match("vieweRx") != null) 
	{
        dojo.addClass(dojo.byId("vieweRx"), "activeTab");
    } 
	else if (path.match("managePharm") != null) 
	{
        dojo.addClass(dojo.byId("managepharmacy"), "activeTab");
    }
	else if (path.match("track") != null) 
	{
        dojo.addClass(dojo.byId("trackeRx"), "activeTab");
    } 
	else if (path.match("reports") != null) 
	{
        dojo.addClass(dojo.byId("reports"), "activeTab");
    } 
	else if (path.match("help") != null) 
	{
        dojo.addClass(dojo.byId("help"), "activeTab");
    }
}
function sessionTimeOutWarning() {  
    alert("Your Inbound eRx session will end in two minutes.");

}

function setSessionWarningTimer(){
	/* Assumes Session timout in the web.xml is set to 30 minutes.  
	   Will send a warning alert at 28 minutes */
	var maxTime = 60 * 28 * 1000;
    sessionTime = window.setTimeout(sessionTimeOutWarning, maxTime);
}


function resetSessionWarningTimer(){
	    window.clearTimeout(sessionTime);
	    setSessionWarningTimer();
}

</script>
