package gov.va.med.pharmacy.persistence.service.impl;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.pharmacy.persistence.dao.SummaryReportDao;
import gov.va.med.pharmacy.persistence.model.Pharmacy;
import gov.va.med.pharmacy.persistence.model.SummaryReportVw;
import gov.va.med.pharmacy.persistence.report.StationIdSelectModel;
import gov.va.med.pharmacy.persistence.report.SummaryReportFilterModel;
import gov.va.med.pharmacy.persistence.service.SummaryReportService;


@Service("summaryReportService")
@Transactional
public class SummaryReportServiceImpl implements SummaryReportService{


@Autowired
private SummaryReportDao summaryReportDao;

@Override
public SummaryReportVw findByVisn(String id) {
	
	return summaryReportDao.findByVisn(id);
}

@Override
public List<SummaryReportVw> findByDate(Date dateFrom, Date dateTo) {
	
	return summaryReportDao.findByDate(dateFrom, dateTo);
}

@Override
public List<SummaryReportVw> find(SummaryReportFilterModel summaryReportFilterModel) {
	
	return summaryReportDao.find(summaryReportFilterModel);
}

@Override
public List<SummaryReportVw> find(String visn) {
	
	return summaryReportDao.find(visn);
}


}
