package gov.va.med.pharmacy.persistence.dao.impl;

import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import gov.va.med.pharmacy.persistence.BaseDao;
import gov.va.med.pharmacy.persistence.dao.UserDao;
import gov.va.med.pharmacy.persistence.model.Users;

@Repository("userDao")
public class UserDaoImpl extends BaseDao<Integer, Users> implements UserDao{

	@Override
	public Users findById(long id) {
		Users user = getByKey(id);
      
		if(user!=null){
            Hibernate.initialize(user.getUserRoleses());
        }
        
        return user;
	}

	@Override
	public Users findByVAUserID(String networkID) {
		Criteria crit = createEntityCriteria();
        crit.add(Restrictions.eq("vaUserid", networkID));
        Users users = (Users)crit.uniqueResult();
        if(users!=null){
            Hibernate.initialize(users.getUserRoleses());
        }
        return users;
	}

	@Override
	public void save(Users user) {
		 persist(user);
		
	}

	@Override
	public void deleteByVAUserID(String networkID) {
		Criteria crit = createEntityCriteria();
        crit.add(Restrictions.eq("vaUserid", networkID));
        Users user = (Users)crit.uniqueResult();
        delete(user);
		
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Users> findAllUsers() {
		Criteria criteria = createEntityCriteria().addOrder(Order.asc("vaUserid"));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);// for unique results
        List<Users> users = (List<Users>) criteria.list();
        
        for(Users user : users){
          
        	Hibernate.initialize(user.getUserRoleses());
        }
        
        return users;
	}

}
