package gov.va.med.pharmacy.persistence.dao.impl;

import java.util.Date;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import gov.va.med.pharmacy.persistence.BaseDao;
import gov.va.med.pharmacy.persistence.dao.SummaryReportDao;
import gov.va.med.pharmacy.persistence.model.SummaryReportVw;
import gov.va.med.pharmacy.persistence.report.SummaryReportFilterModel;


@Repository("summaryReportDao")
public class SummaryReportDaoImpl extends BaseDao<Integer, SummaryReportVw> implements SummaryReportDao{
   
	
	@Override
	public SummaryReportVw findByVisn(String visn) {
		Criteria crit = createEntityCriteria();
        crit.add(Restrictions.eq("visn", visn));
        SummaryReportVw summaryReportVw = (SummaryReportVw)crit.uniqueResult();
        
        return summaryReportVw;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public List<SummaryReportVw> findByDate(Date dateFrom, Date dateTo) {
		Criteria criteria = createEntityCriteria().addOrder(Order.asc("pharmacyDivisionName"));
        //criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);// for unique results
        List<SummaryReportVw> summaryReportRows = (List<SummaryReportVw>) criteria.list();
        
        return summaryReportRows;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public List<SummaryReportVw> find(SummaryReportFilterModel summaryReportFilterModel) {
		
		System.out.print("DateFrom: " + summaryReportFilterModel.getDateFrom()
		+ " DateTo: " + summaryReportFilterModel.getDateTo() + "VISN: " + summaryReportFilterModel.getVisn()
		+ "Station ID: " + summaryReportFilterModel.getStationId());
		Criteria criteria = createEntityCriteria().addOrder(Order.asc("pharmacyDivisionName"));
		criteria.add(Restrictions.between("newRxMessageDate", summaryReportFilterModel.getDateFrom(), summaryReportFilterModel.getDateTo()));
		
		if (summaryReportFilterModel.getVisn().length() > 0){ //check for All value
			criteria.add(Restrictions.eq("visn", summaryReportFilterModel.getVisn()));
		}
		if (summaryReportFilterModel.getStationId() != null){
			if (summaryReportFilterModel.getStationId().compareTo("All") != 0){ //check for All value
				criteria.add(Restrictions.eq("pharmacyVaStationId", summaryReportFilterModel.getStationId()));
			}
		}
		criteria.setProjection(Projections.projectionList()
				.add(Projections.groupProperty("visn").as("visn"))
				.add(Projections.groupProperty("pharmacyNcpdpId").as("pharmacyNcpdpId"))
				.add(Projections.groupProperty("pharmacyVaStationId").as("pharmacyVaStationId"))
				.add(Projections.groupProperty("pharmacyDivisionName").as("pharmacyDivisionName"))
				.add(Projections.groupProperty("pharmacyAddress").as("pharmacyAddress"))
				.add(Projections.sum("newRxCnt").as("newRxCnt"))
				.add(Projections.sum("newRxPharmDisabledAtHub").as("newRxPharmDisabledAtHub"))
				.add(Projections.sum("newRxRejectedAtHub").as("newRxRejectedAtHub"))
				.add(Projections.sum("newRxPassAutoChk").as("newRxPassAutoChk"))
				.add(Projections.sum("newRxFailAutoChk").as("newRxFailAutoChk"))
				.add(Projections.sum("newRxRejectedByPharmacist").as("newRxRejectedByPharmacist"))
				.add(Projections.sum("newRxFilled").as("newRxFilled"))
				.add(Projections.sum("newRxInProcess").as("newRxInProcess")));

		criteria.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP);
		
		List<SummaryReportVw> summaryReportRows = (List<SummaryReportVw>) criteria.list();
		
        return summaryReportRows;
	}

	@SuppressWarnings("unchecked")
	@Override	
	public List<SummaryReportVw> find(String visn) {
		Criteria criteria = createEntityCriteria().addOrder(Order.asc("pharmacyVaStationId"));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);// for unique results
        if (visn != null && visn.length() > 0){
		visn = visn.substring(0, visn.length()-1);
        }
        if (visn.compareTo("") == 0){ //check for All value
			visn = "%";	
		}
		System.out.println("visn for stationId query is:  "+ visn);
		criteria.add(Restrictions.like("visn", visn));
        List<SummaryReportVw> selectRows = (List<SummaryReportVw>) criteria.list();
        
        return selectRows;
		

	}



}
