package gov.va.med.pharmacy.jms.messaging;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.pharmacy.persistence.model.InboundNcpdpMsgEntity;
import gov.va.med.pharmacy.persistence.service.InboundNcpdpMsgService;

import javax.jms.BytesMessage;

public class InboundMsgProcessor {

	@Autowired
	private InboundNcpdpMsgService inboundNcpdpMsgService;

	public void getERxMessage(BytesMessage eRxMessage) {

		try {
			
			//System.out.println("Processing eRxMessage: " + eRxMessage);

		
			// persist the message.

			InboundNcpdpMsgEntity inboundeRx = new InboundNcpdpMsgEntity();

			Date date = new Date();

			inboundeRx.setErxStatusByPatientChkStatus("0000");
			inboundeRx.setErxStatusByDrugChkStatus("0000");
			inboundeRx.setErxStatusByProviderChkStatus("0000");

			inboundeRx.setErxStatusByMessageStatus("0000");

			int messageLength = new Long(eRxMessage.getBodyLength()).intValue();

			byte[] messageByteArray = new byte[messageLength];

			eRxMessage.readBytes(messageByteArray, messageLength);

			String message = new String(messageByteArray);

			inboundeRx.setMessage(message);

			inboundeRx.setPharmacyId(0);

			inboundeRx.setCreatedDate(date);

			inboundeRx.setUpdatedDate(date);

			inboundeRx.setReceivedDate(date);

			inboundNcpdpMsgService.saveInboundERx(inboundeRx);

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/*
	 * public void getERxMessage(String eRxMessage) { try { System.out.println(
	 * "Processing eRxMessage: " + eRxMessage);
	 * 
	 * // persist the message.
	 * 
	 * InboundNcpdpMsgEntity inboundeRx = new InboundNcpdpMsgEntity();
	 * 
	 * Date date = new Date();
	 * 
	 * inboundeRx.setErxStatusByPatientChkStatus("0000");
	 * inboundeRx.setErxStatusByDrugChkStatus("0000");
	 * inboundeRx.setErxStatusByProviderChkStatus("0000");
	 * 
	 * inboundeRx.setErxStatusByMessageStatus("0000");
	 * 
	 * inboundeRx.setPharmacyId(0);
	 * 
	 * inboundeRx.setCreatedDate(date);
	 * 
	 * inboundeRx.setUpdatedDate(date);
	 * 
	 * inboundeRx.setReceivedDate(date);
	 * 
	 * inboundNcpdpMsgService.saveInboundERx(inboundeRx);
	 * 
	 * System.out.println(" -------------- done saving ------------");
	 * 
	 * } catch (Exception e) { e.printStackTrace(); } }
	 */

}
