package gov.va.med.pharmacy.jms.domain;



import java.sql.Clob;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * InboundNcpdpMsg generated by hbm2java
 */
@Entity
@Table(name = "INBOUND_NCPDP_MSG", schema = "ERX")
public class InboundNcpdpMsg implements java.io.Serializable {

	private static final long serialVersionUID = 3921985901465617914L;
	
	private long inboundNcpdpMsgId;
	private String messageId;
	private String relToMessageId;
	private String messageType;
	private Clob message;
	private long pharmacyId;
	private long patientChkStatus;
	private String patientMatchDetails;
	private long providerChkStatus;
	private String providerMatchDetails;
	private long drugChkStatus;
	private String drugMatchDetails;
	private long messageStatus;
	private Date receivedDate;
	private Date updatedDate;
	private Date createdDate;

	public InboundNcpdpMsg() {
	}

	public InboundNcpdpMsg(long inboundNcpdpMsgId, long pharmacyId, long patientChkStatus,
			long providerChkStatus, long drugChkStatus, long messageStatus) {
		this.inboundNcpdpMsgId = inboundNcpdpMsgId;
		this.pharmacyId = pharmacyId;
		this.patientChkStatus = patientChkStatus;
		this.providerChkStatus = providerChkStatus;
		this.drugChkStatus = drugChkStatus;
		this.messageStatus = messageStatus;
	}

	public InboundNcpdpMsg(long inboundNcpdpMsgId, String messageId, String relToMessageId, String messageType,
			Clob message, long pharmacyId, long patientChkStatus, String patientMatchDetails,
			long providerChkStatus, String providerMatchDetails, long drugChkStatus,
			String drugMatchDetails, long messageStatus, Date receivedDate, Date updatedDate, Date createdDate) {
		this.inboundNcpdpMsgId = inboundNcpdpMsgId;
		this.messageId = messageId;
		this.relToMessageId = relToMessageId;
		this.messageType = messageType;
		this.message = message;
		this.pharmacyId = pharmacyId;
		this.patientChkStatus = patientChkStatus;
		this.patientMatchDetails = patientMatchDetails;
		this.providerChkStatus = providerChkStatus;
		this.providerMatchDetails = providerMatchDetails;
		this.drugChkStatus = drugChkStatus;
		this.drugMatchDetails = drugMatchDetails;
		this.messageStatus = messageStatus;
		this.receivedDate = receivedDate;
		this.updatedDate = updatedDate;
		this.createdDate = createdDate;
	}

	@Id

	@Column(name = "INBOUND_NCPDP_MSG_ID", unique = true, nullable = false, precision = 22, scale = 0)
	public long getInboundNcpdpMsgId() {
		return this.inboundNcpdpMsgId;
	}

	public void setInboundNcpdpMsgId(long inboundNcpdpMsgId) {
		this.inboundNcpdpMsgId = inboundNcpdpMsgId;
	}

	@Column(name = "MESSAGE_ID", length = 35)
	public String getMessageId() {
		return this.messageId;
	}

	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}

	@Column(name = "REL_TO_MESSAGE_ID", length = 35)
	public String getRelToMessageId() {
		return this.relToMessageId;
	}

	public void setRelToMessageId(String relToMessageId) {
		this.relToMessageId = relToMessageId;
	}

	@Column(name = "MESSAGE_TYPE", length = 35)
	public String getMessageType() {
		return this.messageType;
	}

	public void setMessageType(String messageType) {
		this.messageType = messageType;
	}

	@Column(name = "MESSAGE")
	public Clob getMessage() {
		return this.message;
	}

	public void setMessage(Clob message) {
		this.message = message;
	}

	@Column(name = "PHARMACY_ID", nullable = false, precision = 22, scale = 0)
	public long getPharmacyId() {
		return this.pharmacyId;
	}

	public void setPharmacyId(long pharmacyId) {
		this.pharmacyId = pharmacyId;
	}

	@Column(name = "PATIENT_CHK_STATUS", nullable = false, precision = 22, scale = 0)
	public long getPatientChkStatus() {
		return this.patientChkStatus;
	}

	public void setPatientChkStatus(long patientChkStatus) {
		this.patientChkStatus = patientChkStatus;
	}

	@Column(name = "PATIENT_MATCH_DETAILS", length = 2000)
	public String getPatientMatchDetails() {
		return this.patientMatchDetails;
	}

	public void setPatientMatchDetails(String patientMatchDetails) {
		this.patientMatchDetails = patientMatchDetails;
	}

	@Column(name = "PROVIDER_CHK_STATUS", nullable = false, precision = 22, scale = 0)
	public long getProviderChkStatus() {
		return this.providerChkStatus;
	}

	public void setProviderChkStatus(long providerChkStatus) {
		this.providerChkStatus = providerChkStatus;
	}

	@Column(name = "PROVIDER_MATCH_DETAILS", length = 2000)
	public String getProviderMatchDetails() {
		return this.providerMatchDetails;
	}

	public void setProviderMatchDetails(String providerMatchDetails) {
		this.providerMatchDetails = providerMatchDetails;
	}

	@Column(name = "DRUG_CHK_STATUS", nullable = false, precision = 22, scale = 0)
	public long getDrugChkStatus() {
		return this.drugChkStatus;
	}

	public void setDrugChkStatus(long drugChkStatus) {
		this.drugChkStatus = drugChkStatus;
	}

	@Column(name = "DRUG_MATCH_DETAILS", length = 2000)
	public String getDrugMatchDetails() {
		return this.drugMatchDetails;
	}

	public void setDrugMatchDetails(String drugMatchDetails) {
		this.drugMatchDetails = drugMatchDetails;
	}

	@Column(name = "MESSAGE_STATUS", nullable = false, precision = 22, scale = 0)
	public long getMessageStatus() {
		return this.messageStatus;
	}

	public void setMessageStatus(long messageStatus) {
		this.messageStatus = messageStatus;
	}

	@Temporal(TemporalType.DATE)
	@Column(name = "RECEIVED_DATE", length = 7)
	public Date getReceivedDate() {
		return this.receivedDate;
	}

	public void setReceivedDate(Date receivedDate) {
		this.receivedDate = receivedDate;
	}

	@Temporal(TemporalType.DATE)
	@Column(name = "UPDATED_DATE", length = 7)
	public Date getUpdatedDate() {
		return this.updatedDate;
	}

	public void setUpdatedDate(Date updatedDate) {
		this.updatedDate = updatedDate;
	}

	@Temporal(TemporalType.DATE)
	@Column(name = "CREATED_DATE", length = 7)
	public Date getCreatedDate() {
		return this.createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

}
