CREATE OR REPLACE TRIGGER ERX.USERS_TRG 
    BEFORE INSERT OR UPDATE ON ERX.USERS
    FOR EACH ROW 
BEGIN 
IF UPDATING THEN
  :NEW.UPDATED_DATE := SYSDATE;
ELSE
  :NEW.CREATED_DATE := SYSDATE;
  IF :NEW.USERS_ID IS NULL THEN
  :NEW.USERS_ID := USERS_ID_SEQ.NEXTVAL;
  END IF;
END IF;
END; 
/
