--script drops and creates all erx schema objects
--assumes erx user is created and
--ERX_FILES Directory object must first be created with schema/EMD_NCPDP_SCRIPT_10_6.xsd present
--or NCPDP_SCHEMA.sql will fail


--set the define below for scripts directory location if not in pwd
define dir=.

spool &dir\create_schema_objects.log



start &dir\NCDPD_SCHEMA.sql


start &dir\APP_CONFIGURATION.sql
start &dir\APP_CONFIGURATION_Constraints.sql


start &dir\ERX_STATUS.sql
start &dir\ERX_STATUS_Constraints.sql

--users, roles and user_roles

start &dir\ROLES.sql
start &dir\ROLES_Constraints.sql
start &dir\USERS.sql
start &dir\USERS_Constraints.sql
start &dir\USER_ROLES.sql
start &dir\USER_ROLES_Constraints.sql
start &dir\USER_ROLES_ROLES_FK.sql
start &dir\USER_ROLES_USER_FK.sql

start &dir\PHARMACY.sql
start &dir\PHARMACY_Constraints.sql
start &dir\PHARMACY_USERS_CREATED_BY_FK.sql
start &dir\PHARMACY_USERS_UPDATED_BY_FK.sql


start &dir\INBOUND_NCPDP_MSG.sql
start &dir\INBOUND_NCPDP_MSG_Constraints.sql
start &dir\IB_NCPDP_MSG_ERX_STATUS_FK.sql
start &dir\IB_NCPDP_MSG_ERX_STATUS_FK1.sql
start &dir\IB_NCPDP_MSG_ERX_STATUS_FK2.sql
start &dir\IB_NCPDP_MSG_ERX_STATUS_FK3.sql
start &dir\IB_NCPDP_MSG_PHARMACY_FK.sql


start &dir\INBOUND_NCPDP_MSG_HIST.sql
start &dir\INBOUND_NCPDP_MSG_HIST_Constraints.sql
start &dir\INBOUND_NCPDP_MSG_FK.sql

start &dir\OUTBOUND_NCPDP_MSG.sql
start &dir\OUTBOUND_MSG_ERX_STATUS_FK.sql
start &dir\OUTBOUND_MSG_PHARMACY_ID_FK.sql
start &dir\OUTBOUND_NCPDP_MSG_Constraints.sql

start &dir\OUTBOUND_NCPDP_MSG_HIST.sql
start &dir\OUTBOUND_NCPDP_MSG_HIST_Constraints.sql
start &dir\OB_NCPDP_MSG_HIST_FK.sql

start &dir\VISTA_LOOKUP.sql
start &dir\VISTA_LOOKUP_Constraints.sql
start &dir\PHARMACY_VISTA_LOOKUP_FK.sql

start &dir\ERX_STATUS_ID_SEQ.sql
start &dir\IB_NCPDP_MSG_HIST_ID_SEQ.sql
start &dir\IB_NCPDP_MSG_ID_SEQ.sql
start &dir\OB_NCPDP_MSG_HIST_ID_SEQ.sql
start &dir\OB_NCPDP_MSG_ID_SEQ.sql
start &dir\PHARMACY_ID_SEQ.sql
start &dir\VISTA_LOOKUP_ID_SEQ.sql
start &dir\USERS_ID_SEQ.sql

start &dir\VISTA_LOOKUP_TRG.sql
start &dir\OB_NCPDP_MSG_TRG.sql
start &dir\OB_NCPDP_MSG_INS_TRG.sql
start &dir\OB_NCPDP_MSG_HIST_TRG.sql
start &dir\IB_NCPDP_MSG_HIST_INS_TRG.sql
start &dir\IB_NCPDP_MSG_HIST_TRG.sql
start &dir\IB_NCPDP_MSG_TRG.sql
start &dir\PHARMACY_TRG.sql
start &dir\ERX_STATUS_TRG.sql
start &dir\APP_CONFIGURATION_TRG.sql
start &dir\USERS_TRG.sql

start &dir\SUMMARY_REPORT_VW.sql

start &dir\UTILS_PKG.sql

rem checking object counts, also for invalid objects

select
count(object_name) actual,
case
when status = 'INVALID' then
decode(object_type, 'SEQUENCE',0,'TRIGGER', 0,'TABLE', 0, 'INDEX',0,'VIEW',0)
when status ='VALID' then
decode(object_type, 'SEQUENCE',8,'TRIGGER', 10,'TABLE', 11, 'INDEX',13,'VIEW',1)
end
expected,
object_type,
status object_status
from all_objects
where owner = 'ERX' and object_type in ('TABLE', 'TRIGGER', 'SEQUENCE', 'INDEX','VIEW')
group by object_type, status;

spool off