package gov.va.med.pharmacy.vistalink;

import gov.va.med.exception.ExceptionUtils;
import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.adapter.cci.VistaLinkAppProxyConnectionSpec;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnection;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionFactory;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionSpec;
import gov.va.med.vistalink.adapter.cci.VistaLinkDuzConnectionSpec;
import gov.va.med.vistalink.adapter.cci.VistaLinkVpidConnectionSpec;
import gov.va.med.vistalink.adapter.record.VistaLinkFaultException;
import gov.va.med.vistalink.institution.InstitutionMappingDelegate;
import gov.va.med.vistalink.rpc.RpcRequest;
import gov.va.med.vistalink.rpc.RpcRequestFactory;
import gov.va.med.vistalink.rpc.RpcResponse;

import java.io.IOException;
import java.util.ArrayList;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

/**
 * Controller servlet for MVC-architected sample web application.
 * <p>
 * Demonstrates how to use VistaLink in a J2EE environment to execute RPCs and retrieve data from M.
 * 
 * Note: This sample app is naive in a security sense, in terms of (not) checking whether user input conforms to
 * expectations.
 * 
 */
@SuppressWarnings("deprecation")
public class VistaLinkJ2EESample extends HttpServlet {

	private static final Logger logger = Logger.getLogger(VistaLinkJ2EESample.class);

	private static final String ACTION_RESULTS = "results";
	private static final String ACTION_APP_PROXY = "app-proxy";
	private static final String ACTION_VPID = "vpid";
	private static final String ACTION_DUZ = "duz";
	private static final String ACTION_LOGIN = "login";
	private static final String ACTION_PROCESS = "process";

	private static final String ACTION_RESULTS_PAGE = "/jsp/DisplayResults.jsp";
	private static final String ACTION_APP_PROXY_PAGE = "/jsp/AppProxyLogon.jsp";
	private static final String ACTION_VPID_PAGE = "/jsp/VpidLogon.jsp";
	private static final String ACTION_DUZ_PAGE = "/jsp/DuzLogon.jsp";
	private static final String ACTION_LOGIN_PAGE = "/jsp/LoginChoice.jsp";
	
	private static final String ATTR_DIVISION = "division";
	private static final String ATTR_DUZ = "duz";
	private static final String ATTR_VPID = "vpid";
	private static final String ATTR_APPPROXY = "appProxyName";
	private static final String ATTR_CONNECTOR = "connector";
	

	/**
	 * @va.exclude
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doGetAndPost(request, response);
	}

	/**
	 * @va.exclude
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doGetAndPost(request, response);
	}

	/**
	 * Method process boths GET and POST submissions
	 * @param request servlet request object
	 * @param response servlet response object
	 * @throws ServletException
	 * @throws IOException
	 */
	private void doGetAndPost(HttpServletRequest request, HttpServletResponse response) throws ServletException,
			IOException {

		logger.debug("in doGetAndPost");
		String action = request.getParameter("action");
		RequestDispatcher dispatcher = null;

		if (action != null) {
			if (ACTION_DUZ.equals(action)) {
				dispatcher = getServletContext().getRequestDispatcher(ACTION_DUZ_PAGE);
			} else if (ACTION_VPID.equals(action)) {
				dispatcher = getServletContext().getRequestDispatcher(ACTION_VPID_PAGE);
			} else if (ACTION_APP_PROXY.equals(action)) {
				dispatcher = getServletContext().getRequestDispatcher(ACTION_APP_PROXY_PAGE);
			} else if (ACTION_RESULTS.equals(action)) {
				dispatcher = getServletContext().getRequestDispatcher(ACTION_RESULTS_PAGE);
			} else if (ACTION_LOGIN.equals(action)) {
				dispatcher = getServletContext().getRequestDispatcher(ACTION_LOGIN_PAGE);
			} else if (ACTION_PROCESS.equals(action)) {
				// run RPCs, display results
				processRpc(request, response);
				return; // because dispatcher.forward() called in processRpc
			} else {
				// unknown action... default to login page
				dispatcher = getServletContext().getRequestDispatcher(ACTION_LOGIN_PAGE);
			}
		} else {
			// action is null... default to login page
			dispatcher = getServletContext().getRequestDispatcher(ACTION_LOGIN_PAGE);
		}
		dispatcher.forward(request, response);
	}

	/**
	 * Execute series of RPCs, store output in results StringBuffer.
	 * 
	 * @param request servlet request object
	 * @param response servlet response object
	 * @throws IOException
	 * @throws ServletException
	 */
	private void processRpc(HttpServletRequest request, HttpServletResponse response) throws IOException,
			ServletException {

		VistaLinkConnectionSpec connSpec = null;
		StringBuffer results = new StringBuffer();
		RequestDispatcher dispatcher = null;

		// collect form parameters
		String division = request.getParameter(ATTR_DIVISION);
		String duz = request.getParameter(ATTR_DUZ);
		String vpid = request.getParameter(ATTR_VPID);
		String appProxyName = request.getParameter(ATTR_APPPROXY);
		boolean connRefLookup = "lookup".equals(request.getParameter(ATTR_CONNECTOR));
		boolean connRefSelect = "select".equals(request.getParameter(ATTR_CONNECTOR));

		// create connection spec
		if (vpid != null) {
			connSpec = new VistaLinkVpidConnectionSpec(division, vpid);
			request.setAttribute(ATTR_DIVISION, division);
			request.setAttribute(ATTR_VPID, vpid);
		} else if (duz != null) {
			connSpec = new VistaLinkDuzConnectionSpec(division, duz);
			request.setAttribute(ATTR_DIVISION, division);
			request.setAttribute(ATTR_DUZ, duz);
		} else if (appProxyName != null) {
			connSpec = new VistaLinkAppProxyConnectionSpec(division, appProxyName);
			request.setAttribute(ATTR_DIVISION, division);
			request.setAttribute(ATTR_APPPROXY, appProxyName);
		} else {
			dispatcher = getServletContext().getRequestDispatcher(ACTION_LOGIN_PAGE);
			dispatcher.forward(request, response);
			return;
		}

		Context ic = null;
		String jndiName = "";
		VistaLinkConnectionFactory cf = null;
		VistaLinkConnection myConnection = null;
		RpcRequest vReq = null;
		RpcResponse vResp = null;
		String rpcName = "";
		// rpc success/failure indicator
		request.setAttribute("success", "false");

		if (connSpec != null) {

			try {
				ic = new InitialContext();
				if (connRefLookup) {
					jndiName = InstitutionMappingDelegate.getJndiConnectorNameForInstitution(division);
				} else if (connRefSelect) {
					jndiName = request.getParameter("connectorChoice");
				} else {
					// note, a resource-ref mapping is used to create the resource
					// reference used below
					jndiName = "java:comp/env/eis/vlj/testconnector";
				}
				request.setAttribute("jndiName", jndiName);
				cf = (VistaLinkConnectionFactory) ic.lookup(jndiName);
				myConnection = (VistaLinkConnection) cf.getConnection(connSpec);
				
				//rpcName = "XOBV TEST PING";
				vReq = RpcRequestFactory.getRpcRequest();
				// set request timeout to twice connection's normal value
				vReq.setTimeOut(myConnection.getTimeOut() * 2);
				vReq.setUseProprietaryMessageFormat(true);
				//vReq.setRpcContext("XOBV VISTALINK TESTER");
				//vReq.setRpcName(rpcName);
				//vResp = myConnection.executeRPC(vReq);
				//results.append(rpcName).append(" Results: \n").append(vResp.getResults()).append('\n');
				String xmlSample = request.getParameter("ncpdpXML");
				if (xmlSample == null||xmlSample == "") {
				xmlSample = "<?xml version=\"1.0\"?>\r\n" + 
							"<Message version=\"010\" release=\"006\" xmlns=\"http://www.ncpdp.org/schema/SCRIPT\">\r\n" + 
							"	<Header>\r\n" + 
							"		<To Qualifier=\"P\">1111111</To>\r\n" + 
							"		<From Qualifier=\"D\">ERXTEST1</From>\r\n" + 
							"		<MessageID>0025342_MAX_NEWRX_IN</MessageID>\r\n" + 
							"		<SentTime>2012-02-28T09:30:47.0Z</SentTime>\r\n" + 
							"		<Security>\r\n" + 
							"			<Sender>\r\n" + 
							"				<TertiaryIdentification>ERXTEST</TertiaryIdentification>\r\n" + 
							"			</Sender>\r\n" + 
							"			<Receiver>\r\n" + 
							"				<TertiaryIdentification>COSTCO</TertiaryIdentification>\r\n" + 
							"			</Receiver>\r\n" + 
							"		</Security>\r\n" + 
							"		<PrescriberOrderNumber>11111</PrescriberOrderNumber>\r\n" + 
							"	</Header>\r\n" + 
							"	<Body>\r\n" + 
							"		<NewRx>\r\n" + 
							"			<Request>\r\n" + 
							"				<ChangeRequestType>C3</ChangeRequestType>\r\n" + 
							"				<ReturnReceipt>1</ReturnReceipt>\r\n" + 
							"			</Request>\r\n" + 
							"			<Pharmacy>\r\n" + 
							"				<Identification>\r\n" + 
							"					<NCPDPID>1111111</NCPDPID>\r\n" + 
							"					<NPI>1346242278</NPI>\r\n" + 
							"				</Identification>\r\n" + 
							"				<StoreName>Costco DEV4 Pharmacy</StoreName>\r\n" + 
							"				<Address>\r\n" + 
							"					<AddressLine1>21930 SE 51st St,</AddressLine1>\r\n" + 
							"					<AddressLine2>ADDITIONAL PHARM ADDR W/ 35 MAX LEN</AddressLine2>\r\n" + 
							"					<City>IN Test</City>\r\n" + 
							"					<State>IN</State>\r\n" + 
							"					<ZipCode>98029</ZipCode>\r\n" + 
							"					<PlaceLocationQualifier>AD2</PlaceLocationQualifier>\r\n" + 
							"				</Address>\r\n" + 
							"				<CommunicationNumbers>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>4254277532</Number>\r\n" + 
							"						<Qualifier>FX</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>4253132521</Number>\r\n" + 
							"						<Qualifier>TE</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>4253132521</Number>\r\n" + 
							"						<Qualifier>WP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>4253132521</Number>\r\n" + 
							"						<Qualifier>HP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>4253132521</Number>\r\n" + 
							"						<Qualifier>NP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>4253132521</Number>\r\n" + 
							"						<Qualifier>NP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>4253132521</Number>\r\n" + 
							"						<Qualifier>BN</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>patti.freeman@erxnetwork.com</Number>\r\n" + 
							"						<Qualifier>EM</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"				</CommunicationNumbers>\r\n" + 
							"			</Pharmacy>\r\n" + 
							"			<Prescriber>\r\n" + 
							"				<Identification>\r\n" + 
							"					<DEANumber>AB1234563</DEANumber>\r\n" + 
							"					<NPI>1234567890</NPI>\r\n" + 
							"					<HIN>123456789</HIN>\r\n" + 
							"				</Identification>\r\n" + 
							"				<Specialty>207K00000X</Specialty>\r\n" + 
							"				<Name>\r\n" + 
							"					<LastName>TEST PRESCRIBER</LastName>\r\n" + 
							"					<FirstName>TESTFIRST106EDFCTSCRIPTDRTCP-1MAXED</FirstName>\r\n" + 
							"					<MiddleName>PHYSICIAN MIDDLE NAME POPULATED W35</MiddleName>\r\n" + 
							"					<Suffix>PHYSUFFIX.</Suffix>\r\n" + 
							"					<Prefix>PHYPREFIX.</Prefix>\r\n" + 
							"				</Name>\r\n" + 
							"				<Address>\r\n" + 
							"					<AddressLine1>1234 This is a maxed out address1YY</AddressLine1>\r\n" + 
							"					<AddressLine2>ADDITIONAL PHYSIC ADDR W/35 MAX LEN</AddressLine2>\r\n" + 
							"					<City>LONG CITY NAME 4 PHYSICIAN CTY W/35</City>\r\n" + 
							"					<State>IN</State>\r\n" + 
							"					<ZipCode>23456</ZipCode>\r\n" + 
							"					<PlaceLocationQualifier>AD2</PlaceLocationQualifier>\r\n" + 
							"				</Address>\r\n" + 
							"				<CommunicationNumbers>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>1113334321X1234</Number>\r\n" + 
							"						<Qualifier>WP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>1111114321X1231</Number>\r\n" + 
							"						<Qualifier>TE</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>1112224321</Number>\r\n" + 
							"						<Qualifier>FX</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>1114444321</Number>\r\n" + 
							"						<Qualifier>HP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>1115554321</Number>\r\n" + 
							"						<Qualifier>NP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>1116664321</Number>\r\n" + 
							"						<Qualifier>CP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>1117774321</Number>\r\n" + 
							"						<Qualifier>BN</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>patti.freeman@erxnetwork.com</Number>\r\n" + 
							"						<Qualifier>EM</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"				</CommunicationNumbers>\r\n" + 
							"				<PrescriberAgent>\r\n" + 
							"					<LastName>AGENT&apos;S LAST NAME POPULATED WITH 35</LastName>\r\n" + 
							"					<FirstName>AGENT&apos;S FIRSTNAME POPULATED WITH 35</FirstName>\r\n" + 
							"					<MiddleName>AGENT&apos;S MIDDLE NAME POPULATED W /35</MiddleName>\r\n" + 
							"					<Suffix>AGENTSUFFX</Suffix>\r\n" + 
							"					<Prefix>AGENTPREFX</Prefix>\r\n" + 
							"				</PrescriberAgent>\r\n" + 
							"			</Prescriber>\r\n" + 
							"			<Supervisor>\r\n" + 
							"				<Identification>\r\n" + 
							"					<StateLicenseNumber>OC1234567</StateLicenseNumber>\r\n" + 
							"					<FileID>12345678901234567890</FileID>\r\n" + 
							"					<DEANumber>AB9876543</DEANumber>\r\n" + 
							"				</Identification>\r\n" + 
							"				<Name>\r\n" + 
							"					<LastName>SUPERVISOR LAST NAME POPULATED W/35</LastName>\r\n" + 
							"					<FirstName>SUPERVISOR FIRST NAME POPULATED W35</FirstName>\r\n" + 
							"					<MiddleName>SUPERVISOR MID NAME POPULATED W/ 35</MiddleName>\r\n" + 
							"					<Suffix>SUPRVSRSUF</Suffix>\r\n" + 
							"					<Prefix>SUPRVSRPRE</Prefix>\r\n" + 
							"				</Name>\r\n" + 
							"				<Address>\r\n" + 
							"					<AddressLine1>1234567890 ADDRESS 4 SUPERVISOR W35</AddressLine1>\r\n" + 
							"					<AddressLine2>ADDITIONAL SUPRVSR ADDR W35 MAX LEN</AddressLine2>\r\n" + 
							"					<City>LONG CITY NAME 4 SUPERVISOR CTY W35</City>\r\n" + 
							"					<State>OK</State>\r\n" + 
							"					<ZipCode>34567</ZipCode>\r\n" + 
							"					<PlaceLocationQualifier>AD2</PlaceLocationQualifier>\r\n" + 
							"				</Address>\r\n" + 
							"				<CommunicationNumbers>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>2221114321X1231</Number>\r\n" + 
							"						<Qualifier>TE</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>2222224321</Number>\r\n" + 
							"						<Qualifier>FX</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>2223334321X1234</Number>\r\n" + 
							"						<Qualifier>WP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>2224444321</Number>\r\n" + 
							"						<Qualifier>HP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>2225554321</Number>\r\n" + 
							"						<Qualifier>NP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>2226664321</Number>\r\n" + 
							"						<Qualifier>CP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>2227774321</Number>\r\n" + 
							"						<Qualifier>BN</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>patti.freeman@erxnetwork.com</Number>\r\n" + 
							"						<Qualifier>EM</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"				</CommunicationNumbers>\r\n" + 
							"			</Supervisor>\r\n" + 
							"			<Facility>\r\n" + 
							"				<Identification>\r\n" + 
							"					<NCPDPID>6503039</NCPDPID>\r\n" + 
							"					<DEANumber>EX12345667</DEANumber>\r\n" + 
							"					<FacilityID>1J</FacilityID>\r\n" + 
							"				</Identification>\r\n" + 
							"				<FacilityName>LONG FACILITY  NAME POPULATED  W/35</FacilityName>\r\n" + 
							"				<Address>\r\n" + 
							"					<AddressLine1>LONG FACILITYADDRESS POPULATED W/35</AddressLine1>\r\n" + 
							"					<AddressLine2>LONG FACILITYADDRESS POPULATED W/35</AddressLine2>\r\n" + 
							"					<City>LONG CITY NAME 4 FACILITY CTY W35</City>\r\n" + 
							"					<State>TX</State>\r\n" + 
							"					<ZipCode>76102</ZipCode>\r\n" + 
							"					<PlaceLocationQualifier>AD2</PlaceLocationQualifier>\r\n" + 
							"				</Address>\r\n" + 
							"				<CommunicationNumbers>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>2221114321X1231</Number>\r\n" + 
							"						<Qualifier>TE</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>2222224321</Number>\r\n" + 
							"						<Qualifier>FX</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>2223334321X1234</Number>\r\n" + 
							"						<Qualifier>WP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>2224444321</Number>\r\n" + 
							"						<Qualifier>HP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>2225554321</Number>\r\n" + 
							"						<Qualifier>NP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>2226664321</Number>\r\n" + 
							"						<Qualifier>CP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>2227774321</Number>\r\n" + 
							"						<Qualifier>BN</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>patti.freeman@erxnetwork.com</Number>\r\n" + 
							"						<Qualifier>EM</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"				</CommunicationNumbers>\r\n" + 
							"			</Facility>\r\n" + 
							"			<Patient>\r\n" + 
							"				<PatientRelationship>1</PatientRelationship>\r\n" + 
							"				<Identification>\r\n" + 
							"					<SocialSecurity>666888888</SocialSecurity>\r\n" + 
							"				</Identification>\r\n" + 
							"				<Name>\r\n" + 
							"					<LastName>Porter</LastName>\r\n" + 
							"					<FirstName>Jack</FirstName>\r\n" + 
							"					<MiddleName/>\r\n" + 
							"				</Name>\r\n" + 
							"				<Gender>M</Gender>\r\n" + 
							"				<DateOfBirth>\r\n" + 
							"					<Date>1988-03-03</Date>\r\n" + 
							"				</DateOfBirth>\r\n" + 
							"				<Address>\r\n" + 
							"					<AddressLine1>234123Street</AddressLine1>\r\n" + 
							"					<AddressLine2>ADDITIONAL</AddressLine2>\r\n" + 
							"					<City>LONGCITYNAME4PATIENTSCITY</City>\r\n" + 
							"					<State>CA</State>\r\n" + 
							"					<ZipCode>78901</ZipCode>\r\n" + 
							"					<PlaceLocationQualifier>AD2</PlaceLocationQualifier>\r\n" + 
							"				</Address>\r\n" + 
							"				<CommunicationNumbers>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>3334444321</Number>\r\n" + 
							"						<Qualifier>HP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>3331114321</Number>\r\n" + 
							"						<Qualifier>TE</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>3332224321</Number>\r\n" + 
							"						<Qualifier>FX</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>3333334321x1234</Number>\r\n" + 
							"						<Qualifier>WP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>3335554321</Number>\r\n" + 
							"						<Qualifier>NP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>3336664321</Number>\r\n" + 
							"						<Qualifier>CP</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>3337774321</Number>\r\n" + 
							"						<Qualifier>BN</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"					<Communication>\r\n" + 
							"						<Number>patti.freeman@erxnetwork.com</Number>\r\n" + 
							"						<Qualifier>EM</Qualifier>\r\n" + 
							"					</Communication>\r\n" + 
							"				</CommunicationNumbers>\r\n" + 
							"			</Patient>\r\n" + 
							"			<MedicationPrescribed>\r\n" + 
							"				<DrugDescription>MAXED OUT ITEM DESCRIP PRES LINE 2.MAXED OUT ITEM DESCRIP PRES LINE 3.MAXED OUT ITEM DESCRIP PRES LINE 4.</DrugDescription>\r\n" + 
							"				<DrugCoded>\r\n" + 
							"					<ProductCode>01234567890_/ABCDEFGHIJKLMNOPQRSTUZ</ProductCode>\r\n" + 
							"					<ProductCodeQualifier>ND</ProductCodeQualifier>\r\n" + 
							"					<Strength>DRU-010-06 FREE TEXT NOTES DRU/PRESCRIBED. THIS FIELD HAS 70 CHARACTER</Strength>\r\n" + 
							"					<DrugDBCode>DRUG REGERENCE NUMBER 35 CHARACTERS</DrugDBCode>\r\n" + 
							"					<DrugDBCodeQualifier>SCD</DrugDBCodeQualifier>\r\n" + 
							"					<FormSourceCode>AA</FormSourceCode>\r\n" + 
							"					<FormCode>C42998</FormCode>\r\n" + 
							"					<StrengthSourceCode>AB</StrengthSourceCode>\r\n" + 
							"					<StrengthCode>C28253</StrengthCode>\r\n" + 
							"				</DrugCoded>\r\n" + 
							"				<Quantity>\r\n" + 
							"					<Value>60</Value>\r\n" + 
							"					<CodeListQualifier>38</CodeListQualifier>\r\n" + 
							"					<UnitSourceCode>AC</UnitSourceCode>\r\n" + 
							"					<PotencyUnitCode>C48542</PotencyUnitCode>\r\n" + 
							"				</Quantity>\r\n" + 
							"				<DaysSupply>30</DaysSupply>\r\n" + 
							"				<Directions>TS4E1 TAKE ONE TABLET TWICE A DAY-THIS IS A TEST-MAXED SIG PRES 70 CH.LINE2 TAKE ONE TABLET TWICE A DAY-THIS IS A TEST-MAXED SIG PRES 70 CH.</Directions>\r\n" + 
							"				<Note>L1 FREE TEXT NOTES DRU/PRESCRIBED. THIS FIELD HAS 70 CHARACTERS. 1234.L2 FREE TEXT NOTES DRU/PRESCRIBED. THIS FIELD HAS 70 CHARACTERS. 1234.L3 FREE TEXT NOTES DRU/PRESCRIBED. THIS FIELD HAS 70 CHARACTERS. 1234.</Note>\r\n" + 
							"				<Refills>\r\n" + 
							"					<Qualifier>PRN</Qualifier>\r\n" + 
							"				</Refills>\r\n" + 
							"				<Substitutions>1</Substitutions>\r\n" + 
							"				<WrittenDate>\r\n" + 
							"					<Date>2015-05-28</Date>\r\n" + 
							"				</WrittenDate>\r\n" + 
							"				<ExpirationDate>\r\n" + 
							"					<Date>2015-05-28</Date>\r\n" + 
							"				</ExpirationDate>\r\n" + 
							"				<EffectiveDate>\r\n" + 
							"					<Date>2015-05-28</Date>\r\n" + 
							"				</EffectiveDate>\r\n" + 
							"				<PeriodEnd>\r\n" + 
							"					<Date>2015-05-28</Date>\r\n" + 
							"				</PeriodEnd>\r\n" + 
							"				<DateValidated>\r\n" + 
							"					<Date>2015-05-28</Date>\r\n" + 
							"				</DateValidated>\r\n" + 
							"				<Diagnosis>\r\n" + 
							"					<ClinicalInformationQualifier>2</ClinicalInformationQualifier>\r\n" + 
							"					<Primary>\r\n" + 
							"						<Qualifier>ABF</Qualifier>\r\n" + 
							"						<Value>PRIMARYDIAGCODE.1</Value>\r\n" + 
							"					</Primary>\r\n" + 
							"					<Secondary>\r\n" + 
							"						<Qualifier>DX</Qualifier>\r\n" + 
							"						<Value>SECOND.DIAGCODE.1</Value>\r\n" + 
							"					</Secondary>\r\n" + 
							"				</Diagnosis>\r\n" + 
							"				<Diagnosis>\r\n" + 
							"					<ClinicalInformationQualifier>1</ClinicalInformationQualifier>\r\n" + 
							"					<Primary>\r\n" + 
							"						<Qualifier>DX</Qualifier>\r\n" + 
							"						<Value>PRIMARYDIAGCODE.2</Value>\r\n" + 
							"					</Primary>\r\n" + 
							"					<Secondary>\r\n" + 
							"						<Qualifier>ABF</Qualifier>\r\n" + 
							"						<Value>SECOND.DIAGCODE.2</Value>\r\n" + 
							"					</Secondary>\r\n" + 
							"				</Diagnosis>\r\n" + 
							"				<PriorAuthorization>\r\n" + 
							"					<Qualifier>G1</Qualifier>\r\n" + 
							"					<Value>1234567890abcdefghij9876543210abcde</Value>\r\n" + 
							"				</PriorAuthorization>\r\n" + 
							"				<DrugUseEvaluation>\r\n" + 
							"					<ServiceReasonCode>AD</ServiceReasonCode>\r\n" + 
							"					<ProfessionalServiceCode>00</ProfessionalServiceCode>\r\n" + 
							"					<ServiceResultCode>00</ServiceResultCode>\r\n" + 
							"					<CoAgent>\r\n" + 
							"						<CoAgentID>AN..19.DRU-100-04_1</CoAgentID>\r\n" + 
							"						<CoAgentQualifier>01</CoAgentQualifier>\r\n" + 
							"					</CoAgent>\r\n" + 
							"				</DrugUseEvaluation>\r\n" + 
							"				<DrugUseEvaluation>\r\n" + 
							"					<ServiceReasonCode>AN</ServiceReasonCode>\r\n" + 
							"					<ProfessionalServiceCode>TH</ProfessionalServiceCode>\r\n" + 
							"					<ServiceResultCode>00</ServiceResultCode>\r\n" + 
							"					<CoAgent>\r\n" + 
							"						<CoAgentID>AN..19.DRU-100-04_2</CoAgentID>\r\n" + 
							"						<CoAgentQualifier>03</CoAgentQualifier>\r\n" + 
							"					</CoAgent>\r\n" + 
							"				</DrugUseEvaluation>\r\n" + 
							"				<DrugUseEvaluation>\r\n" + 
							"					<ServiceReasonCode>AR</ServiceReasonCode>\r\n" + 
							"					<ProfessionalServiceCode>TC</ProfessionalServiceCode>\r\n" + 
							"					<ServiceResultCode>1A</ServiceResultCode>\r\n" + 
							"					<CoAgent>\r\n" + 
							"						<CoAgentID>AN..19.DRU-100-04_3</CoAgentID>\r\n" + 
							"						<CoAgentQualifier>07</CoAgentQualifier>\r\n" + 
							"					</CoAgent>\r\n" + 
							"				</DrugUseEvaluation>\r\n" + 
							"				<DrugUseEvaluation>\r\n" + 
							"					<ServiceReasonCode>AT</ServiceReasonCode>\r\n" + 
							"					<ProfessionalServiceCode>SW</ProfessionalServiceCode>\r\n" + 
							"					<ServiceResultCode>1B</ServiceResultCode>\r\n" + 
							"					<CoAgent>\r\n" + 
							"						<CoAgentID>AN..19.DRU-100-04_4</CoAgentID>\r\n" + 
							"						<CoAgentQualifier>09</CoAgentQualifier>\r\n" + 
							"					</CoAgent>\r\n" + 
							"				</DrugUseEvaluation>\r\n" + 
							"				<DrugUseEvaluation>\r\n" + 
							"					<ServiceReasonCode>CD</ServiceReasonCode>\r\n" + 
							"					<ProfessionalServiceCode>SC</ProfessionalServiceCode>\r\n" + 
							"					<ServiceResultCode>1C</ServiceResultCode>\r\n" + 
							"					<CoAgent>\r\n" + 
							"						<CoAgentID>AN..19.DRU-100-04_5</CoAgentID>\r\n" + 
							"						<CoAgentQualifier>12</CoAgentQualifier>\r\n" + 
							"					</CoAgent>\r\n" + 
							"				</DrugUseEvaluation>\r\n" + 
							"				<DrugCoverageStatusCode>PR</DrugCoverageStatusCode>\r\n" + 
							"				<DrugCoverageStatusCode>AP</DrugCoverageStatusCode>\r\n" + 
							"				<DrugCoverageStatusCode>PA</DrugCoverageStatusCode>\r\n" + 
							"				<DrugCoverageStatusCode>NF</DrugCoverageStatusCode>\r\n" + 
							"				<DrugCoverageStatusCode>NR</DrugCoverageStatusCode>\r\n" + 
							"				<PriorAuthorizationStatus>N</PriorAuthorizationStatus>\r\n" + 
							"				<StructuredSIG>\r\n" + 
							"					<RepeatingSIG>\r\n" + 
							"						<SigSequencePositionNumber>14</SigSequencePositionNumber>\r\n" + 
							"						<MultipleSigModifier>AND</MultipleSigModifier>\r\n" + 
							"					</RepeatingSIG>\r\n" + 
							"					<CodeSystem>\r\n" + 
							"						<SNOMEDVersion>SNOMED an..14.</SNOMEDVersion>\r\n" + 
							"						<FMTVersion>FMTVers an..14</FMTVersion>\r\n" + 
							"					</CodeSystem>\r\n" + 
							"					<FreeText>\r\n" + 
							"						<SigFreeTextStringIndicator>2</SigFreeTextStringIndicator>\r\n" + 
							"						<SigFreeText>SIG Free Text an..140. Value 2. Recons from structured Sig. The Structured SIG Segment free text used and its a direct trans of codified SIG</SigFreeText>\r\n" + 
							"					</FreeText>\r\n" + 
							"					<Dose>\r\n" + 
							"						<DoseCompositeIndicator>1</DoseCompositeIndicator>\r\n" + 
							"						<DoseDeliveryMethodText>an..50. The method in which the dose is delivered.</DoseDeliveryMethodText>\r\n" + 
							"						<DoseDeliveryMethodCodeQualifier>1</DoseDeliveryMethodCodeQualifier>\r\n" + 
							"						<DoseDeliveryMethodCode>an..15.DelMeth.</DoseDeliveryMethodCode>\r\n" + 
							"						<DoseDeliveryMethodModifierText>an..50 Dose Delivery Method Modifier Text.SIG04005</DoseDeliveryMethodModifierText>\r\n" + 
							"						<DoseDeliveryMethodModifierCodeQualifier>1</DoseDeliveryMethodModifierCodeQualifier>\r\n" + 
							"						<DoseDeliveryMethodModifierCode>an..15.ModText.</DoseDeliveryMethodModifierCode>\r\n" + 
							"						<DoseQuantity>98765432109876</DoseQuantity>\r\n" + 
							"						<DoseFormText>an..50 Dose Form Text. SIG-040-09.123456.7890.1234</DoseFormText>\r\n" + 
							"						<DoseFormCodeQualifier>2</DoseFormCodeQualifier>\r\n" + 
							"						<DoseFormCode>an..15DseFrmCde</DoseFormCode>\r\n" + 
							"						<DoseRangeModifier>TO</DoseRangeModifier>\r\n" + 
							"					</Dose>\r\n" + 
							"					<DoseCalculation>\r\n" + 
							"						<DosingBasisNumericValue>1234567890123</DosingBasisNumericValue>\r\n" + 
							"						<DosingBasisUnitofMeasureText>an..50 Dosing Basis Unit of Measure Text. 12345678</DosingBasisUnitofMeasureText>\r\n" + 
							"						<DosingBasisUnitofMeasureCodeQualifier>1</DosingBasisUnitofMeasureCodeQualifier>\r\n" + 
							"						<DosingBasisUnitofMeasureCode>an..15MsureCode</DosingBasisUnitofMeasureCode>\r\n" + 
							"						<BodyMetricQualifier>2</BodyMetricQualifier>\r\n" + 
							"						<BodyMetricValue>8523697410987</BodyMetricValue>\r\n" + 
							"						<CalculatedDoseNumeric>74125896301236</CalculatedDoseNumeric>\r\n" + 
							"						<CalculatedDoseUnitofMeasureText>an..50 Calculated Dose Unit Measure Txt SIG-050-08</CalculatedDoseUnitofMeasureText>\r\n" + 
							"						<CalculatedDoseUnitofMeasureCodeQualifier>2</CalculatedDoseUnitofMeasureCodeQualifier>\r\n" + 
							"						<CalculatedDoseUnitofMeasureCode>an..15 MeasCode</CalculatedDoseUnitofMeasureCode>\r\n" + 
							"						<DosingBasisRangeModifier>OR</DosingBasisRangeModifier>\r\n" + 
							"					</DoseCalculation>\r\n" + 
							"					<Vehicle>\r\n" + 
							"						<VehicleName>an..50 Vehicle Name SIG-060-01. ABCD.1234.EFGH.567</VehicleName>\r\n" + 
							"						<VehicleNameCodeQualifier>1</VehicleNameCodeQualifier>\r\n" + 
							"						<VehicleNameCode>an..15VclNmeCde</VehicleNameCode>\r\n" + 
							"						<VehicleQuantity>1596374280123</VehicleQuantity>\r\n" + 
							"						<VehicleUnitOfMeasureText>an..50 Vehicle Unit Of Measure Text SIG-060-05.AN1</VehicleUnitOfMeasureText>\r\n" + 
							"						<VehicleUnitOfMeasureCodeQualifier>1</VehicleUnitOfMeasureCodeQualifier>\r\n" + 
							"						<VehicleUnitOfMeasureCode>an..15VclMCode.</VehicleUnitOfMeasureCode>\r\n" + 
							"						<MultipleVehicleModifier>AND</MultipleVehicleModifier>\r\n" + 
							"					</Vehicle>\r\n" + 
							"					<RouteofAdministration>\r\n" + 
							"						<RouteofAdministrationText>an..50 Route of Administration Text. SIG-070-01.a1</RouteofAdministrationText>\r\n" + 
							"						<RouteofAdministrationCodeQualifier>2</RouteofAdministrationCodeQualifier>\r\n" + 
							"						<RouteofAdministrationCode>an..15RteAdminC</RouteofAdministrationCode>\r\n" + 
							"						<MultipleRouteofAdministrationModifier>OR</MultipleRouteofAdministrationModifier>\r\n" + 
							"					</RouteofAdministration>\r\n" + 
							"					<SiteofAdministration>\r\n" + 
							"						<SiteofAdministrationText>an..50 Site of Administration Text. SIG-080-01.ab1</SiteofAdministrationText>\r\n" + 
							"						<SiteofAdministrationCodeQualifier>2</SiteofAdministrationCodeQualifier>\r\n" + 
							"						<SiteofAdministrationCode>an..15AdminCode</SiteofAdministrationCode>\r\n" + 
							"						<MultipleAdministrationTimingModifier>NOT</MultipleAdministrationTimingModifier>\r\n" + 
							"					</SiteofAdministration>\r\n" + 
							"					<Timing>\r\n" + 
							"						<AdministrationTimingText>an..50 Administration Timing Text SIG-090-01.xyz12</AdministrationTimingText>\r\n" + 
							"						<AdministrationTimingCodeQualifier>1</AdministrationTimingCodeQualifier>\r\n" + 
							"						<AdministrationTimingCode>an..15AdminTCod</AdministrationTimingCode>\r\n" + 
							"						<MultipleAdministrationTimingModifier>AND</MultipleAdministrationTimingModifier>\r\n" + 
							"						<RateofAdministration>an..11RAdm.</RateofAdministration>\r\n" + 
							"						<RateUnitofMeasureText>an..50 Rate Unit of Measure Text SIG-090-06.GE1RT%</RateUnitofMeasureText>\r\n" + 
							"						<RateUnitofMeasureCodeQualifier>2</RateUnitofMeasureCodeQualifier>\r\n" + 
							"						<RateUnitofMeasureCode>an..15RUMCode.1</RateUnitofMeasureCode>\r\n" + 
							"						<TimePeriodBasisText>an..50 Time Period Basis Text. SIG-090-09. abke789</TimePeriodBasisText>\r\n" + 
							"						<TimePeriodBasisCodeQualifier>2</TimePeriodBasisCodeQualifier>\r\n" + 
							"						<TimePeriodBasisCode>an..15TPBasisCo</TimePeriodBasisCode>\r\n" + 
							"						<FrequencyNumericValue>an..11FNumV</FrequencyNumericValue>\r\n" + 
							"						<FrequencyUnitsText>an..50 Frequency Units Text., SIG-090-13.ETX3454%1</FrequencyUnitsText>\r\n" + 
							"						<FrequencyUnitsCodeQualifier>1</FrequencyUnitsCodeQualifier>\r\n" + 
							"						<FrequencyUnitsCode>an..15FreqUCode</FrequencyUnitsCode>\r\n" + 
							"						<VariableFrequencyModifier>AND</VariableFrequencyModifier>\r\n" + 
							"						<IntervalNumericValue>7418529330258</IntervalNumericValue>\r\n" + 
							"						<IntervalUnitsText>an..50 Interval Units Text. SIG-090-18.kndkl123%k6</IntervalUnitsText>\r\n" + 
							"						<IntervalUnitsCodeQualifier>2</IntervalUnitsCodeQualifier>\r\n" + 
							"						<IntervalUnitsCode>an..15IntUCode.</IntervalUnitsCode>\r\n" + 
							"						<VariableIntervalModifier>TO</VariableIntervalModifier>\r\n" + 
							"					</Timing>\r\n" + 
							"					<Duration>\r\n" + 
							"						<DurationNumericValue>an..11DNumV</DurationNumericValue>\r\n" + 
							"						<DurationText>an..50 Duration Text. SIG-100-02.DJGKE1234ERT567DR</DurationText>\r\n" + 
							"						<DurationTextCodeQualifier>1</DurationTextCodeQualifier>\r\n" + 
							"						<DurationTextCode>an..15DurTxtCod</DurationTextCode>\r\n" + 
							"					</Duration>\r\n" + 
							"					<MaximumDoseRestriction>\r\n" + 
							"						<MaximumDoseRestrictionNumericValue>6543210987741</MaximumDoseRestrictionNumericValue>\r\n" + 
							"						<MaximumDoseRestrictionUnitsText>an..50 Maximum Dose Restrict Units Text.SIG-110-02</MaximumDoseRestrictionUnitsText>\r\n" + 
							"						<MaximumDoseRestrictionCodeQualifier>2</MaximumDoseRestrictionCodeQualifier>\r\n" + 
							"						<MaximumDoseRestrictionUnitsCode>!</MaximumDoseRestrictionUnitsCode>\r\n" + 
							"						<MaximumDoseRestrictionVariableNumericValue>32165498701245</MaximumDoseRestrictionVariableNumericValue>\r\n" + 
							"						<MaximumDoseRestrictionVariableUnitsText>an..50 Maximum Dose Restriction Variable Units Txt</MaximumDoseRestrictionVariableUnitsText>\r\n" + 
							"						<MaximumDoseRestrictionVariableUnitsCodeQualifier>1</MaximumDoseRestrictionVariableUnitsCodeQualifier>\r\n" + 
							"						<MaximumDoseRestrictionVariableUnitsCode>50TEST</MaximumDoseRestrictionVariableUnitsCode>\r\n" + 
							"						<MaximumDoseRestrictionVariableDurationModifier>AND</MaximumDoseRestrictionVariableDurationModifier>\r\n" + 
							"					</MaximumDoseRestriction>\r\n" + 
							"					<Indication>\r\n" + 
							"						<IndicationPrecursorText>an..50 Indication Precursor Text. SIG-120-01.8*():</IndicationPrecursorText>\r\n" + 
							"						<IndicationPrecursorCodeQualifier>1</IndicationPrecursorCodeQualifier>\r\n" + 
							"						<IndicationPrecursorCode>an..15IPCode234</IndicationPrecursorCode>\r\n" + 
							"						<IndicationText>an..50 Indication Text. SIG-120-04.ABE345%kio456:/</IndicationText>\r\n" + 
							"						<IndicationTextCodeQualifier>2</IndicationTextCodeQualifier>\r\n" + 
							"						<IndicationTextCode>an..15OTxtCode&gt;</IndicationTextCode>\r\n" + 
							"						<IndicationValueText>an..50 Indication Value Text. SIG-120-07.iop*ke%:&gt;</IndicationValueText>\r\n" + 
							"						<IndicationValueUnit>7531234689014</IndicationValueUnit>\r\n" + 
							"						<IndicationValueUnitofMeasureText>an..50 IndicationValueUnitofMeasureTxt SIG-120-09&gt;</IndicationValueUnitofMeasureText>\r\n" + 
							"						<IndicationValueUnitofMeasureCodeQualifier>1</IndicationValueUnitofMeasureCodeQualifier>\r\n" + 
							"						<IndicationValueUnitofMeasureCode>an..15 IVUOMC/&lt;</IndicationValueUnitofMeasureCode>\r\n" + 
							"						<IndicationVariableModifier>TO</IndicationVariableModifier>\r\n" + 
							"					</Indication>\r\n" + 
							"					<Stop>\r\n" + 
							"						<StopIndicator>N</StopIndicator>\r\n" + 
							"					</Stop>\r\n" + 
							"				</StructuredSIG>\r\n" + 
							"			</MedicationPrescribed>\r\n" + 
							"			<Observation>\r\n" + 
							"				<Measurement>\r\n" + 
							"					<Dimension>HT</Dimension>\r\n" + 
							"					<Value>12345678901234</Value>\r\n" + 
							"					<ObservationDate>\r\n" + 
							"						<Date>2012-02-23</Date>\r\n" + 
							"					</ObservationDate>\r\n" + 
							"					<MeasurementSourceCode>AA</MeasurementSourceCode>\r\n" + 
							"					<MeasurementUnitCode>abcdefg01234567</MeasurementUnitCode>\r\n" + 
							"				</Measurement>\r\n" + 
							"				<ObservationNotes>10R6C1328SNLVY158ADSKFAJVFNL73P4K087318U8OTK2R820XSNLVY158ADSKFAJTHY98</ObservationNotes>\r\n" + 
							"			</Observation>\r\n" + 
							"			<BenefitsCoordination>\r\n" + 
							"				<PayerIdentification>\r\n" + 
							"					<ProcessorIdentificationNumber>TESTPCN1TESTPCN1TESTPCN1TESTPCN1end</ProcessorIdentificationNumber>\r\n" + 
							"				</PayerIdentification>\r\n" + 
							"				<PayerName>MEDCOMEDCOMEDCOMEDCOMEDCOMEDCOMEend</PayerName>\r\n" + 
							"				<CardholderID>W13712271W13712271W13712271W1371end</CardholderID>\r\n" + 
							"				<CardHolderName>\r\n" + 
							"					<LastName>COO1 LAST NAME HAS 35 CHARACTERS...</LastName>\r\n" + 
							"					<FirstName>COO1 FIRST NAME HAS 35 CHARACTERS..</FirstName>\r\n" + 
							"					<MiddleName>COO1 MIDDLE NAME HAS 35 CHARACTERS.</MiddleName>\r\n" + 
							"					<Suffix>COO1 SUFIX</Suffix>\r\n" + 
							"					<Prefix>COO1.PREFX</Prefix>\r\n" + 
							"				</CardHolderName>\r\n" + 
							"				<GroupID>NCB3000R020300NCB3000R020300NCB3end</GroupID>\r\n" + 
							"			</BenefitsCoordination>\r\n" + 
							"			<BenefitsCoordination>\r\n" + 
							"				<PayerIdentification>\r\n" + 
							"					<BINLocationNumber>00385800385800385800385800385800end</BINLocationNumber>\r\n" + 
							"				</PayerIdentification>\r\n" + 
							"				<PayerName>ExpressScriptsExpressScriptsExprend</PayerName>\r\n" + 
							"				<CardholderID>76231080997623108099762310809976end</CardholderID>\r\n" + 
							"				<CardHolderName>\r\n" + 
							"					<LastName>COO2 LAST NAME HAS 35 CHARACTERS...</LastName>\r\n" + 
							"					<FirstName>COO2 FIRST NAME HAS 35 CHARACTERS..</FirstName>\r\n" + 
							"					<MiddleName>COO2 MIDDLE NAME HAS 35 CHARACTERS.</MiddleName>\r\n" + 
							"					<Suffix>COO2 SUFIX</Suffix>\r\n" + 
							"					<Prefix>COO2.PREFX</Prefix>\r\n" + 
							"				</CardHolderName>\r\n" + 
							"				<GroupID>BSLABSLABSLABSLABSLABSLABSLABSLAend</GroupID>\r\n" + 
							"			</BenefitsCoordination>\r\n" + 
							"			<BenefitsCoordination>\r\n" + 
							"				<PayerIdentification>\r\n" + 
							"					<PayerID>TESTPCN3TESTPCN3TESTPCN3TESTPCN3end</PayerID>\r\n" + 
							"				</PayerIdentification>\r\n" + 
							"				<PayerName>CAREMARKCAREMARKCAREMARKCAREMARKend</PayerName>\r\n" + 
							"				<CardholderID>9755ABC4422XYZ9755ABC4422XYZ9755end</CardholderID>\r\n" + 
							"				<CardHolderName>\r\n" + 
							"					<LastName>COO3 LAST NAME HAS 35 CHARACTERS...</LastName>\r\n" + 
							"					<FirstName>COO3 FIRST NAME HAS 35 CHARACTERS..</FirstName>\r\n" + 
							"					<MiddleName>COO3 MIDDLE NAME HAS 35 CHARACTERS.</MiddleName>\r\n" + 
							"					<Suffix>COO3 SUFIX</Suffix>\r\n" + 
							"					<Prefix>COO3.PREFX</Prefix>\r\n" + 
							"				</CardHolderName>\r\n" + 
							"				<GroupID>8899AA4455ZZ8899AA4455ZZ8899AA44end</GroupID>\r\n" + 
							"			</BenefitsCoordination>\r\n" + 
							"		</NewRx>\r\n" + 
							"	</Body>\r\n" + 
							"</Message>";
				};
			      String[] lines = xmlSample.split("\\r?\\n");
			      int i = 0;
			      ArrayList<String> xmlList = new ArrayList<String>();
			      //String xmlToSend = "";
			      //StringBuilder xmlToSend = new StringBuilder();
			      for (String line : lines ) { 	 
			         //System.out.println("xml("+ i +")=" +line.trim());
			         //xmlToSend.append("xml("+ i +")=" + line.trim() +"\n");
					xmlList.add(i, line.trim());
					i++;
			      }
//			      System.out.println(xmlToSend.toString());
				rpcName = "PSOERXA1 INCERX";
				vReq.setRpcContext("PSO WEB SERVICES OPTION");			 
				vReq.setRpcName(rpcName);
				vReq.clearParams();
				vReq.getParams().setParam(1, "array", xmlList);
				vResp = myConnection.executeRPC(vReq);
				results.append('\n').append(rpcName).append(" Results: \n").append(vResp.getResults()).append('\n');

//				rpcName = "PSOERXA0 PRVMTCH";
//				vReq.setRpcContext("PSO WEB SERVICES OPTION");
//				vReq.setRpcName(rpcName);
//				vReq.clearParams();
//			      vReq.getParams().setParam(1, "string", "2345678934");
//			      vReq.getParams().setParam(2, "string", "");
//			      vReq.getParams().setParam(3, "string", "0");
//				vResp = myConnection.executeRPC(vReq);
//				results.append('\n').append(rpcName).append(" Results: \n").append(vResp.getResults()).append('\n');
//
//				rpcName = "XOBV TEST STRING";
//				vReq.setRpcName(rpcName);
//				vReq.clearParams();
//				vReq.getParams().setParam(1, "string", "This is a test string!");
//				vResp = myConnection.executeRPC(vReq);
//				results.append('\n').append(rpcName).append(" Results: \n").append(vResp.getResults()).append('\n');
//
//				rpcName = "XOBV TEST GLOBAL NODE";
//				vReq.setRpcName(rpcName);
//				vReq.clearParams();
//				vReq.getParams().setParam(1, "string", "Hello World");
//				vResp = myConnection.executeRPC(vReq);
//				results.append('\n').append(rpcName).append(" Results: \n").append(vResp.getResults()).append('\n');
//
//				rpcName = "XOBV TEST RPC LIST";
//				vReq.setRpcName(rpcName);
//				vReq.clearParams();
//				vReq.getParams().setParam(1, "string", "XOB");
//				vResp = myConnection.executeRPC(vReq);
//				results.append('\n').append(rpcName).append(" Results: \n").append(vResp.getResults());

				logger.debug("got results, length: '" + results.length() + "'");

				request.setAttribute("success", "true");

			} catch (VistaLinkFaultException e) {

				logger.error("Exception occurred executing " + rpcName + "\nException:", e);
				results.append("Exception occurred executing ").append(rpcName).append("\nException:").append(
						ExceptionUtils.getFullStackTrace(e));

			} catch (NamingException e) {

				logger.error("Exception occurred executing " + rpcName + "\nException:", e);
				results.append("Exception occurred:\n&nbsp;\n").append(e.getMessage()).append("\n&nbsp;\n").append(
						ExceptionUtils.getFullStackTrace(e));

			} catch (ResourceException e) {

				logger.error("Exception occurred executing " + rpcName + "\nException:", e);
				results.append("Exception occurred:\n&nbsp;\n").append(e.getMessage()).append("\n&nbsp;\n").append(
						ExceptionUtils.getFullStackTrace(e));

			} catch (FoundationsException e) {

				logger.error("Exception occurred executing " + rpcName + "\nException:", e);
				results.append("Exception occurred executing ").append(rpcName).append("\nException:").append(
						ExceptionUtils.getFullStackTrace(e));

			} finally {

				try {
					ic.close();
				} catch (NamingException e) {
					logger.error("Error closing context: ", e);
				}
				if (myConnection != null) {
					try {
						myConnection.close();
					} catch (ResourceException e) {
						logger.error("Error closing connection:", e);
					}
				}
			}
		}

		// display results
		request.setAttribute("results", results.toString());
		dispatcher = getServletContext().getRequestDispatcher(ACTION_RESULTS_PAGE);
		dispatcher.forward(request, response);
	}
}