package gov.va.med.pharmacy.vistalink;

import gov.va.med.environment.Environment;
import gov.va.med.environment.ServerType;

/**
 * Helper functions for the JSP pages.
 * 
 */
public class JSPHelper {

	/**
	 * private constructor to prevent instantiation
	 *
	 */
	private JSPHelper() {
		// private constructor to prevent instantiation
	}
	/**
	 * Return server type
	 * @return
	 */
	public static String getServerType() {
		String returnVal = null;
		try {
			returnVal = getServerTypeInternal();
		} catch (NoClassDefFoundError e) {
			returnVal = "<b>Warning: FoundationsLib classes do not appear to be loaded on the server classpath.</b>";
		}
		return returnVal;
	}

	/**
	 * secondary method so we can catch NoClassDefFoundError
	 * @return
	 */
	private static String getServerTypeInternal() {
		String returnVal = "[not specified]";
		ServerType serverType = Environment.getServerType();
		if (serverType != null) {
			returnVal = serverType.toString();
		}
		return returnVal;
	}

	/**
	 * Return production setting.
	 * @return
	 */
	public static String getProductionSetting() {
		String returnVal = null;
		try {
			returnVal = getProductionSettingInternal();
		} catch (NoClassDefFoundError e) {
			returnVal = "<b>Warning: FoundationsLib classes do not appear to be loaded on the server classpath.</b>";
		}
		return returnVal;
	}

	/**
	 * secondary method so we can catch NoClassDefFoundError
	 * @return
	 */
	private static String getProductionSettingInternal() {
		return Boolean.toString(Environment.isProduction());
	}

	/**
	 * Return true if server is WebLogic
	 * @return
	 */
	public static boolean isWebLogic() {
		boolean returnVal = false;
		ServerType serverType = Environment.getServerType();
		if (ServerType.WEBLOGIC.equals(serverType)) { 
			returnVal = true;
}		return returnVal;
	}
	
}