package gov.va.med.pharmacy.vistalink;

import gov.va.med.vistalink.jmx.IJmxHelper;
import gov.va.med.vistalink.jmx.JmxHelperException;
import gov.va.med.vistalink.jmx.JmxHelperFactory;
import gov.va.med.vistalink.management.VistaLinkConnector;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

import org.apache.log4j.Logger;

/**
 * This class uses "unsupported" (non-public) API calls in VistALink to display a drop-down list of the 
 * currently deployed VistALink connectors. This is to make the sample application more useful as
 * a "testing" application to test the viability of deployed connectors.
 * 
 */
public class ConnectorListHelper {

	private static final Logger logger = Logger.getLogger(ConnectorListHelper.class);

	/**
	 * Use MBean query to query VistALink connector MBeans, return jndi names available
	 * 
	 * @return
	 * @throws Exception
	 */
	public Set getConnectorJndiNameList() throws JmxHelperException, ReflectionException, MalformedObjectNameException,
			InstanceNotFoundException, AttributeNotFoundException, MBeanException {

		TreeSet returnVal = new TreeSet();
		IJmxHelper jmxHelper = JmxHelperFactory.getJmxHelper();
		MBeanServer mBeanServer = jmxHelper.getLocalMBeanServer();

		StringBuffer sb = new StringBuffer(jmxHelper.getJmxDomainForHev());
		sb.append(":Type=").append(VistaLinkConnector.getMBeanType()).append(",*");
		ObjectName vlConnQueryObjectName = new ObjectName(sb.toString());
		logger.debug("About to query with ObjectName: " + vlConnQueryObjectName);
		Set vlConnObjectNameSet = mBeanServer.queryNames(vlConnQueryObjectName, null);
		logger.debug("peformed queryMBeans");

		Iterator vlConnSetIter = vlConnObjectNameSet.iterator();
		while (vlConnSetIter.hasNext()) {

			ObjectName vlConnObjectName = (ObjectName) vlConnSetIter.next();
			// make sure connector type is VistA
			if ("VistA".equals((String) mBeanServer.getAttribute(vlConnObjectName, "EisType"))) {
				String jndiName = (String) mBeanServer.getAttribute(vlConnObjectName, "JndiNameActual");
				returnVal.add(jndiName);
			}
		}

		return returnVal;
	}
}