package gov.va.med.pharmacy.jaxrs.mvi.dao.impl;

import gov.va.med.pharmacy.jaxrs.mvi.dao.PatientSearchDao;
import gov.va.med.pharmacy.jaxrs.mvi.model.Patient;

/**
 * This class acts as Data Access Object layer, calls MVI client and does data
 * processing to build up patient object.
 *
 */

public class PatientSearchDaoImpl implements PatientSearchDao {

	@Override
	public Patient lookupPatientByName(Patient patientSearchObj) throws Exception {


		MVIClient mviClient = new MVIClient();
		
		Patient patientResults;

		try {

			patientResults = mviClient.getMVIData(patientSearchObj);

		} catch (Exception e) {
			e.printStackTrace();
			throw new Exception(e); // let the exception go all the way up.
		}

		return patientResults;

	}

}
