package gov.va.med.pharmacy.jaxrs.drug.dao.impl;

import gov.va.med.pharmacy.jaxrs.drug.dao.DrugSearchDao;
import gov.va.med.pharmacy.jaxrs.drug.model.Drug;

/**
 * This class acts as Data Access Object layer, calls RPC and does data
 * processing to build up drug object.
 *
 */

public class DrugSearchDaoImpl implements DrugSearchDao {

	@Override
	public Drug lookupDrug(Drug drugObj) throws Exception {

			
		Drug drugResults = null;
		DrugRPC drugRPC = new DrugRPC();

		try {

			drugResults = drugRPC.lookupDrug(drugObj);

		} catch (Exception e) {
			e.printStackTrace();
			throw new Exception(e); // let the exception go all the way up.
		}

		return drugResults;

	}

}
