package gov.va.med.pharmacy.jaxrs.drug.dao.impl;

import java.util.LinkedList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import gov.va.med.pharmacy.jaxrs.drug.model.Drug;
import gov.va.med.pharmacy.utility.VistaLinkConnectionUtility;
import gov.va.med.vistalink.rpc.RpcResponse;

/**
 * This class makes RPC call to Vista to get drug information (Drug Check).
 *
 */
public class DrugRPC {

	public Drug lookupDrug(Drug searchObj) throws Exception {

		Drug searchResults = new Drug();

		VistaLinkConnectionUtility vistaLinkConnectionUtility = new VistaLinkConnectionUtility();

		RpcResponse rpcResponse;
		
		String rpcName ="PSOERXA0 DRGMTCH";
		
		String rpcContext ="PSO WEB SERVICES OPTION";
		
		List<String> params = new LinkedList<String>();
		 
        params.add(searchObj.getNdcUPN());
        params.add(searchObj.getDrugDescription());        
         
         

		try {
			rpcResponse = vistaLinkConnectionUtility.sendRequest(rpcContext, rpcName, params);
		} catch (Exception e) {
			throw new Exception(e);
		}

		//LOG.debug("XML Response is: " + rpcResponse.getResults());

		String response = rpcResponse.getResults(); 
		
		
		if(StringUtils.isNotEmpty(response) && (!(response.contains("NDC/UPN match not found.")) ) )
		{
			String vistaIEN = response.substring(0,response.indexOf("^"));
			String drugDetails = response.substring(response.indexOf("^")+1,response.length() );

			searchResults.setVistaIEN(vistaIEN);
			searchResults.setDrugDescription(drugDetails);
			searchResults.setSuccess(true);
		}
		else{
			searchResults.setVistaMessage("NDC/UPN match not found.");
			searchResults.setSuccess(false);
		}
		return searchResults;


	}

}
