DROP TABLE ERX.OUTBOUND_NCPDP_MSG CASCADE CONSTRAINTS ;

CREATE TABLE ERX.OUTBOUND_NCPDP_MSG
  (
    OUTBOUND_NCPDP_MSG_ID NUMBER NOT NULL ,
    MESSAGE_ID            VARCHAR2 (35 BYTE) ,
    REL_TO_MESSAGE_ID     VARCHAR2 (35 BYTE) ,
    MESSAGE_TYPE          VARCHAR2 (35 BYTE) ,
    MESSAGE XMLTYPE ,
    VISTA_MESSAGE CLOB ,
    PHARMACY_ID    NUMBER DEFAULT 0 NOT NULL ENABLE ,
    MESSAGE_STATUS NUMBER NOT NULL ,
    RECEIVED_DATE  DATE ,
    UPDATED_DATE    DATE ,
    CREATED_DATE   DATE
  )
  LOGGING LOB
  (
    VISTA_MESSAGE
  )
  STORE AS
  (
    STORAGE ( PCTINCREASE 0 MINEXTENTS 1 MAXEXTENTS UNLIMITED FREELISTS 1 BUFFER_POOL DEFAULT ) CHUNK 8192 RETENTION ENABLE STORAGE IN ROW NOCACHE LOGGING
  )
  XMLTYPE COLUMN MESSAGE STORE AS BINARY XML
  (
    STORAGE ( PCTINCREASE 0 MINEXTENTS 1 MAXEXTENTS UNLIMITED FREELISTS 1 BUFFER_POOL DEFAULT ) RETENTION ENABLE STORAGE IN ROW NOCACHE
  )
  ALLOW NONSCHEMA ;
CREATE UNIQUE INDEX ERX.OB_NCPDP_MSG_ID_IDX ON ERX.OUTBOUND_NCPDP_MSG
  (
    OUTBOUND_NCPDP_MSG_ID ASC
  )
  LOGGING ;
  CREATE INDEX ERX.OB_NCPDP_MSG_PHARMACY_ID_IDX ON ERX.OUTBOUND_NCPDP_MSG
    (
      PHARMACY_ID ASC
    )
    LOGGING ;
