create or replace TRIGGER ERX.IB_NCPDP_MSG_TRG 
    BEFORE INSERT OR UPDATE ON ERX.INBOUND_NCPDP_MSG 
    FOR EACH ROW 
DECLARE
    xml_status NUMBER;
BEGIN 
IF UPDATING THEN
  :NEW.UPDATED_DATE := SYSDATE;
  IF :NEW.MESSAGE IS NOT NULL THEN
    BEGIN  
      IF (:NEW.MESSAGE.isSchemaValid('http://www.ncpdp.org/schema/SCRIPT/EMD_NCPDP_SCRIPT_10_6_ERX.xsd')) <> 1 THEN
      select nvl(erx_status_id,0) into xml_status from erx_status where code = '3006';
      :NEW.MESSAGE_STATUS := xml_status;
      END IF;
    END;
  END IF;
ELSE
  :NEW.CREATED_DATE := SYSDATE;
   IF :NEW.INBOUND_NCPDP_MSG_ID IS NULL THEN
    :NEW.INBOUND_NCPDP_MSG_ID := IB_NCPDP_MSG_ID_SEQ.NEXTVAL;
   END IF;
   IF :NEW.MESSAGE IS NOT NULL THEN
    BEGIN  
      IF (:NEW.MESSAGE.isSchemaValid('http://www.ncpdp.org/schema/SCRIPT/EMD_NCPDP_SCRIPT_10_6_ERX.xsd')) <> 1 THEN
      select nvl(erx_status_id,0) into xml_status from erx_status where code = '3006';
      :NEW.MESSAGE_STATUS := xml_status;
      END IF;
    END;
  END IF;
END IF;
END;
/


