package gov.va.med.pharmacy.jaxrs.eAnde.dao.impl;
import gov.va.med.pharmacy.jaxrs.eAnde.dao.PatientInfoDao;
import gov.va.med.pharmacy.jaxrs.eAnde.model.PatientInfo;
import gov.va.med.pharmacy.jaxrs.eAnde.services.impl.EESummary_Client;
import gov.va.med.pharmacy.wsclients.eAnde.getEESummaryResponse;


public class PatientInfoWSDao implements PatientInfoDao {
	@Override
	public PatientInfo lookupPatientByKey(String key) throws Exception {
		PatientInfo patientInfo = new PatientInfo();
		EESummary_Client eeClient = new EESummary_Client();
		
		try {
			  getEESummaryResponse eeSummaryResponse = eeClient.returnResponse(key);
			
			patientInfo.setEligibilityStatus(eeSummaryResponse.getSummary().getEligibilityVerificationInfo().getEligibilityStatus());
		} catch (Exception e) {
			
			throw new Exception(e); // let the exception go all the way up.
		}
		
		return patientInfo;
	}
}
