unit uFormUtils;

interface

uses
  Controls, Forms, WinApi.Windows;

type
  TViewMode = (vmParentedForm, vmDialog, vmConfirmationDlg);

procedure setFormParented(aForm: TForm; aParent: TWinControl;
  anAlign: TAlign = alClient);
procedure ListViewClearSortIndicator(aHandle:HWND; aColumn: Integer);

implementation
uses
  WinApi.CommCtrl;

procedure setFormParented(aForm: TForm; aParent: TWinControl;
  anAlign: TAlign = alClient);
begin
  if aForm.Parent <> aParent then
  begin
    aForm.BorderStyle := bsNone;
    aForm.Parent := aParent;
    aForm.Align := anAlign;
    aForm.Menu := nil;
    aForm.Show;
  end;
end;

procedure ListViewClearSortIndicator(aHandle:HWND; aColumn: Integer);
var
  Header: HWND;
  Item: THDItem;
begin
  Header := ListView_GetHeader(aHandle);
  ZeroMemory(@Item, SizeOf(Item));
  Item.Mask := HDI_FORMAT;

  // Clear the previous arrow
  Header_GetItem(Header, aColumn, Item);
  Item.fmt := Item.fmt and not (HDF_SORTUP or HDF_SORTDOWN);//remove both flags
  Header_SetItem(Header, aColumn, Item);
end;

end.
