unit fRenewOutMed;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fAutoSz, StdCtrls, ComCtrls, ORFn, rOrders, Mask, ORCtrls, ExtCtrls, fBase508Form,
  VA508AccessibilityManager, VA508AccessibilityRouter, rODBase, rODMeds;

type
  TfrmRenewOutMed = class(TfrmBase508Form)
    memOrder: TCaptionMemo;
    pnlButtons: TPanel;
    cmdOK: TButton;
    cmdCancel: TButton;
    pnlMiddle: TPanel;
    cboPickup: TORComboBox;
    lblPickup: TLabel;
    txtRefills: TCaptionEdit;
    lblRefills: TLabel;
    VA508ComponentAccessibility1: TVA508ComponentAccessibility;
    txtSupply: TCaptionEdit;
    lblDays: TLabel;
    lblQuantity: TLabel;
    spnQuantity: TUpDown;
    spnSupply: TUpDown;
    txtQuantity: TCaptionEdit;
    spnRefills: TUpDown;
    procedure FormCreate(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
    procedure VA508ComponentAccessibility1StateQuery(Sender: TObject;
      var Text: string);
    procedure FormShow(Sender: TObject);
    procedure txtSupplyChange(Sender: TObject);
    procedure txtQuantityChange(Sender: TObject);
    procedure txtRefillsChange(Sender: TObject);
    procedure txtSupplyClick(Sender: TObject);
    procedure txtQuantityClick(Sender: TObject);
    procedure txtRefillsClick(Sender: TObject);
  private
    OKPressed: Boolean;
    FChanging: Boolean;
    FResponses: TList;
    FLastUnits, FLastSchedule, FLastDuration, FLastInstruct, FLastDispDrug: string;
    FLastQuantity: Double;
    FLastSupply: Integer;
    FNoZERO: Boolean;
    FUpdated: Boolean;
    FDrugName: string;
    FComplex: boolean;
    FClozapine: boolean;
    FInit: boolean;
    procedure UpdateData;
    procedure UpdateCtrls;
  end;

function ExecuteRenewOutMed(AnOrder: TOrder): Boolean;

implementation

uses uPaPI, uOrders, uCore;

{$R *.DFM}

var
 MaxRefills: Integer;

const
  TX_ERR_REFILL = 'The number of refills must be in the range of 0 through ';
  TC_ERR_REFILL = 'Refills';

function ExecuteRenewOutMed(AnOrder: TOrder): Boolean;
var
  frmRenewOutMed: TfrmRenewOutMed;
  DestList: TList;
  HasObject: Boolean;
  i, doseCount: Integer;
  EDrug, Drug, Days, OrID, Qty, QtyTxt: string;
  RenewFields: TOrderRenewFields;

begin
  RenewFields := TOrderRenewFields(AnOrder.LinkObject);
  Result := False;
  EDrug:= '';
  Drug := '';
  DestList := TList.Create();
  try
    with RenewFields do
    begin
      Days := IntToStr(DaysSupply);
      Qty := IntToStr(Quantity);
      LoadResponses(DestList, 'X' + AnOrder.ID, HasObject, (TitrationMsg <> ''));
      doseCount := 0;

      for I := 0 to DestList.Count - 1 do
      begin
        with TResponse(DestList.Items[i]) do
        begin
          if PromptID = 'DRUG' then
          begin
            Drug := IValue;
            EDrug := EValue;
          end
          else if PromptID = 'ORDERABLE' then OrID := IValue
//            RenewFields.Quantity and DaysSupply will have correct values and
//            will differ from the QTY and SUPPLY Prompts for titration orders
//          else if PromptID = 'SUPPLY' then Days := IValue
//          else if PromptID = 'QTY' then Qty := IValue
          else if PromptID = 'DOSE' then inc(doseCount);
        end;
      end;
      MaxRefills := CalcMaxRefills(Drug, StrToIntDef(Days, 0), StrToIntDef(OrID, 0), AnOrder.EventName = 'D');

      frmRenewOutMed := TfrmRenewOutMed.Create(Application);
      try
        with frmRenewOutMed do
        begin
          FDrugName := EDrug;
          FClozapine := (Pos(EDrug, 'CLOZAPINE') > 0);
          FComplex := (doseCount > 1);
          FResponses := DestList;
          if papiParkingAvailable and papiOrderIsParkable(anOrder.ID) then
            cboPickup.Items.Add('P^Park'); // PaPI.
          ResizeFormToFont(TForm(frmRenewOutMed));
//          memOrder.SetTextBuf(PChar(AnOrder.Text)); // may contain titration msg
          memOrder.SetTextBuf(PChar(NewText));
          spnRefills.Position := Refills;
          if DispUnit = '' then
            QtyTxt := 'Quantity'
          else
          begin
            QtyTxt :='Qty (' + DispUnit + ')';
            if Length(QtyTxt) > 10 then
            begin
              lblQuantity.Hint := QtyTxt;
              QtyTxt := Copy(QtyTxt, 1, 7) + '...';
            end;
          end;
          FChanging := TRUE;
          try
            lblQuantity.Caption := QtyTxt;
        //    txtSupply.Text := Days;
            spnSupply.Position := StrToIntDef(Days, 0);
        //    txtQuantity.Text := Qty;
            spnQuantity.Position := StrToIntDef(Qty, 0);
            cboPickup.SelectByID(Pickup);
          finally
            FChanging := False;
          end;
          ShowModal;
          if OKPressed then
          begin
            Result := True;
            Refills := StrToIntDef(txtRefills.Text, Refills);
            Pickup := cboPickup.ItemID;
            DaysSupply := StrToIntDef(txtSupply.Text, DaysSupply);
            Quantity := StrToIntDef(txtQuantity.Text, Quantity);
            TitrationMsg := '';
          end;
        end;
      finally
        frmRenewOutMed.Release;
      end;
    end;
  finally
    DestList.Free;
  end;
end;

procedure TfrmRenewOutMed.FormCreate(Sender: TObject);
begin
  inherited;
  FInit := True;
  OKPressed := False;
  with cboPickup.Items do
  begin
    Add('W^at Window');
    Add('M^by Mail');
  end;
  FLastUnits := '';
  FLastSchedule := '';
  FLastDuration := '';
  FLastInstruct := '';
  FLastDispDrug := '';
  FLastQuantity := 0;
  FLastSupply := 0;
  FNoZERO := False;
  FUpdated := False;
  FDrugName := '';
  txtRefills.Tag := 0;
  txtSupply.Tag := 0;
  txtQuantity.Tag := 0;
end;

procedure TfrmRenewOutMed.FormShow(Sender: TObject);
begin
  inherited;
  if ScreenReaderSystemActive then
  begin
    memOrder.TabStop := true;
    memOrder.SetFocus;
  end;
  FInit := False;
end;

procedure TfrmRenewOutMed.txtQuantityChange(Sender: TObject);
begin
  inherited;
  if FChanging or FInit then
    Exit;
  FNoZERO := TRUE;
  // if value = 0, change probably caused by the spin button
  if (txtQuantity.Text <> '0') then
  begin
    txtQuantity.Tag := 1;
//    txtSupply.Tag := 0;
  end;
  UpdateCtrls;
end;

procedure TfrmRenewOutMed.txtQuantityClick(Sender: TObject);
begin
  inherited;
  Self.txtQuantity.SelectAll;
end;

procedure TfrmRenewOutMed.txtRefillsChange(Sender: TObject);
begin
  inherited;
  if FChanging or FInit then
    Exit;
  FNoZERO := TRUE;
  // if value = 0, change probably caused by the spin button
  txtRefills.Tag := (txtRefills.Text <> '0').ToInteger;
  UpdateCtrls;
end;

procedure TfrmRenewOutMed.txtRefillsClick(Sender: TObject);
begin
  inherited;
  Self.txtRefills.SelectAll;
end;

procedure TfrmRenewOutMed.txtSupplyChange(Sender: TObject);
begin
  inherited;
  if FChanging or (not Showing) or FInit then
    Exit;
  FNoZERO := TRUE;
  txtSupply.Tag := (txtSupply.Text <> '0').ToInteger;
  UpdateCtrls;
end;

procedure TfrmRenewOutMed.txtSupplyClick(Sender: TObject);
begin
  inherited;
  Self.txtSupply.SelectAll;
end;

procedure TfrmRenewOutMed.UpdateData;

  procedure Update2(APromptID: string; Value: integer);
  var
    x: string;
  begin
    x := IntToStr(Value);
    ResponsesAdapter.Update(APromptID, 1, x, x);
  end;

begin
  if FChanging then exit;
  FUpdated := FALSE;
  ResponsesAdapter.Assign(FResponses);
  Update2('SUPPLY',  spnSupply.Position);
  Update2('QTY',     spnQuantity.Position);
  Update2('REFILLS', spnRefills.Position);
  ResponsesAdapter.Update('PICKUP', 1, cboPickup.ItemID, cboPickup.Text);
end;

procedure TfrmRenewOutMed.UpdateCtrls;
begin
  if FChanging or (not showing) then exit;
  UpdateData;
  FChanging := True;
  try
    CheckChanges(FResponses, False, Patient.Inpatient, FComplex, False, FClozapine,
            #0, FDrugName, False, FNoZERO, FChanging, FUpdated,
            FLastUnits, FLastSchedule, FLastDuration, FLastInstruct, FLastDispDrug,
            FLastQuantity, FLastSupply, txtQuantity, txtSupply, txtRefills,
            spnSupply, spnQuantity, spnRefills, nil, nil);
  finally
    FChanging := False;
  end;
end;

procedure TfrmRenewOutMed.VA508ComponentAccessibility1StateQuery(
  Sender: TObject; var Text: string);
begin
  inherited;
  Text := memOrder.Text;
end;

procedure TfrmRenewOutMed.cmdOKClick(Sender: TObject);
var
  NumRefills: Integer;
begin
  inherited;
  NumRefills := StrToIntDef(txtRefills.Text, -1);
  if (NumRefills < 0) or (NumRefills > MaxRefills) then
  begin
    InfoBox(TX_ERR_REFILL + IntToStr(MaxRefills), TC_ERR_REFILL, MB_OK);
    Exit;
  end;
  OKPressed := True;
  Close;
end;

procedure TfrmRenewOutMed.cmdCancelClick(Sender: TObject);
begin
  inherited;
  Close;
end;

end.
