unit fStandardCodes;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes,
  Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs, fPCEBaseMain, ORCtrls, ORFn,
  VA508AccessibilityManager, Vcl.StdCtrls, Vcl.ExtCtrls, Vcl.ComCtrls, Vcl.Buttons;

type
  TfrmStandardCodes = class(TfrmPCEBaseMain)
    lblMag: TLabel;
    edtMag: TCaptionEdit;
    lblUCUM: TLabel;
    cboUCUM: TORComboBox;
    btnTaxonomy: TButton;
    pnlRight: TPanel;
    lbxCodes: TORListBox;
    lblCodes: TLabel;
    btnAdd: TButton;
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure lstCaptionListChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure cboUCUMNeedData(Sender: TObject; const StartFrom: string;
      Direction, InsertAt: Integer);
    procedure btnOKClick(Sender: TObject); override;
    procedure btnTaxonomyClick(Sender: TObject);
    procedure lbSectionChange(Sender: TObject);
    procedure lbxCodesChange(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure lbxCodesDblClick(Sender: TObject);
    procedure edtMagChange(Sender: TObject);
    procedure cboUCUMChange(Sender: TObject);
    procedure edtMagKeyPress(Sender: TObject; var Key: Char);
  private
    FTaxonomies: boolean;
    { Private declarations }
  public
    { Public declarations }
    procedure UpdateControls; override;
    procedure UpdateNewItemStr(var x: string); override;
  end;

var
  frmStandardCodes: TfrmStandardCodes;

implementation

{$R *.dfm}

uses fEncounterFrame, uPCE, rPCE, rCore;

procedure ListStandardCodes(Dest: TStrings; SectionIndex: Integer);
begin
// N/A
end;

procedure TfrmStandardCodes.btnAddClick(Sender: TObject);
var
  i, j: integer;
  x,code,id,narr,cat: string;
  item,item2: TStandardCode;
  ok: boolean;
begin
  inherited;
  if lbxCodes.ItemIndex < 0 then exit;
  for i := 0 to lbxCodes.Count-1 do
  begin
    if lbxCodes.Selected[i] then
    begin
      x := lbxCodes.Items[i];
      code := piece(x,U,2);
      cat := piece(x,U,1);
      narr := piece(x,U,3);
      id := 'SC';
      ok := true;
      item := TStandardCode.Create;
      try
        item.SetFromString(id+U+code+U+U+narr+U+cat);
        x := item.ItemStr;
        for j := 0 to lstCaptionList.Items.Count-1 do
        begin
          item2 := lstCaptionList.Objects[j] as TStandardCode;
          if x = item2.ItemStr then
          begin
            showmessage('"' + cat + ' ' + code + '  ' + narr + '" has already been added.');
            ok := False;
            break;
          end;
        end;
        if ok then
        begin
          lstCaptionList.Add(item.ItemStr, item);
        end;
      finally
        if not ok then
          item.Free;
      end;
    end;
  end;
end;

procedure TfrmStandardCodes.btnOKClick(Sender: TObject);
begin
  inherited;
//
end;

procedure TfrmStandardCodes.btnTaxonomyClick(Sender: TObject);
begin
  if not FTaxonomies then
  begin
    RemTaxWCodes(lbSection.Items);
    lblSection.Visible := true;
    lblCodes.Visible := true;
    lbSection.Visible := true;
    lbxCodes.Visible := true;
    btnAdd.Visible := true;
    btnAdd.Enabled := false;
    FTaxonomies := True;
  end;
end;

procedure TfrmStandardCodes.cboUCUMChange(Sender: TObject);
var
  item: TStandardCode;
begin
  inherited;
  if GridIndex<0 then exit;
  item := lstCaptionList.Objects[GridIndex] as TStandardCode;
  item.UCUMCode := cboUCUM.ItemIEN.ToString;
end;

procedure TfrmStandardCodes.cboUCUMNeedData(Sender: TObject;
  const StartFrom: string; Direction, InsertAt: Integer);
var
  tmp: TStringList;
begin
  tmp := TStringList.Create;
  try
    ListUCUMCodes(StartFrom, Direction, tmp);
    cboUCUM.ForDataUse(tmp);
  finally
    FreeAndNil(tmp);
  end;
end;

procedure TfrmStandardCodes.edtMagChange(Sender: TObject);
var
 item: TStandardCode;

begin
  inherited;
  if GridIndex<0 then exit;
  item := lstCaptionList.Objects[GridIndex] as TStandardCode;
  item.Magnitude := StrToFloatDef(edtMag.Text,0);
end;

procedure TfrmStandardCodes.edtMagKeyPress(Sender: TObject; var Key: Char);
begin
  inherited;
  if (key <> '.') and (key <> '-') and (key > #31) and ((key < '0') or (key > '9')) then
    key := #0;
end;

procedure TfrmStandardCodes.FormActivate(Sender: TObject);
begin
  inherited;
//
end;

procedure TfrmStandardCodes.FormCreate(Sender: TObject);
begin
  inherited;
  FTabName := CT_STDNm;
  FPCEListCodesProc := ListStandardCodes;
  FPCEItemClass := TStandardCode;
  FPCECode := 'SC';
  cboUCUM.InitLongList('');
  FTaxonomies := False;
end;

procedure TfrmStandardCodes.FormShow(Sender: TObject);
begin
  inherited;
  UpdateControls;
end;

procedure TfrmStandardCodes.lbSectionChange(Sender: TObject);
var
  x: string;
  date: TFMDateTime;
begin
  inherited;
  if FTaxonomies then
  begin
    lbxCodes.Clear;
    btnAdd.Enabled := false;
    if (lbSection.ItemIndex >= 0) then
    begin
      x := lbSection.Items[lbSection.ItemIndex];
      if uEncPCEData.VisitCategory = 'E' then
        date := FMNow
      else
        date := uEncPCEData.VisitDateTime;
      TaxCodes(lbxCodes.Items, StrToIntDef(piece(x,U,1),0), date);
    end;
  end;
end;

procedure TfrmStandardCodes.lbxCodesChange(Sender: TObject);
begin
  inherited;
  btnAdd.Enabled := (lbxCodes.ItemIndex >= 0);
end;

procedure TfrmStandardCodes.lbxCodesDblClick(Sender: TObject);
begin
  inherited;
  btnAddClick(Sender);
end;

procedure TfrmStandardCodes.lstCaptionListChange(Sender: TObject;
  Item: TListItem; Change: TItemChange);
begin
  inherited;
  UpdateControls;
end;

procedure TfrmStandardCodes.UpdateControls;
var
  ok: boolean;
  ucum: string;
  ucumIEN: Int64;

begin
  inherited UpdateControls;
  if NotUpdating then
  begin
    BeginUpdate;
    try
      ok := (lstCaptionList.SelCount = 1);
      lblMag.Enabled := ok;
      lblUCUM.Enabled := ok;
      edtMag.Enabled := ok;
      cboUCUM.Enabled := ok;
      if ok and (GridIndex> -1) then
      begin
        edtMag.Text := FloatToStr(TStandardCode(lstCaptionList.Objects[GridIndex]).Magnitude);
        ucumIEN := StrToInt64Def(TStandardCode(lstCaptionList.Objects[GridIndex]).UCUMCode, 0);
        ucum := ExternalName(ucumIEN, 757.5);
        cboUCUM.InitLongList(ucum);
        cboUCUM.SelectByIEN(ucumIEN);
      end
      else
      begin
        edtMag.Text := '';
        cboUCUM.Text := '';
      end;
      if btnAdd.Visible then
        btnAdd.Enabled := lbxCodes.ItemIndex > 0;
    finally
      EndUpdate;
    end;
  end;
end;

procedure TfrmStandardCodes.UpdateNewItemStr(var x: string);
var
  Tmp, Code, CSShort, CSLong: string;
  i, j, sp: integer;
  k: TCodingSystem;

begin
  inherited;
  Tmp := Piece(x, U, pnumNarrative);
  Code := '';
  CSShort := '';
  CSLong := '';
  j := 0;
  sp := 0;
  i := length(Tmp);
  if Tmp[i]=')' then
    j := i;
  while (i>0) and (Tmp[i]<>'(') do
  begin
    if Tmp[i] = ' ' then
      sp := i + 1;
    dec(i);
  end;
  if (i < j) and (i > 0) and (sp > 0) then
  begin
    Code := copy(Tmp,sp,j-sp);
    CSShort := copy(Tmp, i+1, sp-i-2);
    Tmp := Trim(copy(Tmp,1,i-1));
    for k := low(TCodingSystem) to high(TCodingSystem) do
    begin
      if CSShort = CodingSystemID[k] then
      begin
        CSLong := CodingSystemDesc[k];
        break;
      end;
    end;
    SetPiece(x, U ,pnumCode, Code);
    SetPiece(x, U, pnumCategory, CSLong);
    SetPiece(x, U, pnumNarrative, Tmp);
    SetPiece(x, U, pnumCodingSystem, CSShort);
  end;
end;

end.
