unit fSkinTest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fPCEBase, ORCtrls, StdCtrls, ComCtrls, CheckLst, ExtCtrls, Buttons, uPCE, rPCE, ORFn,
  fPCELex, fPCEOther, rCore, fPCEBaseMain, VA508AccessibilityManager, fVimm, rvimm;

type
  TfrmSkinTests = class(TfrmPCEBaseMain)
    btnSkinEdit: TButton;
    procedure cboSkinResultsChange(Sender: TObject);
//    procedure EdtReadingChange(Sender: TObject);
    procedure edtDtReadChange(Sender: TObject);
    procedure edtDTGivenChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
//    procedure UpDnReadingChanging(Sender: TObject;
//      var AllowChange: Boolean);
    procedure lstCaptionListSelectItem(Sender: TObject; Item: TListItem; Selected: Boolean);
    procedure cboReadingChange(Sender: TObject);
    procedure btnSkinEditClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject); override;
    procedure btnCancelClick(Sender: TObject);

  private
    procedure FormatVimmInputs(Grid: boolean);
    procedure processVimm;
  protected
    procedure UpdateNewItemStr(var x: string); override;
    procedure UpdateControls; override;
  public
  end;

var
  frmSkinTests: TfrmSkinTests;

implementation

{$R *.DFM}

uses
  fEncounterFrame, VA508AccessibilityRouter, uCore;

procedure TfrmSkinTests.btnCancelClick(Sender: TObject);
begin
  inherited;
  clearResults;
  clearInputs;
end;

procedure TfrmSkinTests.btnOKClick(Sender: TObject);
begin
  inherited;
  clearResults;
  clearInputs;
end;

procedure TfrmSkinTests.btnSkinEditClick(Sender: TObject);
var
i: integer;
APCEItem: TPCESkin;
vimmData: TVimmResult;
begin
  inherited;
  FormatVimmInputs(false);
  uvimmInputs.DataList := TStringList.Create;
  try
    for i := 0 to lstCaptionList.Items.Count-1 do
      begin
        APCEItem := TPCESkin(lstCaptionList.Objects[i]);
        if not assigned(APCEItem) then continue;
        vimmData := findVimmResultsByDelimitedStr(APCEItem.delimitedStrTxt, APCEItem.delimitedStr1Txt, '');
//        if vimmData.readByIEN <> '' then vimmData.documType := 'Reading'
//        else if vimmData.documType = '' then vimmData.documType := 'Administered';
        if uVimmInputs.isHistorical then vimmData.documType := 'Historical';

        uVimmInputs.DataList.AddObject('DATA' + U + vimmData.id, vimmData);
      end;
    processVimm;
  finally
     clearResults;
     clearInputs;
  end;
end;

procedure TfrmSkinTests.cboReadingChange(Sender: TObject);
var
i: integer;
begin
  inherited;
begin
  if(NotUpdating) then
  begin
//    read := cboReading.Text;
    for i := 0 to lstCaptionList.Items.Count-1 do
      if(lstCaptionList.Items[i].Selected) then
//        TPCESkin(lstCaptionList.Objects[i]).Reading := read;
    GridChanged;
  end;
end;
end;

procedure TfrmSkinTests.cboSkinResultsChange(Sender: TObject);
//var
//  i: integer;

begin
//  if(NotUpdating) and (cboSkinResults.Text <> '') then
//  begin
//    for i := 0 to lstCaptionList.Items.Count-1 do
//      if(lstCaptionList.Items[i].Selected) then begin
//        TPCESkin(lstCaptionList.Objects[i]).Results := cboSkinResults.ItemID;
//        If UpperCase(cboSkinResults.Text) = 'NO TAKE' then begin
//          cboReading.Visible := false;
////          EdtReading.Visible := False;
////          UpDnReading.Visible := False;
////          lblReading.Visible := False;
//        end else begin
//          cboReading.Visible := true;
////          EdtReading.Visible := True;
////          UpDnReading.Visible := True;
////          lblReading.Visible := True;
//        end;
//      end;
//
//    GridChanged;
//  end;
end;

{///////////////////////////////////////////////////////////////////////////////
//Name:procedure TfrmSkinTests.EdtReadingChange(Sender: TObject);
//Created: Jan 1999
//By: Robert Bott
//Location: ISL
//Description:Change the reading assigned to the skin test.
///////////////////////////////////////////////////////////////////////////////}
//procedure TfrmSkinTests.EdtReadingChange(Sender: TObject);
//var
//  x, i: integer;
//
//begin
//  if(NotUpdating) then
//  begin
//    x := StrToIntDef(EdtReading.Text, 0);
//    for i := 0 to lstCaptionList.Items.Count-1 do
//      if(lstCaptionList.Items[i].Selected) then
//        TPCESkin(lstCaptionList.Objects[i]).Reading := x;
//
//    GridChanged;
//  end;
//end;

procedure TfrmSkinTests.edtDtReadChange(Sender: TObject);
begin
end;
(*
var
  DtRead: TFMDateTime;
  ASkinTest: TPCESkin;
begin
  inherited;
  if lstSkinSelect.ItemIndex < 0 then Exit;

  with lstSkinSelect do ASkinTest := TPCESkin(Items.Objects[ItemIndex]);
  DtRead := StrToFMDateTime(edtReading.text);
  with lstSkinSelect do if (ItemIndex > -1) then
  begin
    ASkinTest.DTRead := DTRead;
    Items[ItemIndex] := ASkinTest.ItemStr;
  end;
end;
*)

procedure TfrmSkinTests.edtDTGivenChange(Sender: TObject);
begin
end;
(*
var
  DtGiven: TFMDateTime;
  ASkinTest: TPCESkin;
begin
  inherited;
  if lstSkinSelect.ItemIndex < 0 then Exit;

  with lstSkinSelect do ASkinTest := TPCESkin(Items.Objects[ItemIndex]);
  DtGiven := StrToFMDateTime(edtDTGiven.text);
  with lstSkinSelect do if (ItemIndex > -1) then
  begin
    ASkinTest.DTGiven := DTGIven;
    Items[ItemIndex] := ASkinTest.ItemStr;
  end;
end;
*)
(*
procedure TfrmSkinTests.CheckSkinRules;
begin
  //Results must be between 0 and 40
  if StrToInt(EdtReading.Text) < 0 then EdtReading.text := '0';
  if StrToInt(EdtReading.Text) > 40 then EdtReading.text := '40';

(*  //if reading >10, result must be "positive"
  if (StrToInt(EdtReading.Text) > 9) and
    (CompareText(Piece(cboSkinResults.items[cboSkinResults.itemindex],U,1),'P') <> 0) then
    begin
      if (Piece(cboSkinResults.items[cboSkinResults.itemindex],U,1) = '@') then    // not selected
      begin
        cboSkinResults.SelectById('P');
      end
      else
      begin
        Show508Message('If the reading is over 9, the results are required to be positive.');
        cboSkinResults.SelectById('P');
       end;
    end;
end;
*)

procedure TfrmSkinTests.FormatVimmInputs(Grid: boolean);
begin
    uvimmInputs.noGrid := grid;
    uvimmInputs.makeNote := false;
    uvimmInputs.isSkinTest := true;
    uvimmInputs.collapseICE := true;
    uvimmInputs.canSaveData := false;
    uvimmInputs.patientName := patient.Name;
    uvimmInputs.patientIEN := patient.DFN;
    uvimmInputs.userName := user.Name;
    uvimmInputs.userIEN := user.DUZ;
    uVimmInputs.startInEditMode := false;
    uvimmInputs.encounterProviderName := encounter.ProviderName;
    uvimmInputs.encounterProviderIEN := encounter.Provider;
    uvimmInputs.encounterLocation := uEncPCEData.Location;
    uvimmInputs.encounterCategory := uEncPCEData.VisitCategory;
    uvimmInputs.dateEncounterDateTime := uEncPCEData.VisitDateTime;
    uvimmInputs.visitString := uEncPCEData.VisitString;
    uVimmInputs.isFromEncounter := true;
    uVimmInputs.isHistorical := uEncPCEData.VisitCategory = 'E';
    uVimmInputs.immunizationReading := false;
end;

procedure TfrmSkinTests.FormCreate(Sender: TObject);
begin
  inherited;
  FTabName := CT_SkinNm;
  FPCEListCodesProc := ListSkinCodes;
  FPCEItemClass := TPCESkin;
  FPCECode := 'SK';
  self.btnRemove.Visible := false;
  self.btnSelectAll.Visible := false;
  self.edtComment.Visible := false;
  pnlMain.Visible := false;
  self.lblSection.Visible := false;
  self.lblList.Visible := false;
//  PCELoadORCombo(cboSkinResults);
end;

procedure TfrmSkinTests.lstCaptionListSelectItem(Sender: TObject; Item: TListItem; Selected: Boolean);
begin
  inherited;
//  If UpperCase(cboSkinResults.Text) = 'NO TAKE' then begin
//    cboReading.Visible := false;
////   EdtReading.Visible := False;
////   UpDnReading.Visible := False;
////   lblReading.Visible := False;
//  end else begin
//    cboReading.Visible := true;
////   EdtReading.Visible := True;
////   UpDnReading.Visible := True;
////   lblReading.Visible := True;
//  end;

end;

procedure TfrmSkinTests.processVimm;
var
  resultList: TStringList;
  i, idx: Integer;
  str: String;
  data: TVimmResult;
  skin: TPCESkin;
  notFound: boolean;
  pceProc: TPCEProc;
  pceDiag: TPCEDiag;
  povList, cptList: TStringList;

  function finditem(data: TVimmResult): Integer;
  var
  i: integer;
  APCEItem: TPCESkin;
  begin
    result := -1;
    for i := 0 to lstCaptionList.Items.count -1 do
      begin
        APCEItem := TPCESkin(lstCaptionList.Objects[i]);
        if APCEItem.Narrative <> data.name then continue;
        if Piece(ApceItem.delimitedStrTxt, U, 2) = Piece(data.DelimitedStr, u, 2) then
          begin
            result := i;
            break;
          end;
      end;

  end;

  procedure removeOld(resultList: TStringList);
  var
  c, r: integer;
  APCEItem: TPCEImm;
  tempList: TStrings;
  found: boolean;
  data: TVimmResult;
  begin
    tempList := TStringList.Create;
    try
      for c := 0 to lstCaptionList.Items.Count-1 do
        begin
          APCEItem := TPCEImm(lstCaptionList.Objects[c]);
          found := false;
          for r := 0 to resultList.Count - 1 do
            begin
              data := TVimmResult(resultList.Objects[r]);
              if Pieces(ApceItem.delimitedStrTxt, U, 1, 2) = Pieces(data.DelimitedStr, u, 1, 2) then
                begin
                  found := true;
                  break;
                end;
            end;
          if not found then tempList.Add(IntToStr(c));
        end;
      for r := 0 to tempList.Count - 1 do
        begin
          c := StrToInt(tempList.Strings[r]);
          lstCaptionList.Items[c].Selected  := true;
          btnRemoveClick(lstCaptionList);
        end;
    finally
      FreeAndNil(tempList);
    end;

  end;


begin
  resultList := TStringList.Create;
  povList := TStringList.Create;
  cptList := TStringList.Create;
  str := '';
  try
    if performVimm(resultList, false) = false then
      Exit;
    notFound := false;
    if resultList.Count > 0 then
    begin
      for i := 0 to resultList.Count - 1 do
      begin
        data := TVimmResult(resultList.Objects[i]);
        idx := finditem(data);
        if idx > -1 then
          begin
            TPCESkin(lstCaptionList.Objects[idx]).delimitedStrTxt := data.DelimitedStr;
            TPCESkin(lstCaptionList.Objects[idx]).delimitedStr1Txt := data.DelimitedStr2;
          end
        else
          begin
            notFound := true;
            skin := TPCESkin.Create(data);
            lstCaptionList.AddObject(skin.Narrative, skin);
            if data.diagnosisDelimitedStr <> '' then
              begin
                pceDiag := TPCEDiag.Create;
                pceDiag.SetFromString(data.diagnosisDelimitedStr);
                povList.AddObject(data.diagnosisDelimitedStr, pceDiag);
              end;
            if data.procedureDelimitedStr <> '' then
              begin
                pceProc := TPCEProc.Create;
                pceProc.SetFromString(data.procedureDelimitedStr);
                cptList.AddObject(data.procedureDelimitedStr, pceProc);
              end;
          end;
      end;
    if (resultList.Count < lstCaptionList.Items.Count) or (notFound and (resultList.count > 1)) then
      begin
        removeOld(resultList);
        ShowMessage('Please review the diagnosis and procedure tabs for accuracy');
      end;
    lstCaptionList.Update;
    for i := 0 to lstCaptionList.Items.Count-1 do
      begin
        lstCaptionList.Items[i].Selected  := true;
        GridChanged;
      end;
    uEncPCEData.SetProcedures(cptList, false);
    uEncPCEData.SetDiagnoses(povList, false);
    frmEncounterFrame.SynchPCEVimmSubData;
    end;
  finally
    FreeAndNil(resultList);
    FreeAndNil(povList);
    FreeAndNil(cptList);
  end;
end;


procedure TfrmSkinTests.UpdateNewItemStr(var x: string);
begin
  SetPiece(x, U, pnumSkinResults, NoPCEValue);
  SetPiece(x, U, pnumSkinReading, '');
//  SetPiece(x, U, pnumSkinDTRead);
//  SetPiece(x, U, pnumSkinDTGiven);
end;

procedure TfrmSkinTests.UpdateControls;
var
  ok, First: boolean;
  SameRes, SameRead: boolean;
//  objRead
  i: integer;
  Res: string;
//  Read: integer;
  Read: string;
  Obj: TPCESkin;

begin
  inherited;
  if(NotUpdating) then
  begin
    BeginUpdate;
    try
      ok := (lstCaptionList.SelCount > 0);
//      lblSkinResults.Enabled := ok;
//      lblReading.Enabled := ok;
//      cboSkinResults.Enabled := ok;
//      cboReading.Enabled := ok;
//      EdtReading.Enabled := ok;
//      UpDnReading.Enabled := ok;
      if(ok) then
      begin
        First := TRUE;
        SameRes := TRUE;
        SameRead := TRUE;
        Res := NoPCEValue;
//        objRead := false;
        Read := '0';
       for i := 0 to lstCaptionList.Items.Count-1 do
        begin
          if lstCaptionList.Items[i].Selected then
          begin
            Obj := TPCESkin(lstCaptionList.Objects[i]);
            if(First) then
            begin
              First := FALSE;
              Res := Obj.Results;
              Read := Obj.Reading;
//              objRead := true;
            end
            else
            begin
              if(SameRes) then
                SameRes := (Res = Obj.Results);
              if(SameRead) then
                begin
                  SameRead := (Read = Obj.Reading);
                end;
            end;
          end;
        end;
     
//        if(SameRes) then
//          cboSkinResults.SelectByID(Res)
//        else
//          cboSkinResults.Text := '';
        if(SameRead) then
        begin
//          if not objRead then cboReading.ItemIndex := 0
//          else
//            begin
//              idx := cboReading.Items.IndexOf(Read);
//              cboReading.ItemIndex := idx;
//            end;
//          UpDnReading.Position := Read;
//          EdtReading.Text := IntToStr(Read);
//          EdtReading.SelStart := length(EdtReading.Text);
        end
        else
        begin
//          cboReading.ItemIndex := -1;
//          UpDnReading.Position := 0;
//          EdtReading.Text := '';
        end;
      end
      else
      begin
//        cboSkinResults.Text := '';
////        EdtReading.Text := '';
//        cboReading.ItemIndex := -1;
//        cboReading.Text := '';
      end;
    finally
      EndUpdate;
    end;
  end;
end;

//procedure TfrmSkinTests.UpDnReadingChanging(Sender: TObject;
//  var AllowChange: Boolean);
//begin
//  inherited;
//  if(UpDnReading.Position = 0) then
//    EdtReadingChange(Sender);
//end;

initialization
  SpecifyFormIsNotADialog(TfrmSkinTests);

end.
  