unit fImmunization;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fPCEBase, StdCtrls, ORCtrls, CheckLst, ExtCtrls, Buttons, uPCE, rPCE, ORFn,
  fPCELex, fPCEOther, ComCtrls, fPCEBaseMain, VA508AccessibilityManager, fVimm, rvimm;

type
  TfrmImmunizations = class(TfrmPCEBaseMain)
    btnAdd: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure btnOtherClick(Sender: TObject);
    procedure btnOtherExit(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject); override;
    procedure btnCancelClick(Sender: TObject);
  private
  protected
    procedure UpdateNewItemStr(var x: string); override;
    procedure UpdateControls; override;
  public
    procedure FormatVimmInputs(Grid: boolean);
    procedure processVimm;
//    procedure ChangeProvider;
  end;

var
  frmImmunizations: TfrmImmunizations;

implementation

{$R *.DFM}

uses
  fEncounterFrame, VA508AccessibilityRouter, uCore;


procedure TfrmImmunizations.btnAddClick(Sender: TObject);
var
i: integer;
APCEItem: TPCEImm;
vimmData: TVimmResult;
begin
  inherited;
  FormatVimmInputs(false);
  uvimmInputs.DataList := TStringList.Create;
  try
    for i := 0 to lstCaptionList.Items.Count-1 do
      begin
        APCEItem := TPCEImm(lstCaptionList.Objects[i]);
        if not assigned(APCEItem) then continue;
        vimmData := findVimmResultsByDelimitedStr(APCEItem.delimitedStrTxt, APCEItem.delimitedStr1Txt,
                    APCEItem.delimitedStr2Txt);
        if vimmData.documType = '' then
          begin
            if uEncPCEData.VisitCategory = 'E' then vimmData.documType := 'Historical'
            else vimmData.documType := 'Administered';
          end;
        uVimmInputs.DataList.AddObject('DATA' + U + vimmData.id, vimmData);
      end;
    processVimm;
  finally
     clearResults;
     clearInputs;
  end;


end;

procedure TfrmImmunizations.FormatVimmInputs(Grid: boolean);
begin
    uvimmInputs.noGrid := grid;
    uvimmInputs.makeNote := false;
    uvimmInputs.collapseICE := true;
    uvimmInputs.canSaveData := false;
    uvimmInputs.patientName := patient.Name;
    uvimmInputs.patientIEN := patient.DFN;
    uvimmInputs.userName := user.Name;
    uvimmInputs.userIEN := user.DUZ;
    uvimmInputs.isSkinTest := false;
    uVimmInputs.startInEditMode := false;
    uvimmInputs.encounterProviderName := encounter.ProviderName;
    uvimmInputs.encounterProviderIEN := encounter.Provider;
    uvimmInputs.encounterLocation := uEncPCEData.Location;
    uvimmInputs.encounterCategory := uEncPCEData.VisitCategory;
    uvimmInputs.dateEncounterDateTime := uEncPCEData.VisitDateTime;
    uvimmInputs.visitString := uEncPCEData.VisitString;
    uVimmInputs.isFromEncounter := true;
    uVimmInputs.isHistorical := uEncPCEData.VisitCategory = 'E';
    uVimmInputs.immunizationReading := false;
end;

procedure TfrmImmunizations.btnCancelClick(Sender: TObject);
begin
  inherited;
  clearResults;
  clearInputs;
end;

procedure TfrmImmunizations.btnOKClick(Sender: TObject);
begin
  inherited;
  clearResults;
  clearInputs;
end;

procedure TfrmImmunizations.btnOtherClick(Sender: TObject);
begin
//  inherited;
end;

procedure TfrmImmunizations.btnOtherExit(Sender: TObject);
begin
////  inherited;
end;

procedure TfrmImmunizations.FormCreate(Sender: TObject);
begin
  inherited;
  FTabName := CT_ImmNm;
  FPCEListCodesProc := ListImmunizCodes;
  FPCEItemClass := TPCEImm;
  FPCECode := 'IMM';
  self.btnRemove.Visible := false;
  self.btnSelectAll.Visible := false;
end;

procedure TfrmImmunizations.FormPaint(Sender: TObject);
begin
inherited;
//  if ckbContra.Focused = True then
//  begin
//    frmImmunizations.Canvas.Pen.Width := 1;
//    frmImmunizations.Canvas.Pen.Style := psDot;
//    frmImmunizations.Canvas.MoveTo(lblContra.Left - 2,lblContra.Top - 1);
//    frmImmunizations.Canvas.LineTo(lblContra.Left + lblContra.Width + 2,lblContra.Top - 1);
//    frmImmunizations.Canvas.LineTo(lblContra.Left + lblContra.Width + 2,lblContra.Top + lblContra.Height);
//    frmImmunizations.Canvas.LineTo(lblContra.Left - 2,lblContra.Top + lblContra.Height);
//    frmImmunizations.Canvas.LineTo(lblContra.Left - 2,lblContra.Top - 1);
//  end;
end;

procedure TfrmImmunizations.processVimm;
var
  resultList: TStringList;
  i, idx, immCnt: Integer;
  str, immFirst, immSecond: String;
  data: TVimmResult;
  imm: TPCEImm;
  pceProc: TPCEProc;
  pceDiag: TPCEDiag;
  povList, cptList: TStringList;
  notFound: boolean;

  procedure removeAll;
  var
  c: integer;
  begin
    for c := 0 to lstCaptionList.Items.Count-1 do
      lstCaptionList.Items[c].Selected  := true;
    btnRemoveClick(lstCaptionList);
  end;

  function finditem(data: TVimmResult): Integer;
  var
  i: integer;
  APCEItem: TPCEImm;
  begin
    result := -1;
    for i := 0 to lstCaptionList.Items.count -1 do
      begin
        APCEItem := TPCEImm(lstCaptionList.Objects[i]);
        if APCEItem.Narrative <> data.name then continue;
        if Pieces(ApceItem.delimitedStrTxt, U, 1, 2) = Pieces(data.DelimitedStr, u, 1, 2) then
          begin
            result := i;
            break;
          end;
      end;

  end;

  procedure removeOld(resultList: TStringList);
  var
  c, r: integer;
  APCEItem//, PCEObject
  : TPCEImm;
  tempList: TStrings;
  found: boolean;
  data: TVimmResult;
  begin
    tempList := TStringList.Create;
    try
      for c := 0 to lstCaptionList.Items.Count-1 do
        begin
          APCEItem := TPCEImm(lstCaptionList.Objects[c]);
          found := false;
          for r := 0 to resultList.Count - 1 do
            begin
              data := TVimmResult(resultList.Objects[r]);
//              PCEObject := TPCEImm.Create(data);
              if Pieces(ApceItem.delimitedStrTxt, U, 1, 2) = Pieces(data.DelimitedStr, u, 1, 2) then
                begin
                  found := true;
                  break;
                end;
            end;
          if not found then tempList.Add(IntToStr(c));
        end;
      for r := 0 to tempList.Count - 1 do
        begin
          c := StrToInt(tempList.Strings[r]);
          lstCaptionList.Items[c].Selected  := true;
          btnRemoveClick(lstCaptionList);
        end;
    finally
      FreeAndNil(tempList);
    end;

  end;


begin
  resultList := TStringList.Create;
  str := '';
  povList := TStringList.Create;
  cptList := TStringList.Create;
  try
    if performVimm(resultList, false) = false then
      Exit;
//    removeAll;
    notFound := false;
    if resultList.Count > 0 then
    begin
      for i := 0 to resultList.Count - 1 do
      begin
        data := TVimmResult(resultList.Objects[i]);
        idx := finditem(data);
        if idx > -1 then
          begin
            TPCEImm(lstCaptionList.Objects[idx]).delimitedStrTxt := data.DelimitedStr;
            TPCEImm(lstCaptionList.Objects[idx]).delimitedStr1Txt := data.DelimitedStr2;
            TPCEImm(lstCaptionList.Objects[idx]).delimitedStr2Txt := data.DelimitedStr3;
//            assign(TPCEImm(lstCaptionList.Objects[i]));
          end
        else
          begin
            notFound := true;
            imm := TPCEImm.Create(data);
            lstCaptionList.AddObject(imm.Narrative, imm);
            if data.diagnosisDelimitedStr <> '' then
              begin
                pceDiag := TPCEDiag.Create;
                pceDiag.SetFromString(data.diagnosisDelimitedStr);
                povList.AddObject(data.diagnosisDelimitedStr, pceDiag);
              end;
            if data.procedureDelimitedStr <> '' then
              begin
                pceProc := TPCEProc.Create;
                pceProc.SetFromString(data.procedureDelimitedStr);
                cptList.AddObject(data.procedureDelimitedStr, pceProc);
              end;
          end;
      end;
    if (resultList.Count < lstCaptionList.Items.Count) or (notFound and (resultList.count > 1)) then
      begin
        removeOld(resultList);
        ShowMessage('Please review the diagnosis and procedure tabs for accuracy');
      end;
    lstCaptionList.Update;
    getBillingCodes(uEncPCEData.VisitDateTime);
    getCPTBillingCodes(immFirst, immSecond);
    PCEProc := TPCEProc.create;
    pceProc.SetFromString(immFirst);
    cptList.AddObject(immFirst, pceProc);
    immCnt := resultList.Count;
    if immCNT > 1 then
      begin
        pceProc := TPCEProc.Create;
        SetPiece(immSecond, U, 5, IntToStr(immCNT - 1));
        pceProc.SetFromString(immSecond);
        cptList.AddObject(immSecond, pceProc);
      end;
    for i := 0 to lstCaptionList.Items.Count-1 do
      begin
        lstCaptionList.Items[i].Selected  := true;
        GridChanged;
      end;
    end;
    uEncPCEData.SetProcedures(cptList, false);
    uEncPCEData.SetDiagnoses(povList, false);
    frmEncounterFrame.SynchPCEVimmSubData;
  finally
    FreeAndNil(resultList);
    FreeAndNil(povList);
    FreeAndNil(cptList);
  end;
end;

procedure TfrmImmunizations.UpdateNewItemStr(var x: string);
begin
  inherited;
  SetPiece(x, U, pnumImmSeries, NoPCEValue);
  SetPiece(x, U, pnumImmReaction, NoPCEValue);
  SetPiece(x, U, pnumImmRefused, '0');
  SetPiece(x, U, pnumImmContra, '0');
end;

procedure TfrmImmunizations.UpdateControls;
var
  ok, Contra, First: boolean;
  SameS, SameR, SameC: boolean;
  i: integer;
  Ser, React: string;
  Obj: TPCEImm;

begin
  inherited;
  if(NotUpdating) then
  begin
    BeginUpdate;
    try
      ok := (lstCaptionList.SelCount > 0);
      if(ok) then
      begin
        First := TRUE;
        SameS := TRUE;
        SameR := TRUE;
        SameC := TRUE;
        Contra := FALSE;
        Ser := NoPCEValue;
        React := NoPCEValue;
        for i := 0 to lstCaptionList.Items.Count-1 do
        begin
          if lstCaptionList.Items[i].Selected then
          begin
            Obj := TPCEImm(lstCaptionList.Objects[i]);
            if(First) then
            begin
              First := FALSE;
              Contra := Obj.Contraindicated;
              Ser := Obj.Series;
              React := Obj.Reaction;
            end
            else
            begin
              if(SameS) then
                SameS := (Ser = Obj.Series);
              if(SameR) then
                SameR := (React = Obj.Reaction);
              if(SameC) then
                SameC := (Contra = Obj.Contraindicated);
            end;
          end;
        end;
      end;
    finally
      EndUpdate;
    end;
  end;
end;

initialization
  SpecifyFormIsNotADialog(TfrmImmunizations);

end.
