unit fNewAllergyCheck;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,

System.Classes, Vcl.Graphics, fAutoSz,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, ORCtrls, Vcl.StdCtrls, Vcl.ExtCtrls,
  VA508AccessibilityManager, Vcl.Buttons;

type
  TfrmNewAllergyCheck = class(TfrmAutoSz)
    Label1: TLabel;
    Label2: TLabel;
    ActiveOrders: TLabel;
    SelRecip: TORListBox;
    Label4: TLabel;
    OptRecip: TORComboBox;
    Recipients: TORListBox;
    SendAlertBtn: TSpeedButton;
    AddBtn: TSpeedButton;
    RemoveBtn: TSpeedButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SendAlertBtnClick(Sender: TObject);
    procedure OptRecipNeedData(Sender: TObject;
      const StartFrom: string; Direction, InsertAt: Integer);
    procedure OptRecipKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure AddBtnClick(Sender: TObject);
    procedure RemoveBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure setByOrder(anOrder,aNewAllergy:String; Cleanup:Boolean = true);
  end;
var
  frmNewAllergyCheck: TfrmNewAllergyCheck;

implementation

{$R *.dfm}

uses {fAllgyAR,} ORNet, uCore, rCore, ORfn;

var
  OrderNo:string;
  MatchingProviders: TStringList;
  ReturnedRecipients: TStringList;

procedure TfrmNewAllergyCheck.FormActivate(Sender: TObject);
begin
  OptRecip.SetFocus;
end;

procedure TfrmNewAllergyCheck.FormClose(Sender: TObject;
var Action: TCloseAction);
begin
  frmNewAllergyCheck := nil;
  Action := caFree;
end;

procedure TfrmNewAllergyCheck.setByOrder(anOrder,aNewAllergy:String; Cleanup:Boolean = true);
var
  i:integer;
begin
  if Cleanup then
    Recipients.Items.Clear;

  ReturnedRecipients := TStringList.Create;
  try
    tCallv(ReturnedRecipients,'ORWU NEWPERS',['',1]);
    for i := 0 to ReturnedRecipients.Count - 1 do
      OptRecip.Items.Add(ReturnedRecipients[i]);

    MatchingProviders := TStringList.Create;
    Label2.Caption := ' The following ACTIVE Order contains ' + aNewAllergy;
    ActiveOrders.Caption := Piece(anOrder,'^',3) + ' (Order# ' + Piece(anOrder,'^',1) + ')';

    OrderNo := Piece(anOrder,'^',1);
    i := Pos(';', OrderNo);
    if i > 0 then
      OrderNo := Copy(anOrder,1,i - 1);

    tCallv(MatchingProviders,'ORWDAL32 GETPROV',[OrderNo]);
    for i := 0 to MatchingProviders.Count - 1 do
      Recipients.Items.Add(MatchingProviders[i]);
  finally
    ReturnedRecipients.Free;
  end;
end;

procedure TfrmNewAllergyCheck.SendAlertBtnClick(Sender: TObject);
var i:integer;
begin
  for i := 0 to SelRecip.Count - 1 do
    MatchingProviders.Add(SelRecip.items[i]);
  try
    sCallv('ORWDAL32 SENDALRT',[OrderNo, MatchingProviders]);
  finally
    MatchingProviders.Free;
  end;
  Close;
end;

procedure TfrmNewAllergyCheck.OptRecipKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  if Key = VK_Return then
  begin
    AddBtn.Click;
    OptRecip.Text := '';
    OptRecip.SetFocus;
  end;
end;

procedure TfrmNewAllergyCheck.OptRecipNeedData(Sender: TObject;
  const StartFrom: string; Direction, InsertAt: Integer);
var i:integer;
begin
  if Direction <> 1 then Exit;
  ReturnedRecipients := TStringList.Create;
  try
    tCallv(ReturnedRecipients,'ORWU NEWPERS',[Piece(OptRecip.Items[InsertAt-1],'^',2), '1']);
    for i := 0 to ReturnedRecipients.Count - 1 do
      OptRecip.Items.Add(ReturnedRecipients[i]);
  finally
    ReturnedRecipients.Free;
  end;
end;

procedure TfrmNewAllergyCheck.AddBtnClick(Sender: TObject);
begin
  if OptRecip.itemindex <> -1 then
  begin
    SelRecip.Items.Add(OptRecip.items[OptRecip.itemindex]);
    OptRecip.Text := '';
  end;
end;

procedure TfrmNewAllergyCheck.RemoveBtnClick(Sender: TObject);
begin
  if SelRecip.itemindex <> -1 then
  begin
    if SelRecip.itemindex <> -1 then
      SelRecip.items.Delete(SelRecip.itemindex);
  end;
end;


end.



