unit fOCAccept;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  fAutoSz,
  StdCtrls,
  ComCtrls,
  ORFn,
  ExtCtrls,
  VA508AccessibilityManager,
  rOrders,
  fOCMonograph;

type
  TfrmOCAccept = class(TfrmAutoSz)
    memChecks: TRichEdit;
    pnlBottom: TPanel;
    cmdAccept: TButton;
    cmdCancel: TButton;
    Button1: TButton;
    AllergyAssessmentBtn: TButton;
    procedure Button1Click(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure AllergyAssessmentBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    procedure WndProc(var Msg: TMessage); override; // Used to fire URL's in TRichEdit
  end;

function AcceptOrderWithChecks(OCList: TStringList): Boolean;

implementation

{$R *.DFM}


uses
  RichEdit,
  ORNet,
  uCore, uConst,
  fAllgyAR,
  ShellAPI;

function AcceptOrderWithChecks(OCList: TStringList): Boolean;
var
  i, j: Integer;
  frmOCAccept: TfrmOCAccept;
  substring: String;
  remOC: TStringList;
  mask: NativeInt; // Fixing Defect 352249
begin
  remOC := TStringList.Create;
  Result := True;
  if OCList.Count > 0 then
    begin
      frmOCAccept := TfrmOCAccept.Create(Application);
      try
        ResizeFormToFont(TForm(frmOCAccept));
      // *** The following 3 lines of code are for future use when an // NJC(NSR 20070920) 08/15
      // *** authorization parameter is implemented for Allergy access// NJC(NSR 20070920) 08/15
      //  if sCallV('ORQQAE USER',[user.DUZ]) <> '1' then             // NJC(NSR 20070920) 08/15
      //    frmOCAccept.AllergyAssessmentBtn.Visible  := false        // NJC(NSR 20070920) 08/15
      //  else                                                        // NJC(NSR 20070920) 08/15
      if sCallV('ORQQAL LIST', [Patient.DFN]) = '^No Allergy Assessment' then   //NJC 09/15
          frmOCAccept.AllergyAssessmentBtn.Visible  := true           // NJC(NSR 20070920) 08/15
        else                                                          // NJC(NSR 20070920) 08/15
          frmOCAccept.AllergyAssessmentBtn.Visible  := false;         // NJC(NSR 20070920) 08/15
//        NoAllergyAssessment := true         //NJC 09/15
//      else                                  //NJC 09/15
//        NoAllergyAssessment := false;       //NJC 09/15
//        if NoAllergyAssessment then                                   // NJC(NSR 20070920) 08/15
//          frmOCAccept.AllergyAssessmentBtn.Visible  := true           // NJC(NSR 20070920) 08/15
//        else                                                          // NJC(NSR 20070920) 08/15
//          frmOCAccept.AllergyAssessmentBtn.Visible  := false;         // NJC(NSR 20070920) 08/15

        // Begin URL Detection setup for TRichEdit
        mask := SendMessage(frmOCAccept.memChecks.Handle, EM_GETEVENTMASK, 0, 0);
        SendMessage(frmOCAccept.memChecks.Handle, EM_SETEVENTMASK, 0, mask or ENM_LINK);
        SendMessage(frmOCAccept.memChecks.Handle, EM_AUTOURLDETECT, Integer(True), 0);
        // End URL Detection setup for TRichEdit

        frmOCAccept.Button1.Enabled := false;
        if IsMonograph then
          frmOCAccept.Button1.Enabled := True;

        for i := 0 to OCList.Count - 1 do
          begin
            substring := Copy(Piece(OCList[i], U, 4), 0, 2);
            if substring = '||' then
              begin
                substring := Copy(Piece(OCList[i], U, 4), 3, Length(Piece(OCList[i], U, 4)));
                GetXtraTxt(remOC, Piece(substring, '&', 1), Piece(substring, '&', 2));
                frmOCAccept.memChecks.Lines.Add('(' + inttostr(i + 1) + ' of ' + inttostr(OCList.Count) + ')  ' + Piece(substring, '&', 2));
                for j := 0 to remOC.Count - 1 do
                  frmOCAccept.memChecks.Lines.Add('      ' + remOC[j]);
                // frmOCAccept.memChecks.Lines.Add('           ');
              end
            else
              begin
                frmOCAccept.memChecks.Lines.Add('(' + inttostr(i + 1) + ' of ' + inttostr(OCList.Count) + ')  ' + Piece(OCList[i], U, 4));
              end;

            frmOCAccept.memChecks.Lines.Add('');
          end;
        frmOCAccept.memChecks.SelStart := 0;
        frmOCAccept.memChecks.SelLength := 0;
        Result := frmOCAccept.ShowModal = mrYes;
      finally
        frmOCAccept.Release;
        remOC.Destroy;
      end;
    end;
end;

procedure TfrmOCAccept.AllergyAssessmentBtnClick(Sender: TObject);
begin
  EnterEditAllergy(0, True, False);
end;

procedure TfrmOCAccept.Button1Click(Sender: TObject);
var
  monoList: TStringList;
begin
  inherited;
  monoList := TStringList.Create;
  GetMonographList(monoList);
  ShowMonographs(monoList);
  monoList.Free;
end;

procedure TfrmOCAccept.cmdCancelClick(Sender: TObject);
begin
  inherited;
  DeleteMonograph;
end;

procedure TfrmOCAccept.FormResize(Sender: TObject);
begin
  inherited;
  memChecks.Refresh;
end;

procedure TfrmOCAccept.WndProc(var Msg: TMessage);
var
  p: TENLink;
  sURL: string;
begin
  if (Msg.Msg = WM_NOTIFY) then
    begin
      if (PNMHDR(Msg.lParam).code = EN_LINK) then
        begin
          p := TENLink(Pointer(TWMNotify(Msg).NMHdr)^);
          if (p.Msg = WM_LBUTTONDOWN) then
            begin
              try
                SendMessage(memChecks.Handle, EM_EXSETSEL, 0, Longint(@(p.chrg)));
                sURL := memChecks.SelText;
                ShellExecute(Handle, 'open', PChar(sURL), NIL, NIL, SW_SHOWNORMAL);
              except
                ShowMessage('Error opening HyperLink');
              end;
            end;
        end;
    end;

  inherited;
end;

end.


