unit fOrdersUnPII ;
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fAutoSz, StdCtrls, ORFn, ORCtrls, VA508AccessibilityManager;

type
  TfrmUnPII Orders = class(TfrmAutoSz)
    lstOrders: TCaptionListBox;
    Label1: TLabel;
    cmdOK: TButton;
    cmdCancel: TButton;
    procedure FormCreate(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
    procedure lstOrdersMeasureItem(Control: TWinControl; Index: Integer;
      var aHeight: Integer);
    procedure lstOrdersDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
  private
    OKPressed: Boolean;
    function MeasureColumnHeight(TheOrderText: string;
      Index: Integer): integer;
  end;

function ExecuteUnPII Orders(SelectedList: TList): Boolean;

implementation

{$R *.DFM}

uses rOrders, uConst, uCore, rMeds, fMeds;

function ExecuteUnPII Orders(SelectedList: TList): Boolean;
var
  frmUnPII Orders: TfrmUnPII Orders;
  AnOrder: TOrder;
  sError, OriginalID: string;
  i: Integer;
begin
  Result := False;
  if SelectedList.Count = 0 then Exit;
  frmUnPII Orders := TfrmUnPII Orders.Create(Application);
  try //   ResizeFormToFont(TForm(frmUnPII Orders));
    ResizeAnchoredFormToFont(frmUnPII Orders);
    frmUnPII Orders.Left := (Screen.WorkAreaWidth - frmUnPII Orders.Width) div 2;
    frmUnPARKOrders.Top := (Screen.WorkAreaHeight - frmUnPII Orders.Height) div 2;
    with SelectedList do for i := 0 to Count - 1 do
      frmUnPII Orders.lstOrders.Items.Add(TOrder(Items[i]).Text);
    frmUnPII Orders.ShowModal;
    if frmUnPII Orders.OKPressed then
    begin
      StatusText('Requesting Un-PII ...');
      with SelectedList do for i := 0 to Count - 1 do
      begin
        AnOrder := TOrder(Items[i]);
        OriginalID := AnOrder.ID;
        sError := UnPII Order(OriginalID,'PickupAt');
        if sError <> '' then
          InfoBox(sError,'Un-PII  Warning', MB_OK);
        AnOrder.ActionOn := OriginalID + '=UP';
        SendMessage(Application.MainForm.Handle, UM_NEWORDER, ORDER_ACT, Integer(Items[i]));
      end;
      Result := True;
      StatusText('');
    end;
  finally
    with SelectedList do for i := 0 to Count - 1 do UnlockOrder(TOrder(Items[i]).ID);
    frmUnPII Orders.Release;
  end;
end;

procedure TfrmUnPII Orders.FormCreate(Sender: TObject);
begin
  inherited;
  OKPressed := False;
end;

procedure TfrmUnPII Orders.lstOrdersDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  x: string;
  ARect: TRect;
begin
  inherited;
  x := '';
  ARect := Rect;
  with lstOrders do
  begin
    Canvas.FillRect(ARect);
    Canvas.Pen.Color := Get508CompliantColor(clSilver);
    Canvas.MoveTo(0, ARect.Bottom - 1);
    Canvas.LineTo(ARect.Right, ARect.Bottom - 1);
    if Index < Items.Count then
    begin
      x := Items[Index];
      DrawText(Canvas.handle, PChar(x), Length(x), ARect, DT_LEFT or DT_NOPREFIX or DT_WORDBREAK);
    end;
  end;
end;

procedure TfrmUnPII Orders.lstOrdersMeasureItem(Control: TWinControl;
  Index: Integer; var aHeight: Integer);
var
  x:string;
begin
  inherited;
  with lstOrders do if Index < Items.Count then
  begin
    x := Items[index];
    aHeight := MeasureColumnHeight(x, Index);
  end;
end;

procedure TfrmUnPII Orders.cmdOKClick(Sender: TObject);
begin
  inherited;
  OKPressed := True;
  Close;
end;

procedure TfrmUnPII Orders.cmdCancelClick(Sender: TObject);
begin
  inherited;
  Close;
end;

function TfrmUnPII Orders.MeasureColumnHeight(TheOrderText: string;
  Index: Integer): integer;
var
  ARect: TRect;
begin
  ARect.Left := 0;
  ARect.Top := 0;
  ARect.Bottom := 0;
  ARect.Right := lstOrders.Width - 6;
  Result := WrappedTextHeightByFont(lstOrders.Canvas,lstOrders.Font,TheOrderText,ARect);
end;

end.
