unit fODAnatPathPreview;

// Developer: Theodore Fontana

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Forms, Vcl.Controls, Vcl.StdCtrls, Vcl.ComCtrls,
  Vcl.ExtCtrls, Vcl.Graphics, Vcl.Menus, Vcl.CheckLst, Vcl.Buttons, ORCtrls;

type
  TfAnatPathPreview = class(TForm)
    pnlBottom: TPanel;
    btnAccept: TBitBtn;
    btnBack: TBitBtn;
    pnlSummary: TPanel;
    moText: TCaptionMemo;
    lvSpecimen: TORListView;
    procedure FormCreate(Sender: TObject);
    procedure btnBackClick(Sender: TObject);
  private
  public
  end;

var
  fAnatPathPreview: TfAnatPathPreview;

implementation

{$R *.dfm}

uses
  fODAnatPath, fODAnatPathBuilder, fODAnatpathSpecimen;

procedure TfAnatPathPreview.FormCreate(Sender: TObject);
var
  I: Integer;
  fSpecimen: TfAnatPathSpecimen;
  lvItem: TListItem;
  sOrderComment: string;
  fBuilder: TfAnatPathBuilder;
begin
  pnlSummary.Caption := frmODAnatPath.GetSummary;

  for I := 0 to frmODAnatPath.pgSpecimen.PageCount - 1 do
  begin
    fSpecimen := frmODAnatPath.GetSpecificSpecimenForm(I);
    if fSpecimen <> nil then
    begin
      lvItem := lvSpecimen.Items.Add;
      lvItem.Caption := IntToStr(I+1);
      lvItem.SubItems.Add(fSpecimen.CollectionSample.SpecimenName);
      lvItem.SubItems.Add(fSpecimen.CollectionSample.SpecimenDescription);
      lvItem.SubItems.Add(fSpecimen.CollectionSample.CollSampName);
    end;
  end;

  sOrderComment := frmODAnatPath.GetOrderComment;
  if sOrderComment <> '' then
  begin
    moText.Lines.Add('Order Comment');
    moText.Lines.Add('--------------------------------------------------------------------------');
    moText.Lines.Add(sOrderComment);
    moText.Lines.Add('');
  end;

  for I := 0 to frmODAnatPath.pgText.PageCount - 1 do
  begin
    fBuilder := frmODAnatPath.GetSpecificPageTextForm(I);
    if fBuilder <> nil then
      moText.Lines.AddStrings(fBuilder.GetTextEx);
  end;
end;

procedure TfAnatPathPreview.btnBackClick(Sender: TObject);
begin
  Close;
end;

end.
