unit fODAnatPath;

// Incomplete
// -----------------------------------------------------------------------------
//  BuilderElement Combo dropdown width
//  BuilderElement resize method?
//  Edit Order (populate the form)

// New
// -----------------------------------------------------------------------------
//  Max allowed specimen (VistA configuration)
//  Only allow the same specimen to be seleted as multiple specimen order (VistA configuration)
//  BuilderElement associated date/time restrict to past/future dates (VistA configuration)


//  **** Still needs to be unit tested to verify that the rewrite is in fact valid
//  **** Do Not Use (M components not yet on the v32 database)


// Developer: Theodore Fontana

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls, Spin,
  Forms, Dialogs, StdCtrls, ORCtrls, ORfn, fODBase, ExtCtrls, ComCtrls, uConst,
  ORDtTm, Buttons, Menus, ORNet, TypInfo, VAUtils,
  fODAnatPathSpecimen, fODAnatPathBuilder, VA508AccessibilityManager;

type
  TUserAction = (cNew,cClick,cAccept);
  TOrderPrompt = (URG,CDT,SSB,CTY,HOF,SPH,ODC);

  TfrmODAnatPath = class(TfrmODBase)
    lblAvailTests: TLabel;
    cboAvailTest: TORComboBox;
    MessagePopup: TPopupMenu;
    ViewinReportWindow: TMenuItem;
    pnlOrderElements: TPanel;
    pnlTabs: TPanel;
    pgSpecimen: TPageControl;
    gpOrderElements: TGridPanel;
    pgText: TPageControl;
    pnlUrgency: TPanel;
    lbUrgency: TLabel;
    cboUrgency: TORComboBox;
    pnlCollectionDate: TPanel;
    lbORDateBox: TLabel;
    calCollTime: TORDateBox;
    pnlCollectionType: TPanel;
    lbCollectionType: TLabel;
    cboCollType: TORComboBox;
    pnlHowOften: TPanel;
    lbOften: TLabel;
    lblHowManyDays: TLabel;
    cboFrequency: TORComboBox;
    txtDays: TCaptionEdit;
    pnlSurgeon: TPanel;
    lbSurgeon: TLabel;
    cboPtProvider: TORComboBox;
    pnlSpecimenSubmitted: TPanel;
    lbSubmittedby: TLabel;
    edSubmittedby: TCaptionEdit;
    pnlTotal: TPanel;
    pnlOrderCommentTypes: TPanel;
    pnlDoseDraw: TPanel;
    lblDose: TLabel;
    lblDraw: TLabel;
    pnlAntiCoagulation: TPanel;
    lblAntiCoagulant: TLabel;
    txtAntiCoagulant: TCaptionEdit;
    pnlUrineVolume: TPanel;
    lblUrineVolume: TLabel;
    pnlPeakTrough: TPanel;
    lblPeakTrough: TLabel;
    grpPeakTrough: TRadioGroup;
    pnlOrderComment: TPanel;
    lblOrderComment: TLabel;
    txtOrderComment: TCaptionEdit;
    edPeakComment: TCaptionEdit;
    txtUrineVolume: TSpinEdit;
    txtDoseTime: TORDateBox;
    txtDrawTime: TORDateBox;
    rbUrineML: TRadioButton;
    rbUrineCC: TRadioButton;
    rbUrineOZ: TRadioButton;
    FSpecimenSelect: TORComboBox;
    lvSpecimen: TORListView;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormResize(Sender: TObject);
    procedure pgTextResize(Sender: TObject);
    procedure ViewinReportWindowClick(Sender: TObject);
    procedure cmdAcceptClick(Sender: TObject);
    procedure cboAvailTestNeedData(Sender: TObject;
              const StartFrom: string; Direction, InsertAt: Integer);
    procedure cboAvailTestSelect(Sender: TObject);
    procedure cboAvailTestExit(Sender: TObject);
    procedure UpdatePageResponses(Sender: TObject);
    procedure UpdateSpecimenResponses(Sender: TObject);
    procedure cboUrgencyChange(Sender: TObject);
    procedure calCollTimeChange(Sender: TObject);
    procedure edSubmittedbyExit(Sender: TObject);
    procedure cboCollTypeChange(Sender: TObject);
    procedure cboFrequencyChange(Sender: TObject);
    procedure txtDaysChange(Sender: TObject);
    procedure cboPtProviderChange(Sender: TObject);
    procedure CommentExit(Sender: TObject);
    procedure CommentAntiCoagulantExit(Sender: TObject);
    procedure CommentUrineVolumeChange(Sender: TObject);
    procedure DoseDrawComment(Sender: TObject);
    procedure CommentPeakTroughClick(Sender: TObject);
    procedure edPeakCommentExit(Sender: TObject);
    procedure cboSpecimenChange(Sender: TObject);
    procedure cboSpecimenAction(Sender: TObject);
    procedure lvSpecimenDblClick(Sender: TObject);
    procedure cboPtProviderNeedData(Sender: TObject; const StartFrom: string;
      Direction, InsertAt: Integer);
  private
    FAList: TStringList;
    FCmtTypes: TStringList;
    FOtherSpecCollSamp: TStringList;
    FLastAction: TUserAction;
    FOrderAction: Integer;
    FEvtDelayLoc: Integer;
    FEvtDivision: Integer;
    FID: string;
    FLastLabID: string;
    FChangeMessage: string;
    procedure UpdateAllOrderResponses;
    procedure UpdateAllLegacyResponses(mUpdate: Boolean);
    procedure UpdateLegacyCommentResponse(mUpdate: Boolean);
    procedure ResetOrderGrid;
    procedure BuildOrderGrid;
    procedure AlterContainerCaption(iPanel: TPanel; iReq: Boolean);
    procedure AlterCaption(iLabel: TLabel; iReq: Boolean);
    procedure UpdateOrderElement(vID,vHide,vReq,vDef: string);
    procedure OrderCommentReset;
    procedure BuildPages;
    procedure BuildSpecimenSelect(LabTestIEN: Integer);
    procedure GetAllSpecimens;
    procedure SetupCollTimes(CollType: string);
    function ValidCollTime(UserEntry: string): string;
  protected
    procedure InitDialog; override;
    procedure Validate(var AnErrMsg: string); override;
  public
    procedure SetupDialog(OrderAction: Integer; const ID: string); override;
    procedure LoadRequiredComment(CmtType: Integer);
    procedure DeletePage(nText: TTabSheet);
    procedure UpdatePageCounts;
    procedure UpdateOrderText;
    procedure ChangeOrderPromptValue(sCode,sValue: string);
    function GetSummary: string;
    function GetOrderComment: string;
    function SpecimenItemMatch(sValue: string; iValue: Integer): Boolean;
    function GetCurrentSpecimenForm: TfAnatPathSpecimen;
    function GetSpecificSpecimenForm(Value: Integer): TfAnatPathSpecimen;
    function GetCurrentPagTextForm: TfAnatPathBuilder;
    function GetSpecificPageTextForm(Value: Integer): TfAnatPathBuilder;
    property EvtDelayLoc: Integer read FEvtDelayLoc write FEvtDelayLoc;
    property EvtDivision: Integer read FEvtDivision write FEvtDivision;
  end;

  TLabTest = class(TObject)
    TestID: Integer;                      { IEN of Lab Test }
    TestName: string;                     { Name of Lab Test }
    LabSubscript: string;                 { which section of Lab? }
    UniqueCollSamp: Boolean;              { true if not prompt CollSamp }
    SpecimenList: TStringList;            { Strings: IEN^Specimen Name }
    UrgencyIEN: Integer;                  { IEN of Urgency }
    UrgencyList: TStringList;             { Strings: IEN^Urgency Name }
    ForceUrgency: Boolean;                { true if not prompt Urgency }
    SurgeonIEN: Integer;                  { IEN of 200 User }
    SurgeonName: string;                  { Name of 200 User }
    SpecimenSubmittedBy: string;          { Name or other free text of what which submitted the specimen }
    Comment: TStringList;                 { text of comment }
    CurReqComment: string;                { name of required comment }
    CurWardComment: TStringList;          { WP of Ward Comment }
    FLoadedTestData: TStringList;
    constructor Create(const LabTestIEN: string; Responses: TResponses);
    destructor Destroy; override;
    procedure ChangeComment(const CommentText: string);
    procedure LoadSpecimen(AComboBox: TORComboBox);
    procedure LoadUrgency(CollType: string; AComboBox: TORComboBox);
    function NameOfUrgency: string;
    function ObtainUrgency: Boolean;
    function ObtainComment: Boolean;
  end;

var
  frmODAnatPath: TfrmODAnatPath;
  ALabTest: TLabTest;
  uDfltCollType: string;
  uDfltCollSamp: Integer;
  uDfltUrgency: Integer;
  UserHasLRLABKey: Boolean;
  LRFZX   : string;    // the default collection type  (LC,WC,SP,I)   *remove LC,I
  LRFSAMP : string;    // the default sample           (ptr)
  LRFSPEC : string;    // the default specimen         (ptr)
  LRFDATE : string;    // the default collection time  (NOW,NEXT,AM,PM,T...)
  LRFURG  : string;    // the default urgency          (number)		TRY '2'
  LRFSCH  : string;    // the default schedule?        (ONE TIME, QD, ...)

const
  CmtType: array[0..6] of string = ('ANTICOAGULATION','DOSE/DRAW TIMES','ORDER COMMENT',
                                    'ORDER COMMENT MODIFIED','TDM (PEAK-TROUGH)',
                                    'TRANSFUSION','URINE VOLUME');

implementation

{$R *.DFM}

uses
  rODBase, rODLab, uCore, rCore, fODLabOthSpec, fLabCollTimes, rOrders, uODBase,
  fRptBox, fFrame, fODAnatPathPreview;

{$REGION 'TfrmODAnatPath'}

//  1. Form Create
//  2. SetupDialog
//  3. InitDialog (restart)

procedure TfrmODAnatPath.FormCreate(Sender: TObject);
var
  I: Integer;
begin
  FAList := TStringList.Create;
  FOtherSpecCollSamp := TStringList.Create;
  FCmtTypes := TStringList.Create;
  for I := 0 to 6 do
    FCmtTypes.Add(CmtType[I]);

  frmFrame.pnlVisit.Enabled := False;
  AutoSizeDisabled := True;

  inherited;

  frmODAnatPath := Self;
end;

procedure TfrmODAnatPath.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FCmtTypes.Free;
  FAList.Free;
  FOtherSpecCollSamp.Free;

  frmFrame.pnlVisit.Enabled := True;

  inherited;
end;

procedure TfrmODAnatPath.FormResize(Sender: TObject);
begin
  inherited;

  if pgText.Visible then
  begin
    pgText.Height := memOrder.Top - pgText.Top - 5;
    pgText.Width := Width - 5;
  end;
end;

procedure TfrmODAnatPath.pgTextResize(Sender: TObject);
begin
  inherited;

  pgText.Left := 3;
  pgText.Width := Width - 13;
end;

procedure TfrmODAnatPath.ViewinReportWindowClick(Sender: TObject);
begin
  inherited;

  ReportBox(memMessage.Lines, 'Lab Procedure (Anatomic Pathology)', True);
end;

procedure TfrmODAnatPath.cmdAcceptClick(Sender: TObject);
begin
  UpdateAllOrderResponses;

  fAnatPathPreview := TfAnatPathPreview.Create(Self);
  try
    fAnatPathPreview.ShowModal;
    if fAnatPathPreview.ModalResult = mrOk then
      onCloseQuery := nil
    else
      Exit;
  finally
    fAnatPathPreview.Free;
  end;

  FLastAction := cAccept;
  FLastLabID := '';

  inherited;
end;

procedure TfrmODAnatPath.cboAvailTestNeedData(Sender: TObject;
              const StartFrom: string; Direction, InsertAt: Integer);
begin
  cboAvailTest.ForDataUse(SubsetOfOrderItems(StartFrom, Direction, 'S.AP', Responses.QuickOrder));
end;

procedure TfrmODAnatPath.cboAvailTestSelect(Sender: TObject);
begin
  inherited;

  if (Length(cboAvailTest.ItemID) = 0) or (cboAvailTest.ItemID = '0') or
     (cboAvailTest.ItemID = FLastLabID) then
    Exit;

  if FLastLabID <> '' then
    if ShowMsg('The current action will reset this form - press "YES" to "CONTINUE".',
               smiWarning, smbYesNo) = smrYes then
    begin
      cboAvailTest.SelectByID(FLastLabID);
      Exit;
    end;

  //  *** rebuild everything for the new order *********************************
  FLastAction := cClick;
  FLastLabID := cboAvailTest.ItemID;
  InitDialog;
  ALabTest := TLabTest.Create(cboAvailTest.ItemID, Responses);
  //   *************************************************************************

  StatusText('Setting of Dialog Configuration by Test');

  BuildOrderGrid;

  BuildSpecimenSelect(ALabTest.TestID);

  // Word Processing Pages
  BuildPages;

  // Ward Comment
  pnlMessage.TabOrder := cboAvailTest.TabOrder + 1;
  OrderMessage(ALabTest.CurWardComment.Text);

  try
    FChangeMessage := sCallV('ORWLRAP1 CONFIG', ['OCM', ALabTest.TestID]);
  except
  end;

  if FSpecimenSelect.Items.Count = 1 then
  begin
    FSpecimenSelect.ItemIndex := 0;
    cboSpecimenChange(FSpecimenSelect);
  end;

  UpdateAllOrderResponses;
  StatusText('');
end;

procedure TfrmODAnatPath.cboAvailTestExit(Sender: TObject);
begin
  inherited;

  if (Length(cboAvailTest.ItemID) = 0) or (cboAvailTest.ItemID = '0') or
     (cboAvailTest.ItemID = FLastLabID) then
    Exit;

  cboAvailTestSelect(cboAvailTest);
  cboAvailTest.SetFocus;
  PostMessage(Handle, WM_NEXTDLGCTL, 0, 0);
end;

procedure TfrmODAnatPath.UpdatePageResponses(Sender: TObject);
var
  pgBuilderFormT: TfAnatPathBuilder;
begin
  if Sender is TTabSheet then
  begin
    pgBuilderFormT := GetSpecificPageTextForm(TTabSheet(Sender).PageIndex);
    if pgBuilderFormT <> nil then
      pgBuilderFormT.UpdateResponses;
  end;
end;

procedure TfrmODAnatPath.UpdateSpecimenResponses(Sender: TObject);
var
  pgBuilderFormS: TfAnatPathSpecimen;
begin
  if Sender is TTabSheet then
  begin
    pgBuilderFormS := GetSpecificSpecimenForm(TTabSheet(Sender).PageIndex);
    if pgBuilderFormS <> nil then
      pgBuilderFormS.UpdateResponses;
  end;
end;

procedure TfrmODAnatPath.cboUrgencyChange(Sender: TObject);
begin
  inherited;

  if ALabTest = nil then
    Exit;

  ALabTest.UrgencyIEN := cboUrgency.ItemIEN;

  UpdateAllLegacyResponses(True);
end;

procedure TfrmODAnatPath.calCollTimeChange(Sender: TObject);
begin
  inherited;

  if ALabTest = nil then
    Exit;

  UpdateAllLegacyResponses(True);
end;

procedure TfrmODAnatPath.edSubmittedbyExit(Sender: TObject);
begin
  inherited;

  if ALabTest = nil then
    Exit;

  ALabTest.SpecimenSubmittedBy := Trim(edSubmittedby.Text);

  UpdateAllLegacyResponses(True);
end;

procedure TfrmODAnatPath.cboCollTypeChange(Sender: TObject);
begin
  inherited;

  if ALabTest = nil then
    Exit;

  SetupCollTimes(cboCollType.ItemID);
  ALabTest.LoadUrgency(cboCollType.ItemID, cboUrgency);

  UpdateAllLegacyResponses(True);
end;

procedure TfrmODAnatPath.cboFrequencyChange(Sender: TObject);
var
  tmp,HowManyText: string;
const
  HINT_TEXT1 = 'Enter a number of days';
  HINT_TEXT2 = ', or an "X" followed by a number of times.';
begin
  inherited;

  if ALabTest = nil then
    Exit;

  if cboFrequency.ItemIndex <> -1 then
  begin
    tmp := cboFrequency.Items[cboFrequency.ItemIndex];

    if Piece(tmp,U,3) <> 'O' then
    begin
      lblHowManyDays.Enabled := True;

      if Piece(tmp,U,3) = 'C' then
        txtDays.Hint := HINT_TEXT1 + HINT_TEXT2
      else
        txtDays.Hint := '';

      txtDays.Enabled := True;

      if txtDays.Text = '' then
        HowManyText := 'no value'
      else HowManyText := txtDays.Text;
        txtDays.Showhint := True;
    end else
    begin
      txtDays.Text := '';
      lblHowManyDays.Enabled := False;
      txtDays.Enabled := False;
      HowManyText := 'no value';
      txtDays.ShowHint := False;
    end;
  end;

  UpdateAllLegacyResponses(True);
end;

procedure TfrmODAnatPath.txtDaysChange(Sender: TObject);
begin
  inherited;

  UpdateAllLegacyResponses(True);
end;

procedure TfrmODAnatPath.cboPtProviderChange(Sender: TObject);
begin
  inherited;

  if ALabTest = nil then
    Exit;

  ALabTest.SurgeonIEN := cboPtProvider.ItemIEN;
  if cboPtProvider.ItemIEN > 0 then
    ALabTest.SurgeonName := Piece(cboPtProvider.Items[cboPtProvider.ItemIndex],U,2)
  else
    ALabTest.SurgeonName := '';

  UpdateAllLegacyResponses(True);
end;

procedure TfrmODAnatPath.CommentExit(Sender: TObject);
begin
  inherited;

  if ALabTest = nil then
    Exit;

  ALabtest.Comment.Clear;
  if txtOrderComment.Text <> '' then
  begin
    ALabtest.ChangeComment('~For Test: ' + ALabtest.TestName);
    ALabtest.ChangeComment(txtOrderComment.Text);
  end;

  UpdateLegacyCommentResponse(True);
end;

procedure TfrmODAnatPath.CommentAntiCoagulantExit(Sender: TObject);
begin
  inherited;

  if ALabTest = nil then
    Exit;

  ALabTest.Comment.Clear;
  if txtAntiCoagulant.Text <> '' then
  begin
    ALabTest.ChangeComment('~For Test: ' + ALabTest.TestName);
    ALabTest.ChangeComment('~Anticoagulant: ' + txtAntiCoagulant.Text);
  end;

  UpdateLegacyCommentResponse(True)
end;

procedure TfrmODAnatPath.CommentUrineVolumeChange(Sender: TObject);

  function UrineUnits: string;
  begin
    if rbUrineML.Checked then
      Result := 'ml'
    else if rbUrineCC.Checked then
      Result := 'cc'
    else if rbUrineOZ.Checked then
      Result := 'oz'
    else
      Result := '';
  end;

begin
  inherited;

  if ALabTest = nil then
    Exit;

  if txtUrineVolume.Value < 0 then
    txtUrineVolume.Value := 0;

  ALabTest.Comment.Clear;
  ALabTest.ChangeComment('~For Test: ' + ALabTest.TestName);
  ALabTest.ChangeComment(txtUrineVolume.Text + ' ' + UrineUnits);

  UpdateLegacyCommentResponse(True)
end;

procedure TfrmODAnatPath.DoseDrawComment(Sender: TObject);
begin
  inherited;

  if ALabTest = nil then
    Exit;

  ALabTest.Comment.Clear;
  ALabTest.ChangeComment('~For Test: ' + ALabTest.TestName);
  ALabTest.ChangeComment('~Last dose: ' + txtDoseTime.Text + '   draw time: '+ txtDrawTime.Text);

  UpdateLegacyCommentResponse(True)
end;

procedure TfrmODAnatPath.CommentPeakTroughClick(Sender: TObject);
begin
  inherited;

  if ALabTest = nil then
    Exit;

  ALabTest.Comment.Clear;
  if grpPeakTrough.ItemIndex <> -1 then
  begin
    ALabTest.ChangeComment('~For Test: ' + ALabTest.TestName);
    ALabTest.ChangeComment('~Dose is expected to be at ' + UpperCase(grpPeakTrough.Items[grpPeakTrough.ItemIndex]) + ' level.');

    if edPeakComment.Text <> '' then
      ALabTest.ChangeComment(edPeakComment.Text);
  end else if edPeakComment.Text <> '' then
  begin
    ALabTest.ChangeComment('~For Test: ' + ALabTest.TestName);
    ALabTest.ChangeComment(edPeakComment.Text);
  end;

  UpdateLegacyCommentResponse(True)
end;

procedure TfrmODAnatPath.edPeakCommentExit(Sender: TObject);
begin
  inherited;

  CommentPeakTroughClick(Sender);
end;

procedure TfrmODAnatPath.cboSpecimenChange(Sender: TObject);
var
  spec: string;
  nSpecimen: TTabSheet;
  lvItem: TListItem;
  fSpecimen,OtherForm: TfAnatPathSpecimen;
  I,specIEN: Integer;
begin
  inherited;

  if ALabTest = nil then
    Exit;

  if FSpecimenSelect.Text = 'Other...' then
    if (FSpecimenSelect.ItemIndex >= 0) and (FSpecimenSelect.ItemIEN = 0) then
    begin
      GetAllSpecimens;
      Exit;
    end;

  if FSpecimenSelect.ItemIEN < 1 then
    Exit;

  spec := Piece(TORComboBox(Sender).Items[TORComboBox(Sender).ItemIndex],U,2);
  specIEN := FSpecimenSelect.ItemIEN;

  nSpecimen := TTabSheet.Create(pgSpecimen);
  nSpecimen.PageControl := pgSpecimen;
  nSpecimen.Caption := IntToStr(pgSpecimen.PageCount);
  nSpecimen.TabVisible := False;
  nSpecimen.onExit := UpdateSpecimenResponses;

  lvItem := lvSpecimen.Items.Add;
  lvItem.Caption := IntToStr(pgSpecimen.PageCount);
  lvItem.SubItems.Add(spec);

  fSpecimen := TfAnatPathSpecimen.Create(nSpecimen, spec, specIEN);
  fSpecimen.Parent := nSpecimen;
  fSpecimen.Show;

  UpdatePageCounts;

  for I := 0 to FOtherSpecCollSamp.Count - 1 do
    if Piece(FOtherSpecCollSamp[I],U,1) = IntToStr(specIEN) then
    begin
      OtherForm := TfAnatPathSpecimen(FOtherSpecCollSamp.Objects[I]);

      if fSpecimen.cboCollSamp.Items.IndexOf('Other...') = -1 then
      begin
        fSpecimen.cboCollSamp.Items.Add('0^Other...');
        if fSpecimen.cboCollSamp.ItemIndex < 0 then
          fSpecimen.cboCollSamp.ItemIndex := fSpecimen.cboCollSamp.Items.IndexOf('Other...');
      end;

      if fSpecimen.cboCollSamp.Items.IndexOf(OtherForm.CollectionSample.CollSampName) = -1 then
      begin
        fSpecimen.cboCollSamp.Items.Insert(0, IntToStr(OtherForm.CollectionSample.CollSampID) + U +
                                           OtherForm.CollectionSample.CollSampName);
        fSpecimen.cboCollSamp.ItemIndex := fSpecimen.cboCollSamp.Items.IndexOf(OtherForm.CollectionSample.CollSampName);
      end;

      Break;
    end;

  fSpecimen.UpdateResponses;
end;

procedure TfrmODAnatPath.cboSpecimenAction(Sender: TObject);
begin
  inherited;

  if ALabTest = nil then
    Exit;

  if FSpecimenSelect.Text = 'Other...' then
    if (FSpecimenSelect.ItemIndex >= 0) and (FSpecimenSelect.ItemIEN = 0) then
      GetAllSpecimens;
end;

procedure TfrmODAnatPath.lvSpecimenDblClick(Sender: TObject);
begin
  inherited;

  if lvSpecimen.ItemIndex = -1 then
    Exit;
  if lvSpecimen.Items.Item[lvSpecimen.ItemIndex].Caption = '' then
    Exit;

  pgSpecimen.ActivePageIndex := StrToInt(lvSpecimen.Items.Item[lvSpecimen.ItemIndex].Caption) - 1;

  UpdatePageCounts;
end;

procedure TfrmODAnatPath.cboPtProviderNeedData(Sender: TObject;
  const StartFrom: string; Direction, InsertAt: Integer);
begin
  cboPtProvider.ForDataUse(SubSetOfProviders(StartFrom, Direction));
end;

// Private ---------------------------------------------------------------------

procedure TfrmODAnatPath.UpdateAllOrderResponses;
var
  AResponse: TResponse;
  AVisitStr: string;
  I: Integer;
  pgBuilderFormS: TfAnatPathSpecimen;
  pgBuilderFormT: TfAnatPathBuilder;
begin
  if Changing or (ALabTest = nil) then
    Exit;

  AResponse := Responses.FindResponseByName('VISITSTR', 1);
  if AResponse <> nil then
    AVisitStr := AResponse.EValue;

  Responses.Clear;

  if ALabTest.TestID > 0 then
    Responses.Update('ORDERABLE', 1, IntToStr(ALabTest.TestID), ALabTest.TestName);

  UpdateAllLegacyResponses(False);
  UpdateLegacyCommentResponse(False);

  if AVisitStr <> '' then
    Responses.Update('VISITSTR', 1, AVisitStr, AVisitStr);

  for I := 0 to pgSpecimen.PageCount - 1 do
  begin
    pgBuilderFormS := GetSpecificSpecimenForm(I);
    if pgBuilderFormS <> nil then
      pgBuilderFormS.UpdateResponses;
  end;

  for I := 0 to pgText.PageCount - 1 do
  begin
    pgBuilderFormT := GetSpecificPageTextForm(I);
    if pgBuilderFormT <> nil then
      pgBuilderFormT.UpdateResponses;
  end;

  UpdateOrderText;
end;

procedure TfrmODAnatPath.UpdateAllLegacyResponses(mUpdate: Boolean);
begin
  if Changing or (ALabTest = nil) then
    Exit;

  if ALabTest.UrgencyIEN > 0 then
    Responses.Update('URGENCY', 1, IntToStr(ALabTest.UrgencyIEN), ALabTest.NameOfUrgency);

  if ALabTest.SpecimenSubmittedBy <> '' then
    Responses.Update('SPCSUBMIT', 1, ALabTest.SpecimenSubmittedBy, ALabTest.SpecimenSubmittedBy);

  if ALabTest.SurgeonIEN > 0 then
    Responses.Update('SURGPROV', 1, IntToStr(ALabTest.SurgeonIEN), ALabTest.SurgeonName);

  if Length(cboCollType.ItemID) > 0 then
    Responses.Update('COLLECT', 1, cboCollType.ItemID, cboCollType.ItemID);

  if calCollTime.FMDateTime > 0 then
    Responses.Update('START', 1, ValidCollTime(calCollTime.Text), calCollTime.Text)
  else Responses.Update('START', 1, '', '');

  if Length(cboFrequency.ItemID) > 0 then
    Responses.Update('SCHEDULE', 1, cboFrequency.ItemID, cboFrequency.Text);

  if txtDays.Enabled then
    Responses.Update('DAYS', 1, txtDays.Text, txtDays.Text);

  if mUpdate then UpdateOrderText;
end;

procedure TfrmODAnatPath.UpdateLegacyCommentResponse(mUpdate: Boolean);
begin
  if ALabTest.Comment.Count > 0 then
    Responses.Update('COMMENT', 1, TX_WPTYPE, ALabTest.Comment.Text);

  if mUpdate then UpdateOrderText;
end;

procedure TfrmODAnatPath.ResetOrderGrid;

  procedure RestorePlacement(iPanel: TPanel; aRow,aColumn,aSpan: Integer);
  var
    nControlItem: TControlItem;
  begin
    iPanel.Visible := True;
    AlterContainerCaption(iPanel, False);

    nControlItem := gpOrderElements.ControlCollection.Items[gpOrderElements.ControlCollection.Indexof(iPanel)];
    nControlItem.SetLocation(aColumn, aRow);
    nControlItem.ColumnSpan := aSpan;
  end;

begin
  OrderCommentReset;

  gpOrderElements.ControlCollection.BeginUpdate;

  RestorePlacement(pnlUrgency, 0, 0, 1);
  RestorePlacement(pnlCollectionDate, 0, 1,1);
  RestorePlacement(pnlSpecimenSubmitted, 0, 2, 1);
  RestorePlacement(pnlCollectionType, 1, 0, 1);
  RestorePlacement(pnlHowOften, 1, 1, 2);
  RestorePlacement(pnlSurgeon, 1, 3, 1);

  gpOrderElements.ControlCollection.EndUpdate;
end;

procedure TfrmODAnatPath.BuildOrderGrid;
var
  sl: TStringList;
  I: Integer;
begin
  if ALabTest = nil then
    Exit;

  Changing := True;
  try
    ResetOrderGrid;

    if ALabTest.ObtainComment then
      LoadRequiredComment(FCmtTypes.IndexOf(ALabTest.CurReqComment));

    gpOrderElements.ControlCollection.BeginUpdate;

    sl := TStringList.Create;
    try
      try
        // Order Elements
        tCallV(sl,'ORWLRAP1 CONFIG',['O', ALabTest.TestID]);

        // O^ID^HIDE(1,0)^REQUIRED(1,0)^DEFAULT_VALUE
        if ((sl.Count > 0) and (sl[0] <> '0')) then
          for I := 0 to sl.Count - 1 do
            UpdateOrderElement(Piece(sl[I],U,2), Piece(sl[I],U,3), Piece(sl[I],U,4),
                               Piece(sl[I],U,5));
      except
      end;
    finally
      sl.Free;
      gpOrderElements.ControlCollection.EndUpdate;
    end;
  finally
    Changing := False;
    UpdateAllLegacyResponses(False);
    UpdateLegacyCommentResponse(True);
  end;
end;

procedure TfrmODAnatPath.AlterContainerCaption(iPanel: TPanel; iReq: Boolean);
var
  I: Integer;
begin
  for I := 0 to iPanel.ControlCount - 1 do
  begin
    if iPanel.Controls[I] is TLabel then
      AlterCaption(TLabel(iPanel.Controls[I]), iReq)
    else if iPanel.Controls[I] is TPanel then
      AlterContainerCaption(TPanel(iPanel.Controls[I]), iReq);
  end;
end;

procedure TfrmODAnatPath.AlterCaption(iLabel: TLabel; iReq: Boolean);
var
  tmp: string;
begin
  tmp := iLabel.Caption;

  if tmp <> '' then
    if ((tmp[1] = '*') and (not iReq)) then
      Delete(tmp, 1, 1)
    else if ((tmp[1] <> '*') and (iReq)) then
      tmp := '*' + tmp;

  iLabel.Caption := tmp;
end;

procedure TfrmODAnatPath.UpdateOrderElement(vID,vHide,vReq,vDef: string);
var
  oCode: TOrderPrompt;
  nValue: Integer;

  procedure ShuffleLeft(iPanel: TPanel);
  var
    nControlItem: TControlItem;
    aColumn,aRow: Integer;
    I: Integer;

    function gpOrderCellEmpty(aColumn,aRow: Integer): Boolean;
    var
      I: Integer;
      nControlItem: TControlItem;
    begin
      Result := False;

      for I := 0 to gpOrderElements.ControlCollection.Count - 1 do
      begin
        nControlItem := gpOrderElements.ControlCollection.Items[I];
        if ((nControlItem.Column = aColumn) and (nControlItem.Row = aRow)) then
        begin
          if nControlItem.Control = nil then
          begin
            Result := True;
            Break;
          end;
          if not nControlItem.Control.Visible then
          begin
            Result := True;
            Break;
          end;
        end;
      end;
    end;

  begin
    nControlItem := gpOrderElements.ControlCollection.Items[gpOrderElements.ControlCollection.Indexof(iPanel)];
    aColumn := nControlItem.Column;
    aRow := nControlItem.Row;

    if aColumn = 0 then
      Exit;

    for I := 0 to gpOrderElements.ColumnCollection.Count - 1 do
      if gpOrderCellEmpty(I, aRow) then
      begin
        nControlItem.SetLocation(I, aRow);
        Break;
      end;
  end;

begin
  Changing := True;
  try
    try
      oCode := TOrderPrompt(GetEnumValue(TypeInfo(TOrderPrompt), vID));

      case oCode of
        URG : begin
                if vReq = '1' then
                  AlterCaption(lburgency, True);
                if vDef <> '' then
                  if TryStrToInt(vDef, nValue) then
                  begin
                    cboUrgency.SelectByIEN(nValue);
                    cboUrgencyChange(cboUrgency);
                  end;
                if vHide = '1' then
                  pnlUrgency.Visible := False;
              end;
        CDT : begin
                if vReq = '1' then
                  AlterCaption(lbORDateBox, True);
                if vHide = '1' then
                  pnlCollectionDate.Visible := False
                else ShuffleLeft(pnlCollectionDate);
              end;
        SSB : begin
                if vReq = '1' then
                  AlterCaption(lbSubmittedby, True);
                if vDef <> '' then
                begin
                  edSubmittedby.Text := vDef;
                  edSubmittedbyExit(edSubmittedby);
                end;
                if vHide = '1' then
                  pnlSpecimenSubmitted.Visible := False
                else ShuffleLeft(pnlSpecimenSubmitted);
              end;
        CTY : begin
                if vReq = '1' then
                  AlterCaption(lbCollectionType, True);
                if vDef <> '' then
                begin
                  cboCollType.SelectByID(vDef);
                  cboCollTypeChange(cboCollType);
                end;
                if vHide = '1' then
                  pnlCollectionType.Visible := False;
              end;
        HOF : begin
                if vReq = '1' then
                  AlterCaption(lbOften, True);
                if vDef <> '' then
                begin
                  cboFrequency.SelectByID(vDef);
                  cboFrequencyChange(cboFrequency);
                end;
                if vHide = '1' then
                  pnlHowOften.Visible := False
                else ShuffleLeft(pnlHowOften);
              end;
        SPH : begin
                if vReq = '1' then
                  AlterCaption(lbSurgeon, True);
                if vDef <> '' then
                  if TryStrToInt(vDef, nValue) then
                  begin
                    cboPtProvider.SelectByIEN(nValue);
                    cboPtProviderChange(cboPtProvider);
                  end;
                if vHide = '1' then
                  pnlSurgeon.Visible := False
                else ShuffleLeft(pnlSurgeon);
              end;
        ODC : begin
                if ALabTest <> nil then
                begin
                  case FCmtTypes.IndexOf(ALabTest.CurReqComment) of
                    0 : begin                                                   // ANTICOAGULATION
                          if vReq = '1' then
                            AlterCaption(lblAntiCoagulant, True);
                          if vDef <> '' then
                          begin
                            txtAntiCoagulant.Text := vDef;
                            CommentAntiCoagulantExit(txtAntiCoagulant);
                          end;
                        end;
                    1 : begin                                                   // DOSE/DRAW TIMES
                          if vReq = '1' then
                          begin
                            AlterCaption(lblDose, True);
                            AlterCaption(lblDraw, True);
                          end;
                        end;
                    2 : begin                                                   // ORDER COMMENT
                          if vReq = '1' then
                            AlterCaption(lblOrderComment, True);
                          if vDef <> '' then
                          begin
                            txtOrderComment.Text := vDef;
                            CommentExit(txtOrderComment);
                          end;
                        end;
                    3 : begin                                                   // ORDER COMMENT MODIFIED
                          if vReq = '1' then
                            AlterCaption(lblOrderComment, True);
                          if vDef <> '' then
                          begin
                            txtOrderComment.Text := vDef;
                            CommentExit(txtOrderComment);
                          end;
                        end;
                    4 : begin                                                   // TDM PEAK-TROUGH
                          if vReq = '1' then
                            AlterCaption(lblPeakTrough, True);
                          if vDef <> '' then
                          begin
                            edPeakComment.Text := vDef;
                            edPeakCommentExit(edPeakComment);
                          end;
                        end;
                    5 : begin                                                   // TRANSFUSION
                          if vReq = '1' then
                            AlterCaption(lblOrderComment, True);
                          if vDef <> '' then
                          begin
                            txtOrderComment.Text := vDef;
                            CommentExit(txtOrderComment);
                          end;
                        end;
                    6 : begin                                                   // URINE VOLUME
                          if vReq = '1' then
                            AlterCaption(lblUrineVolume, True);
                          if vDef <> '' then
                            if TryStrToInt(vDef, nValue) then
                            begin
                              txtUrineVolume.Value := nValue;
                              CommentUrineVolumeChange(txtUrineVolume);
                            end;
                        end;
                    else
                    begin
                      if vReq = '1' then
                        AlterCaption(lblOrderComment, True);
                      if vDef <> '' then
                      begin
                        txtOrderComment.Text := vDef;
                        CommentExit(txtOrderComment);
                      end;
                    end;
                  end;
                end else
                begin
                  if vReq = '1' then
                    AlterCaption(lblOrderComment, True);
                  if vDef <> '' then
                  begin
                    txtOrderComment.Text := vDef;
                    CommentExit(txtOrderComment);
                  end;
                end;

                if vHide = '1' then
                  pnlOrderCommentTypes.Visible := False;
              end;
      end;
    except
    end;
  finally
    Changing := False;
  end;
end;

procedure TfrmODAnatPath.OrderCommentReset;
begin
  AlterContainerCaption(pnlOrderCommentTypes, False);
  pnlOrderCommentTypes.Visible := True;

  grpPeakTrough.ItemIndex := -1;
  edPeakComment.Clear;
  txtUrineVolume.Value := 0;
  rbUrineML.Checked := False;
  rbUrineCC.Checked := False;
  rbUrineOZ.Checked := False;
  txtAntiCoagulant.Clear;
  txtDoseTime.Clear;
  txtDrawTime.Clear;
  txtOrderComment.Clear;

  LoadRequiredComment(2);
end;

procedure TfrmODAnatPath.BuildPages;
var
  I: Integer;
  sl: TStringList;
  nText: TTabSheet;
  fBuilder: TfAnatPathBuilder;
begin
  for I := pgText.PageCount - 1 downto 0 do
    pgText.Pages[I].Free;

  sl := TStringList.Create;
  try
    if ALabTest = nil then
      Exit;

    try
      // Order Elements
      tCallV(sl,'ORWLRAP1 CONFIG',['P', ALabTest.TestID]);

      // P^NUMBER^NAME^RESPONSE_ID
      if ((sl.Count > 0) and (sl[0] <> '0')) then
      begin
        if not pgText.Visible then
        begin
          pgText.Visible := True;
          pgText.Height := 255;
          Constraints.MinHeight := Height + 265;

          if Constraints.MinHeight < Height then
            Height := Constraints.MinHeight;
        end;

        for I := 0 to sl.Count - 1 do
        begin
          nText := TTabSheet.Create(pgText);
          nText.PageControl := pgText;
          nText.Caption := Piece(sl[I],U,3);
          nText.OnExit := UpdatePageResponses;

          fBuilder := TfAnatPathBuilder.Create(nText);
          fBuilder.Parent := nText;
          fBuilder.ResponseID := Piece(sl[I],U,4);
          fBuilder.Show;
        end;
      end;
    except
    end;
  finally
    sl.Free;

    If pgText.PageCount < 1 then
    begin
      if pgText.Visible then
      begin
        Constraints.MinHeight := Height - (pgText.Height + 5);
        Height := Constraints.MinHeight;
        pgText.Visible := False;
      end;
    end else
      pgText.ActivePageIndex := 0;

    FormResize(Self);
  end;
end;

procedure TfrmODAnatPath.BuildSpecimenSelect(LabTestIEN: Integer);
var
  tmpResp: TResponse;
begin
  FSpecimenSelect.Clear;

  if ALabTest = nil then
    Exit;

  ALabTest.LoadSpecimen(FSpecimenSelect);

  if FOrderAction in [ORDER_COPY, ORDER_EDIT] then
  begin
    tmpResp := Responses.FindResponseByName('SPECIMEN' ,1);

    if ((tmpResp <> nil) and (tmpResp.IValue <> '')) then
    begin
      FSpecimenSelect.SelectByID(tmpResp.IValue);
      if FSpecimenSelect.ItemIndex < 0 then
      begin
        ALabTest.SpecimenList.Add(tmpResp.IValue + U + tmpResp.EValue);
        FSpecimenSelect.Items.Insert(0, tmpResp.IValue + U + tmpResp.EValue);
        FSpecimenSelect.ItemIndex := 0  ;
      end;
    end;
  end else
  begin
    if LRFSPEC <> '' then
      FSpecimenSelect.SelectByID(LRFSPEC)
    else if ((FSpecimenSelect.Items.Count = 1) and (FSpecimenSelect.Items.IndexOf('Other...') <> -1)) then
      FSpecimenSelect.ItemIndex := FSpecimenSelect.Items.IndexOf('Other...');
  end;
end;

procedure TfrmODAnatPath.GetAllSpecimens;
var
  OtherSpec: string;
  fSpecimen: TfAnatPathSpecimen;
begin
  inherited;

  if ALabTest = nil then
    Exit;

  FSpecimenSelect.DroppedDown := False;

  ALabTest.SpecimenList.Clear;
  OtherSpec := SelectOtherSpecimen(Font.Size, ALabTest.SpecimenList);

  if OtherSpec = '-1' then
    Exit;
  if FSpecimenSelect.SelectByID(Piece(OtherSpec,U,1)) = -1 then
    FSpecimenSelect.Items.Insert(0, OtherSpec);

  FSpecimenSelect.SelectByID(Piece(OtherSpec,U,1));
  cboSpecimenChange(FSpecimenSelect);

  fSpecimen :=  GetCurrentSpecimenForm;
  if fSpecimen <> nil then
  begin
    FOtherSpecCollSamp.AddObject(OtherSpec, fSpecimen);

    if fSpecimen.cboCollSamp.Items.IndexOf('Other...') = -1 then
    begin
      fSpecimen.cboCollSamp.Items.Add('0^Other...');
      if fSpecimen.cboCollSamp.ItemIndex < 0 then
        fSpecimen.cboCollSamp.ItemIndex := fSpecimen.cboCollSamp.Items.IndexOf('Other...');
    end;
  end;
end;

procedure TfrmODAnatPath.SetupCollTimes(CollType: string);
var
  x,tmpORECALLType,tmpORECALLTime: string;
begin
  x := GetLastCollectionTime;
  tmpORECALLType := Piece(x,U,1);
  tmpORECALLTime := Piece(x,U,2);

  if tmpORECALLTime <> '' then
  begin
    calCollTime.Text := ValidCollTime(tmpORECALLTime);

    if IsFMDateTime(calCollTime.Text) then
    begin
      calCollTime.Text := FormatFMDateTime('mmm dd,yy@hh:nn', StrToFMDateTime(calColltime.Text));
      calColltime.FMDateTime := StrToFMDateTime(tmpORECALLTime);
    end;
  end else if LRFDATE <> '' then
    calCollTime.Text := LRFDATE
  else
  begin
    if CollType = 'SP' then
      calCollTime.Text := 'TODAY'
    else if CollType = 'WC' then
      calCollTime.Text := 'NOW';
  end;
end;

function TfrmODAnatPath.ValidCollTime(UserEntry: string): string;
var
  I: Integer;
const
  FMDateResponses: array[0..3] of string = ('TODAY','NOW','NOON','MID');
begin
  Result := '';

  UserEntry := UpperCase(UserEntry);
  if StrToFMDateTime(UserEntry) < 0 then
    Exit;

  if (UserEntry = 'T') or
     (UserEntry = 'N') or
     (Copy(UserEntry,1,2) = 'T+') or
     (Copy(UserEntry,1,2) = 'T@') or
     (Copy(UserEntry,1,2) = 'T-') or
     (Copy(UserEntry,1,2) = 'N+') then
    Result := UserEntry
  else
    for I := 0 to 3 do
      if Pos(FMDateResponses[I], UserEntry) > 0 then
        Result := UserEntry;

  if Result = '' then
    Result := FloatToStr(StrToFMDateTime(UserEntry));
end;

// Protected -------------------------------------------------------------------

procedure TfrmODAnatPath.InitDialog;           // Called on restart
var
  I,J: Integer;
begin
  inherited;

  StatusText('Initializing Dialog');

  if not (FOrderAction in [ORDER_COPY, ORDER_EDIT]) then
  begin
    if ALabTest <> nil then
    begin
      ALabTest.Free;
      ALabTest := nil;
    end;

    Responses.Clear;
    Responses.Dialog := 'LR OTHER LAB AP TESTS';
  end;

  Changing := True;
  try
    // Order Elements
    ResetOrderGrid;

    // *** Urgency
    CtrlInits.SetControl(cboUrgency, 'Default Urgency');
    uDfltUrgency := StrToInt(Piece(cboUrgency.Items[0],U,1));
    if uDfltUrgency > 0 then
      cboUrgency.SelectByIEN(uDfltUrgency)
    else if LRFURG <> '' then
      cboUrgency.SelectByID(LRFURG);
    cboUrgencyChange(cboUrgency);

    // *** Frequency
    CtrlInits.SetControl(cboFrequency, 'Schedules');
    if LRFSCH <> '' then
      cboFrequency.ItemIndex := cboFrequency.Items.IndexOf(LRFSCH);
    if cboFrequency.ItemIndex = -1 then
      cboFrequency.ItemIndex := cboFrequency.Items.IndexOf('ONE TIME');
    if cboFrequency.ItemIndex = -1 then
      cboFrequency.ItemIndex := cboFrequency.Items.IndexOf('ONCE');
    if EvTDelayLoc > 0 then
      J := MaxDays(EvtDelayLoc, 0)
    else
      J := MaxDays(Encounter.Location, 0);
    if J < 0 then
    begin
      cboFrequency.ItemIndex := cboFrequency.Items.IndexOf('ONE TIME');
      if cboFrequency.ItemIndex = -1 then
        cboFrequency.ItemIndex := cboFrequency.Items.IndexOf('ONCE');
      cboFrequency.Enabled := False;
      cboFrequency.Font.Color := clGrayText;
    end;
    cboFrequencyChange(cboFrequency);

    // *** Collection Type
    CtrlInits.SetControl(cboCollType, 'Collection Types');
    uDfltCollType := ExtractDefault(FAList, 'Collection Types');
    if (uDfltCollType = 'I') or (uDfltCollType = 'LC') then
      uDfltCollType := 'WC';
    if uDfltCollType <> '' then
      cboCollType.SelectByID(uDfltCollType)
    else if LRFZX <> '' then
      cboCollType.SelectByID(LRFZX)
    else if OrderForInpatient then
      cboCollType.SelectByID('WP')
    else
      cboCollType.SelectByID('SP');
    cboCollTypeChange(cboCollType);

    // *** Collection Date/Time
    //     Done through cboCollType

    // *** Specimen Submitted By
    CtrlInits.SetControl(edSubmittedby, 'Default Submitted');
    edSubmittedbyExit(edSubmittedby);

    // *** Surgeon/Physician
    cboPtProvider.ItemIndex := -1;
    cboPtProviderChange(cboPtProvider);

    // Specimen Pages
    FSpecimenSelect.Clear;
    lvSpecimen.Clear;
    for I := pgSpecimen.PageCount - 1 downto 0 do
      pgSpecimen.Pages[I].Free;
    pnlTotal.Caption := '';

    // Word Processing Pages
    if FLastAction <> cClick then
      BuildPages;
  finally
    cboAvailTest.InitLongList('');
    cboAvailTest.OnClick := nil;
    cboAvailTest.SelectByID(FLastLabID);
    cboAvailTest.OnClick := cboAvailTestSelect;

    Changing := False;
    UpdateAllOrderResponses;
    StatusText('');
  end;
end;

procedure TfrmODAnatPath.Validate(var AnErrMsg: string);
var
  I,J: Integer;
  DayMax,NoOfTimes,Minutes: Integer;
  tmp: string;
  Days,MsgTxt: Double;
  pgBuilderFormS: TfAnatPathSpecimen;
  pgBuilderFormT: TfAnatPathBuilder;
const
  TX_NO_TESTS       = 'A Lab Test MUST be selected.';
  TX_BAD_TIME       = 'Collection times must be chosen from the drop down list or entered as valid' +
                      ' Fileman date/times (T@1700, T+1@0800, etc.).' ;
  TX_PAST_TIME      = 'Collection times in the past are not allowed.';
  TX_NO_URGENCY     = 'An urgency MUST be specified.';
  TX_NO_TIME        = 'Collection Time is required.';
  TX_NO_SUBMIT_BY   = 'Specimen submitted is required and MUST be specified.';
  TX_NO_IMMED       = 'Immediate collect is not available for this test.';
  TX_NO_LABCOLLECT  = 'Lab collect is not available for this test.';
  TX_NO_TCOLLTYPE   = 'Collection Type is required.';
  TX_NO_FREQUENCY   = 'A collection frequency MUST be specified.';
  TX_NO_ALPHA       = 'For continuous orders, enter a number of days, or an "X" followed by a number of times.';
  TX_NO_TIMES       = 'A number of times must be entered for continuous orders.';
  TX_TOO_MANY_TIMES = 'For this frequency, the maximum number of times allowed is:  X';
  TX_TOO_MANY_DAYS  = 'Maximum number of days allowed is ';
  TX_NO_SURGEON     = 'Surgeon/Physician is required and MUST be specified.';
  TX_ANTICOAG_REQD  = 'The kind of anticoagulant the patient is on must be specified.';
  TX_DOSEDRAW_REQD  = 'Both DOSE and DRAW times are required for this order.';
  TX_NO_COMMENT     = 'Order comment is required and MUST be specified.';
  TX_TDM_REQD       = 'A value for LEVEL is required for this order.';
  TX_URINE_REQD     = 'A urine volume must be greater than 0.';
  TX_URINE_MEASURE  = 'A urine volume of measurement must be specified.';
  TX_NO_SPECIMEN    = 'A specimen MUST be specified.';
  TX_NO_COLLSAMPLE  = 'A collection sample MUST be specified for each specimen.';
  TX_NO_SPECDESC    = 'A specimen description MUST be specified for each specimen.';

  procedure SetError(const tmp: string);
  begin
    if AnErrMsg <> '' then
      AnErrMsg := AnErrMsg + CRLF;
    AnErrMsg := AnErrMsg + tmp;
  end;

begin
  UpdateAllOrderResponses;

  inherited;

  // Selected Test
  if ALabTest = nil then
  begin
    SetError(TX_NO_TESTS);
    Exit;
  end;

  // Urgency
  If ALabTest.UrgencyIEN < 1 then
    SetError(TX_NO_URGENCY);

  // Collection Date/Time
  if calColltime.FMDateTime = 0 then
    SetError(TX_BAD_TIME)
  else
  begin
    // Date only was entered
    if (calColltime.FMDateTime - Trunc(calColltime.FMDateTime) = 0) then
    begin
      if (Trunc(calColltime.FMDateTime) < FMToday) then
        SetError(TX_PAST_TIME);
    // Date/time was entered
    end else
    begin
      if ((UpperCase(Text) <> 'NOW') and (calColltime.FMDateTime < FMNow)) then
        SetError(TX_PAST_TIME);
    end;
  end;

  // Specimen Submitted by
  if lbSubmittedby.Caption[1] = '*' then
    if ALabTest.SpecimenSubmittedBy = '' then
      SetError(TX_NO_SUBMIT_BY);

  // Collection Type
  if cboCollType.ItemID = 'I' then
  begin
    SetError(TX_NO_IMMED);
    cboCollType.ItemIndex := -1;
  end else if cboCollType.ItemID = 'LC' then
  begin
    SetError(TX_NO_LABCOLLECT);
    cboCollType.ItemIndex := -1;
  end else if Length(cboCollType.ItemID) = 0 then
    SetError(TX_NO_TCOLLTYPE);

  // How Often (Frequency)
  if cboFrequency.ItemIEN < 1 then
    SetError(TX_NO_FREQUENCY);
  if txtDays.Enabled then
  begin
    DayMax := 0;
    if EvtDelayLoc > 0 then
      DayMax := MaxDays(EvtDelayLoc, cboFrequency.ItemIEN)
    else
      DayMax := MaxDays(Encounter.Location, cboFrequency.ItemIEN);

    tmp := Piece(cboFrequency.Items[cboFrequency.ItemIndex],U,3);
    if (tmp = 'C') or (tmp = 'D') then
    begin
      Minutes := StrToIntDef(Piece(cboFrequency.Items[cboFrequency.ItemIndex],U,4), 0);
      Days := Minutes / 1440;

      if (Days = 0) then
        Days := 1;

      if Pos('X', UpperCase(txtDays.Text)) > 0 then
      begin
        tmp := Trim(Copy(txtDays.Text, 1, Pos('X', UpperCase(txtDays.Text)) - 1)) +
               Trim(Copy(txtDays.Text, Pos('X', UpperCase(txtDays.Text)) + 1, 99));
        NoOfTimes := ExtractInteger(tmp);
        Days := NoOfTimes * Days;                                      // # days requested

        if FloatToStr(NoOfTimes) <> tmp then
          SetError(TX_NO_ALPHA)
        else if NoOfTimes = 0 then
          SetError(TX_NO_TIMES)
        else if (Days > DayMax) then
        begin
          MsgTxt := Minutes / 60;
          tmp := ' hour';
          if MsgTxt > 24 then
          begin
            MsgTxt := MsgTxt / 24;
            tmp := ' day';
          end;
          if MsgTxt > 1 then
            tmp := tmp + 's';

          J := 0;
          if Minutes > 0 then
            J := (DayMax * 1440) div Minutes;
          if J = 0 then
            J := 1;

          SetError(TX_TOO_MANY_TIMES + IntToStr(J) + CRLF + '     (Every ' + FloatToStr(MsgTxt) +
                   tmp + ' for a maximum of ' + IntToStr(DayMax) + ' days.)')
        end else
        begin
          tmp := 'X' + IntToStr(NoOfTimes);
          Responses.Update('DAYS', 1, tmp, tmp);
        end;
      end else
      begin
        Days := ExtractInteger(txtDays.Text);
        if FloatToStr(Days) <> Trim(txtDays.Text) then
          SetError(TX_NO_ALPHA)
        else if (Days > DayMax) then
          SetError(TX_TOO_MANY_DAYS + IntToStr(DayMax))
        else
          Responses.Update('DAYS', 1, txtDays.Text, txtDays.Text);
      end;
    end;
  end;

  // Surgeon/Physician
  if lbSurgeon.Caption[1] = '*' then
    if ALabTest.SurgeonIEN < 1 then
      SetError(TX_NO_SURGEON);

  // Order Comment
  case FCmtTypes.IndexOf(ALabTest.CurReqComment) of
    0 : begin                                                                   // ANTICOAGULATION
          if lblAntiCoagulant.Caption[1] = '*' then
            if Pos('Anticoagulant', ALabTest.Comment.Text) = 0 then
              SetError(TX_ANTICOAG_REQD);
        end;
    1 : begin                                                                   // DOSE/DRAW TIMES
          if lblDose.Caption[1] = '*' then
            if (Pos('Last dose:', ALabTest.Comment.Text) = 0) or
               (Pos('draw time:', ALabTest.Comment.Text) = 0) then
              SetError(TX_DOSEDRAW_REQD);
        end;
    2 : begin                                                                   // ORDER COMMENT
          if lblOrderComment.Caption[1] = '*' then
            if Trim(ALabTest.Comment.Text) = '' then
              SetError(TX_NO_COMMENT);
        end;
    3 : begin                                                                   // ORDER COMMENT MODIFIED
          if lblOrderComment.Caption[1] = '*' then
            if Trim(ALabTest.Comment.Text) = '' then
              SetError(TX_NO_COMMENT);
        end;
    4 : begin                                                                   // TDM PEAK-TROUGH
          if lblPeakTrough.Caption[1] = '*' then
            if Pos('Dose is expected', ALabTest.Comment.Text) = 0 then
              SetError(TX_TDM_REQD);
        end;
    5 : begin                                                                   // TRANSFUSION
          if lblOrderComment.Caption[1] = '*' then
            if Trim(ALabTest.Comment.Text) = '' then
              SetError(TX_NO_COMMENT);
        end;
    6 : begin                                                                   // URINE VOLUME
          if lblUrineVolume.Caption[1] = '*' then
          begin
            if ((Trim(ALabTest.Comment.Text) <> '') and
               (ExtractInteger(ALabTest.Comment.Text) <= 0)) then
            SetError(TX_URINE_REQD);
            if not rbUrineML.Checked and not rbUrineCC.Checked and not rbUrineOZ.Checked then
              SetError(TX_URINE_MEASURE);
          end;
        end;
    else if ((ALabTest.CurReqComment <> '') and (ALabTest.Comment.Count < 1)) then
      SetError(TX_NO_COMMENT);
  end;

  // Specimen & Collection Sample
  if pgSpecimen.PageCount < 1 then
  begin
    SetError(TX_NO_SPECIMEN);
    SetError(TX_NO_COLLSAMPLE);
  end;
  for I := 0 to pgSpecimen.PageCount - 1 do
  begin
    pgBuilderFormS := GetSpecificSpecimenForm(I);
    if pgBuilderFormS <> nil then
    begin
      if pgBuilderFormS.CollectionSample.CollSampID < 1 then
        SetError(TX_NO_COLLSAMPLE);
      if pgBuilderFormS.CollectionSample.SpecimenDescription = '' then
        SetError(TX_NO_SPECDESC);
    end;
  end;

  // Pages
  for I := 0 to pgText.PageCount - 1 do
  begin
    pgBuilderFormT := GetSpecificPageTextForm(I);
    if pgBuilderFormT <> nil then
      if not pgBuilderFormT.Valid then
        SetError('The required page "' + pgBuilderFormT.GetCaption + '" has not been completed.');
  end;
end;

// Public ----------------------------------------------------------------------

procedure TfrmODAnatPath.SetupDialog(OrderAction: Integer; const ID: string);
begin
  inherited;

  FLastAction := cNew;               // Track the form movement
  FOrderAction := OrderAction;
  FID := ID;

  StatusText('Initializing Variables');

  FLastLabID := '';
  FillerID := 'LR';

  LRFZX   := KeyVariable['LRFZX'];
  LRFSAMP := KeyVariable['LRFSAMP'];
  LRFSPEC := KeyVariable['LRFSPEC'];
  LRFDATE := KeyVariable['LRFDATE'];
  LRFURG  := KeyVariable['LRFURG'];
  LRFSCH  := KeyVariable['LRFSCH'];

  uDfltUrgency := -1;
  uDfltCollType := '';
  uDfltCollSamp := -1;

  FEvtDelayLoc := 0;
  FEvtDivision := 0;
  UserHasLRLABKey := User.HasKey('LRLAB');
  AllowQuickOrder := False;

  StatusText('Setting Server Variables');

  Constraints.MinHeight := Height - (pgText.Height + 5);
  Height := Constraints.MinHeight;
  pgText.Visible := False;
  FormResize(Self);

  StatusText('Loading Static Data');

  if EvtID > 0 then
  begin
    EvtDelayLoc := StrToIntDef(GetEventLoc1(IntToStr(EvtID)), 0);
    EvtDivision := StrToIntDef(GetEventDiv1(IntToStr(EvtID)), 0);

    if EvtDelayLoc > 0 then
      FastAssign(ODForLab(EvtDelayLoc, EvtDivision), FAList)
    else
      FastAssign(ODForLab(Encounter.Location, EvtDivision), FAList);
  end else
    FastAssign(ODForLab(Encounter.Location), FAList);           // ODForLab returns TStrings with defaults

  CtrlInits.LoadDefaults(FAList);
  CtrlInits.SetControl(cboAvailTest, 'ShortList');
  if cboAvailTest.Items.Count > 0 then
    cboAvailTest.InsertSeparator;

  CtrlInits.SetControl(cboPtProvider, 'Providers');
  if cboPtProvider.Items.Count > 0 then
    cboPtProvider.InsertSeparator;
  cboPtProvider.InitLongList('');

  StatusText('');

  InitDialog;

  // EDIT ACTION ***************************************************************
  //   Edit only can come from the inital opening of the dialog so it cannot go
  //   within InitDialog since it is called after an order is accepted to restart
  //   the process within the same instance, but has to be done after.
  if FOrderAction in [ORDER_COPY, ORDER_EDIT] then
  begin
    Responses.SetControl(cboUrgency, 'URGENCY', 1);
    Responses.SetControl(calCollTime, 'START', 1);
    Responses.SetControl(edSubmittedby, 'SPCSUBMIT', 1);
    Responses.SetControl(cboCollType, 'COLLECT', 1);
    Responses.SetControl(cboFrequency, 'SCHEDULE', 1);
    Responses.SetControl(txtDays, 'DAYS', 1);
    Responses.SetControl(cboPtProvider, 'SURGPROV', 1);

    cboAvailTest.OnClick := nil;
    Responses.SetControl(cboAvailTest, 'ORDERABLE', 1);
    cboAvailTest.OnClick := cboAvailTestSelect;
  end;
  // EDIT ACTION ***************************************************************
end;

procedure TfrmODAnatPath.LoadRequiredComment(CmtType: Integer);
var
  I: Integer;

  procedure Stack(pnl: TPanel; Action: Boolean);
  begin
    if Action then
    begin
      pnl.Visible := True;
      pnl.BringToFront;
    end else
    begin
      pnl.SendToBack;
      pnl.Visible := False;
    end;
  end;

  procedure Switch(CmtType: Integer; Action: Boolean);
  begin
    case CmtType of
      0 : Stack(pnlAntiCoagulation, Action);                       // ANTICOAGULATION
      1 : Stack(pnlDoseDraw, Action);                              // DOSE/DRAW TIMES
      2 : Stack(pnlOrderComment, Action);                          // ORDER COMMENT
      3 : Stack(pnlOrderComment, Action);                          // ORDER COMMENT MODIFIED
      4 : Stack(pnlPeakTrough, Action);                            // TDM PEAK-TROUGH
      5 : Stack(pnlOrderComment, Action);                          // TRANSFUSION
      6 : begin                                                    // URINE VOLUME
            Stack(pnlUrineVolume, Action);
            if Action then
              CommentUrineVolumeChange(txtUrineVolume);
          end;
    end;
  end;

begin
  pnlOrderCommentTypes.Visible := True;

  for I := 0 to 6 do Switch(I, False);

  Switch(CmtType, True);
end;

procedure TfrmODAnatPath.DeletePage(nText: TTabSheet);
var
  I,J: Integer;
begin
  I := nText.PageIndex;
  nText.Free;

  lvSpecimen.Items.Delete(I);
  for J := I to lvSpecimen.Items.Count - 1 do
    lvSpecimen.Items[J].Caption := IntToStr(J+1);

  UpdatePageCounts;
end;

procedure TfrmODAnatPath.UpdatePageCounts;
begin
  if pgSpecimen.PageCount < 1 then
    pnlTotal.Caption := ''
  else
    pnlTotal.Caption := 'Currently Viewing Specimen #' + IntToStr(pgSpecimen.ActivePageIndex + 1) + ' of ' +
                        IntToStr(pgSpecimen.PageCount);
end;

procedure TfrmODAnatPath.UpdateOrderText;
begin
   memOrder.Text := Responses.OrderText;
end;

procedure TfrmODAnatPath.ChangeOrderPromptValue(sCode: string; sValue: string);
var
  oCode: TOrderPrompt;
  nValue: Integer;
  cType,oVal,nVal,sMessage: string;
begin
  if sValue = '' then
    Exit;

  Changing := True;
  try
    try
      oCode := TOrderPrompt(GetEnumValue(TypeInfo(TOrderPrompt), sCode));

      case oCode of
        URG : begin
                cType := 'URGENCY';
                oVal := cboUrgency.Text;
                if TryStrToInt(sValue, nValue) then
                  cboUrgency.SelectByIEN(nValue);
                nVal := cboUrgency.Text;
              end;
        CDT : ;
        SSB : begin
                cType := 'SPECIMEN SUBMITTED BY';
                oVal := edSubmittedby.Text;
                edSubmittedby.Text := sValue;
                nVal := edSubmittedby.Text;
              end;
        CTY : begin
                cType := 'COLLECTION TYPE';
                oVal := cboCollType.Text;
                cboCollType.SelectByID(sValue);
                nVal := cboCollType.Text;
              end;
        HOF : begin
                cType := 'HOW OFTEN?';
                oVal := cboFrequency.Text;
                cboFrequency.SelectByID(sValue);
                nVal := cboFrequency.Text;
              end;
        SPH : begin
                cType := 'SURGEON/PHYSICIAN';
                oVal := cboPtProvider.Text;
                if TryStrToInt(sValue, nValue) then
                  cboPtProvider.SelectByIEN(nValue);
                nVal := cboPtProvider.Text;
              end;
        ODC : begin
                cType := 'ORDER COMMENT';
                case FCmtTypes.IndexOf(ALabTest.CurReqComment) of
                  0 : begin                                                     // ANTICOAGULATION
                        oVal := txtAntiCoagulant.Text;
                        txtAntiCoagulant.Text := sValue;
                        nVal := txtAntiCoagulant.Text;
                      end;
                  1 : ;                                                         // DOSE/DRAW TIMES
                  2 : begin                                                     // ORDER COMMENT
                        oVal := txtOrderComment.Text;
                        txtOrderComment.Text := sValue;
                        nVal := txtOrderComment.Text;
                      end;
                  3 : begin                                                     // ORDER COMMENT MODIFIED
                        oVal := txtOrderComment.Text;
                        txtOrderComment.Text := sValue;
                        nVal := txtOrderComment.Text;
                      end;
                  4 : begin                                                     // TDM PEAK-TROUGH
                        oVal := edPeakComment.Text;
                        edPeakComment.Text := sValue;
                        nVal := edPeakComment.Text;
                      end;
                  5 : begin                                                     // TRANSFUSION
                        oVal := txtOrderComment.Text;
                        txtOrderComment.Text := sValue;
                        nVal := txtOrderComment.Text;
                      end;
                  6 : begin                                                     // URINE VOLUME
                        oVal := txtUrineVolume.Text;
                        if TryStrToInt(sValue, nValue) then
                          txtUrineVolume.Text := sValue;
                        nVal := txtUrineVolume.Text;
                      end;
                  else txtOrderComment.Text := sValue;
                end;
              end;
      end;

      if ((cType <> '') and (FChangeMessage <> '') and (oVal <> nVal)) then
      begin
        sMessage := StringReplace(FChangeMessage, '<cType>', cType, [rfReplaceAll, rfIgnoreCase]);
        sMessage := StringReplace(sMessage, '<oVal>', oVal, [rfReplaceAll, rfIgnoreCase]);
        sMessage := StringReplace(sMessage, '<nVal>', nVal, [rfReplaceAll, rfIgnoreCase]);
        sMessage := StringReplace(sMessage, '$C(13,10)', CRLF, [rfReplaceAll, rfIgnoreCase]);
      end;
    except
    end;
  finally
    Changing := False;
    UpdateAllLegacyResponses(False);
    UpdateLegacyCommentResponse(True);
  end;
end;

function TfrmODAnatPath.GetSummary: string;
begin
  Result := ALabTest.TestName + ' ' + ALabTest.NameOfUrgency + ' ' + cboCollType.Text;
end;

function TfrmODAnatPath.GetOrderComment: string;
begin
  Result := '';

  case FCmtTypes.IndexOf(ALabTest.CurReqComment) of
    0 : if txtAntiCoagulant.Text <> '' then                                                      // ANTICOAGULATION
          Result := 'Anticoagulant: ' + txtAntiCoagulant.Text;
    1 : if (txtDoseTime.Text <> '') or (txtDrawTime.Text <> '') then
          Result := 'Last dose: ' + txtDoseTime.Text + '   draw time: '+ txtDrawTime.Text;       // DOSE/DRAW TIMES
    2 : Result := txtOrderComment.Text;                                                          // ORDER COMMENT
    3 : Result := txtOrderComment.Text;                                                          // ORDER COMMENT MODIFIED
    4 : begin                                                                                    // TDM PEAK-TROUGH
          if grpPeakTrough.ItemIndex <> -1 then
            Result := 'Dose is expected to be at ' + UpperCase(grpPeakTrough.Items[grpPeakTrough.ItemIndex]) + ' level.';
          if edPeakComment.Text <> '' then
            if grpPeakTrough.ItemIndex <> -1 then
              Result := Result + CRLF + edPeakComment.Text
            else
              Result := edPeakComment.Text;
        end;
    5 : Result := txtOrderComment.Text;                                                          // TRANSFUSION
    6 : Result := txtUrineVolume.Text;                                                           // URINE VOLUME
  end;
end;

function TfrmODAnatPath.SpecimenItemMatch(sValue: string; iValue: Integer): Boolean;
var
  I: Integer;
begin
  Result := False;

  for I := 0 to lvSpecimen.Items.Count -  1 do
    if ((sValue = lvSpecimen.Items[I].SubItems[0]) and (I <> iValue)) then
    begin
      Result := True;
      Break;
    end;
end;

function TfrmODAnatPath.GetCurrentSpecimenForm: TfAnatPathSpecimen;
begin
  Result := nil;

  if pgSpecimen.ActivePage <> nil then
    if pgSpecimen.ActivePage.ControlCount > 0 then
      if pgSpecimen.ActivePage.Controls[0] is TfAnatPathSpecimen then
        Result := TfAnatPathSpecimen(pgSpecimen.ActivePage.Controls[0]);
end;

function TfrmODAnatPath.GetSpecificSpecimenForm(Value: Integer): TfAnatPathSpecimen;
begin
  Result := nil;

  if Assigned(pgSpecimen.Pages[Value]) then
    if pgSpecimen.Pages[Value].ControlCount > 0 then
      if pgSpecimen.Pages[Value].Controls[0] is TfAnatPathSpecimen then
        Result := TfAnatPathSpecimen(pgSpecimen.Pages[Value].Controls[0]);
end;

function TfrmODAnatPath.GetCurrentPagTextForm: TfAnatPathBuilder;
begin
  Result := nil;

  if pgText.ActivePage <> nil then
    if pgText.ActivePage.ControlCount > 0 then
      if pgText.ActivePage.Controls[0] is TfAnatPathBuilder then
        Result := TfAnatPathBuilder(pgText.ActivePage.Controls[0]);
end;

function TfrmODAnatPath.GetSpecificPageTextForm(Value: Integer): TfAnatPathBuilder;
begin
  Result := nil;

  if Assigned(pgText.Pages[Value]) then
    if pgText.Pages[Value].ControlCount > 0 then
      if pgText.Pages[Value].Controls[0] is TfAnatPathBuilder then
        Result := TfAnatPathBuilder(pgText.Pages[Value].Controls[0]);
end;

{$ENDREGION}

{$REGION 'TLabTest'}

constructor TLabTest.Create(const LabTestIEN: string; Responses: TResponses);
var
  tmp: string;

  function SetDefColl(iIndex: string): string;
  var
    sl: TStringList;
    I: Integer;
  begin
    Result := '';

    sl := TStringList.Create;
    try
      ExtractItems(sl, FLoadedTestData, 'CollSamp');
      for I := 0 to sl.Count - 1 do
        if Piece(sl[I],U,1) = iIndex then
        begin
          Result := Piece(sl[I],U,2);
          Break;
        end;
    finally
      sl.Free;
    end;
  end;

begin
  SpecimenList := TStringList.Create;
  UrgencyList := TStringList.Create;
  Comment := TStringList.Create;
  CurWardComment := TStringList.Create;

  FLoadedTestData := TStringList.Create;
  LoadLabTestData(FLoadedTestData, LabTestIEN);

  TestID := StrToInt(LabTestIEN);
  TestName := Piece(ExtractDefault(FLoadedTestData, 'Test Name'),U,1);
  LabSubscript := Piece(ExtractDefault(FLoadedTestData, 'Item ID'),U,2);
  CurReqComment := ExtractDefault(FLoadedTestData, 'ReqCom');

  // *** Collection Sample
  if Length(ExtractDefault(FLoadedTestData, 'Unique CollSamp')) > 0 then
    UniqueCollSamp := True;
  tmp := ExtractDefault(FLoadedTestData, 'Unique CollSamp');
  if Length(tmp) = 0 then
    tmp := ExtractDefault(FLoadedTestData, 'Lab CollSamp');
  if Length(tmp) = 0 then
  begin
    tmp := ExtractDefault(FLoadedTestData, 'Default CollSamp');
    if StrToIntDef(tmp, 0) > 0 then
      tmp := SetDefColl(tmp);
  end;
  if Length(tmp) = 0 then
    tmp := '-1';
  uDfltCollSamp := StrToInt(tmp);

  // *** Urgency
  if Length(ExtractDefault(FLoadedTestData, 'Default Urgency')) > 0 then
  begin
    ForceUrgency := True;
    UrgencyList.Add(ExtractDefault(FLoadedTestData, 'Default Urgency'));
    UrgencyIEN := StrToInt(Piece(ExtractDefault(FLoadedTestData, 'Default Urgency'),U,1));
    uDfltUrgency := UrgencyIEN;
  end else
  begin
    ExtractItems(UrgencyList, FLoadedTestData, 'Urgencies');
    if StrToIntDef(LRFURG, 0) > 0 then
      UrgencyIEN := StrToInt(LRFURG)
    else
      UrgencyIEN := uDfltUrgency;
  end;

  ExtractText(CurWardComment, FLoadedTestData, 'GenWardInstructions');
end;

destructor TLabTest.Destroy;
begin
  SpecimenList.Free;
  UrgencyList.Free;
  Comment.Free;
  CurWardComment.Free;
  FLoadedTestData.Free;
end;

procedure TLabTest.ChangeComment(const CommentText: string);
begin
  Comment.Add(CommentText);
end;

procedure TLabTest.LoadSpecimen(AComboBox: TORComboBox);
var
  AllowOther: Boolean;
begin
  if ALabTest = nil then
    Exit;

  AComboBox.Clear;
  AllowOther := False;

  // SpecimenList is expected to be empty because the LabList Load and Extract
  // data no longer populates it. Here we will use COLL^LR7OR3 to get the specimen
  // configured in lab (top of list) and ours configured in 69.73 to build the
  // new list.

  try
    tCallV(SpecimenList, 'ORWLRAP1 SPEC', [ALabTest.TestID]);

    if SpecimenList.Count > 0 then
    begin
      if Piece(SpecimenList[0],U,1) = '1' then
        AllowOther := True;
      SpecimenList.Delete(0);
    end;

    if SpecimenList.Count > 0 then
    begin
      FastAssign(SpecimenList, AComboBox.Items);
      if AllowOther then
        AComboBox.Items.Add('0^Other...');
    end else
      AComboBox.Items.Add('0^Other...');
  except
  end;
end;

procedure TLabTest.LoadUrgency(CollType: string; AComboBox: TORComboBox);
var
  I,PreviousSelectionIndex: Integer;
  PreviousSelectionString: string;
begin
  PreviousSelectionIndex := -1;
  PreviousSelectionString := AComboBox.SelText;

  AComboBox.Clear;
  for I := 0 to UrgencyList.Count - 1 do
  begin
    if (CollType = 'LC') and (Piece(UrgencyList[I],U,3) = '') then
      Continue
    else
      AComboBox.Items.Add(UrgencyList[I]);

    if ((PreviousSelectionString <> '') and (PreviousSelectionString = Piece(UrgencyList[I],U,2))) then
      PreviousSelectionIndex := I;
  end;

  if (LRFURG <> '') and (ALabTest.ObtainUrgency) then
    AComboBox.SelectByID(LRFURG)
  else if PreviousSelectionIndex > -1 then
    AComboBox.ItemIndex := PreviousSelectionIndex
  else
    AComboBox.SelectByIEN(uDfltUrgency);

  UrgencyIEN := AComboBox.ItemIEN;
end;

function TLabTest.NameOfUrgency: string;
var
  I: Integer;
begin
  Result := '';

  for I := 0 to UrgencyList.Count - 1 do
    if StrToInt(Piece(UrgencyList[I], '^', 1)) = UrgencyIEN then
    begin
      Result := Piece(UrgencyList[I], '^', 2);
      Break;
    end;
end;

function TLabTest.ObtainUrgency: Boolean;
begin
  Result := not ForceUrgency;
end;

function TLabTest.ObtainComment: Boolean;
begin
  Result := Length(CurReqComment) > 0;
end;

{$ENDREGION}

end.
