unit fODAllergyCheck;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, ORFn, ORNet, rOrders,
  Winapi.RichEdit, ShellAPI, Vcl.ExtCtrls, fBase508Form, VA508AccessibilityManager, Vcl.ComCtrls;

type
  TfrmAllergyCheck = class(TForm)
    reInfo: TRichEdit;
    lblOverride: TLabel;
    cbAllergyReason: TComboBox;
    btnContinue: TButton;
    btnCancel: TButton;
    lblComment: TLabel;
    amgrMain : TVA508AccessibilityManager;
    cbComment: TComboBox;
    procedure cbAllergyReasonChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure AdjustButtonSize(pButton: TButton);
    procedure AdjustFormItemPositions;
  private
    { Private declarations }
  public
    { Public declarations }
    MedIEN : Integer;
    parentorder : TForm;
    procedure WndProc(var Msg: TMessage); override; // Used to fire URL's in TRichEdit
    procedure setup(aMedIEN:Integer;aSL: TStringList);
  end;

function MedFieldsNeeded(aMedIEN:Integer; var aReason:String; var aComment:String):Boolean;

var
  frmAllergyCheck: TfrmAllergyCheck;

implementation

{$R *.dfm}

////////////////////////////////////////////////////////
// Code Below Modified by KCH on 10/15/2015 for NSR 20071211
function MedFieldsNeeded(aMedIEN:Integer; var aReason:String; var aComment:String):Boolean;
var
  AllergyCheck: TfrmAllergyCheck;
  SL: TSTringList;

begin
  Result := True;
  SL := TStringList.Create; // initialize explicitely
  aReason := '';

  Try
    OrderChecksOnMedicationSelect(SL, 'PSI', aMedIEN);
    if SL.Count > 0 then
      begin
        AllergyCheck := TfrmAllergyCheck.Create(nil);
        Try
          AllergyCheck.setup(aMedIEN,SL);
          Result := AllergyCheck.ShowModal = mrOk;
          aReason := AllergyCheck.cbAllergyReason.Text;
          aComment := AllergyCheck.cbComment.Text;
        Finally
          FreeAndNil(AllergyCheck);
        End;
      end;
  Finally
    SL.Free;
  End;
end;

procedure TfrmAllergyCheck.cbAllergyReasonChange(Sender: TObject);
begin
  btnContinue.Enabled := (Length(Trim(cbAllergyReason.Text)) >= 4) AND
    (Pos('^', cbAllergyReason.Text) = 0);
end;

//********** Code below added by KCH 8/7/2015 for NSR 20071211**************
procedure TfrmAllergyCheck.FormShow(Sender: TObject);
var
 item: TVA508AccessibilityItem;

begin
  inherited;
  Font.Size := mainFontSize + 1;
  AdjustFormItemPositions;

  item := amgrMain.AccessData.FindItem(cbComment);
  amgrMain.AccessData[item.INDEX].AccessText := Trim(cbComment.Text);
end;

procedure TfrmAllergyCheck.setup(aMedIEN: Integer; aSL: TStringList);
var
  OCList: TStringList;
  gridText, substr, s, commentstr: string;
  i,j : Integer;
  remOC: TStringList;
  mask: Word;
  enablecomment : Boolean;

begin
  enablecomment := False;
  commentstr := '';
  mask := SendMessage(reInfo.Handle, EM_GETEVENTMASK, 0, 0);
  SendMessage(reInfo.Handle, EM_SETEVENTMASK, 0, mask or ENM_LINK);
  SendMessage(reInfo.Handle, EM_AUTOURLDETECT, Integer(true), 0);

  remOC := TStringList.Create;
  GetAllergyReasonList(MedIEN,'A');
  FastAssign(RPCBrokerV.Results,cbAllergyReason.Items);
  GetAllergyReasonList(MedIEN,'AR');
  FastAssign(RPCBrokerV.Results,cbComment.Items);

  OCList := aSL;
  for i := 0 to OCList.Count - 1 do
  begin
    s := Piece(OCList[i], U, 4);
    enablecomment := StrToBool(Piece(OCList[i], U, 5));
    if enablecomment then
      commentstr := Piece(OCList[i], U, 7);

    gridText := s;
    substr := Copy(s, 0, 2);
    if substr = '||' then
      begin
        gridText := '';
        substr := Copy(s, 3, Length(s));
        GetXtraTxt(remOC, Piece(substr, '&', 1), Piece(substr, '&', 2));
        reInfo.Lines.Add('(' + inttostr(i + 1) + ' of ' + inttostr(OCList.Count) + ')  ');
        for j := 0 to remOC.Count - 1 do
          reInfo.Lines.Add('      ' + remOC[j]);
      end
    else
      reInfo.Lines.Add(gridText + CRLF);
  end;
  remOC.Free;

  if enablecomment = True then
  begin
    lblComment.Visible := enablecomment;
    cbComment.Visible := lblComment.Visible;
    cbComment.Text := commentstr;
  end;
end;

//********** Code below added by KCH 8/7/2015 for NSR 20071211**************
procedure TfrmAllergyCheck.WndProc(var Msg: TMessage);
var
  p: TENLink;
  sURL: string;

begin
  if (Msg.Msg = WM_NOTIFY) then
    begin
      if (PNMHDR(Msg.lParam).code = EN_LINK) then
        begin
          p := TENLink(Pointer(TWMNotify(Msg).NMHdr)^);
          if (p.Msg = WM_LBUTTONDOWN) then
            begin
              try
                SendMessage(frmAllergyCheck.reInfo.Handle, EM_EXSETSEL, 0, Longint(@(p.chrg)));
                sURL := reInfo.SelText;
                ShellExecute(Handle, 'open', PChar(sURL), NIL, NIL, SW_SHOWNORMAL);
              except
                ShowMessage('Error opening HyperLink');
              end;
            end;
        end;
    end;

  inherited;
end;

procedure TfrmAllergyCheck.AdjustButtonSize(pButton: TButton);
const
  Gap = 5;
begin
  if pButton.Width < Canvas.TextWidth(pButton.Caption) then // CQ2737  GE
      pButton.Width := (Canvas.TextWidth(pButton.Caption) + Gap + Gap); // CQ2737  GE
  if pButton.Height < Canvas.TextHeight(pButton.Caption) then // CQ2737  GE
    pButton.Height := Canvas.TextHeight(pButton.Caption) + Gap; // CQ2737  GE
end;

procedure TfrmAllergyCheck.AdjustFormItemPositions;
begin
  reInfo.Font.Size := mainFontSize;
  case mainFontSize of
    18: begin
          Height := 520;
          Width := 780;
        end;
    14: begin
          Height := 510;
          Width := 770;
        end;
    12: begin
          Height := 470;
          Width := 760;
        end;
    10: begin
          Height := 430;
          Width := 750;
        end;
    8: begin
         Height := 410;
         Width := 710;
       end;
  end;

  lblOverride.Top := reInfo.Top + reInfo.Height + 10;
  cbAllergyReason.Top := lblOverride.Top - 5;
  cbAllergyReason.Left := lblOverride.Left + lblOverride.Width + 5;
  cbAllergyReason.Width := Width-cbAllergyReason.Left - 12;

  lblComment.Top := cbComment.Top + 2;
  cbComment.Left := lblComment.Left + lblComment.Width + 5;
  cbComment.Width := Width - cbComment.Left - 12;

  AdjustButtonSize(btnContinue);
  AdjustButtonSize(btnCancel);
  btnContinue.Left := ClientWidth - (btnContinue.Width+btnCancel.Width+20);
  btnCancel.Left := ClientWidth - (btnCancel.Width+10);
end;

end.
