unit fSurrogateEdit;

{
  This unit implements class TfrmSurrogateEdit that provides data for
  Surrogate Management Functionality within CPRS Graphical User Interface (GUI)
  (Request #20071216)
}

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, fBase508Form, VA508AccessibilityManager,
  Vcl.StdCtrls, ORDtTm, ORCtrls, Vcl.ExtCtrls, Vcl.ComCtrls, ORDtTmRng;

type
  TfrmSurrogateEdit = class(TfrmBase508Form)
    pnlBottom: TPanel;
    bvlBottom: TBevel;
    Panel1: TPanel;
    btnOK: TButton;
    btnCancel: TButton;
    pnlSurrogateTools: TPanel;
    cboSurrogate: TORComboBox;
    ordtbStart: TORDateBox;
    ordtbStop: TORDateBox;
    VA508StaticText1: TVA508StaticText;
    VA508StaticText2: TVA508StaticText;
    VA508StaticTextName: TVA508StaticText;
    stxtChanged: TStaticText;
    btnRestore: TButton;
    stxtRangeInfo: TVA508StaticText;
    stxtRange: TVA508StaticText;
    procedure btnRestoreClick(Sender: TObject);
    procedure ordtbStartDateDialogClosed(Sender: TObject);
    procedure ordtbStopDateDialogClosed(Sender: TObject);
    procedure cboSurrogateNeedData(Sender: TObject; const StartFrom: string;
      Direction, InsertAt: Integer);
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure btnCancelClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure cboSurrogateChange(Sender: TObject);
  private
    { Private declarations }
    fData: String;
    fStart: String;
    fStop: String;
    fMin: String;
    fMax: String;
    fSurrogate: String;

    fCancel: Boolean;

    procedure setValues(aName, aStart, aStop, aMin, aMax, aData: String;
      bLast: Boolean = false);
    procedure setButtonStatus;
  public
    { Public declarations }
  end;

var
  frmSurrogateEdit: TfrmSurrogateEdit;

const
  defaultSurrPeriod = 30; // days to plan ahead

function editSurrogate(var aSurrogate, aStart, aStop, aMin, aMax, aData: String;
  bLast: Boolean = false): Integer;

implementation

uses
  ORFn, rCore, System.UITypes, fOptionsSurrogate;

{$R *.dfm}

function editSurrogate(var aSurrogate, aStart, aStop, aMin, aMax, aData: String;
  bLast: Boolean = false): Integer;
begin
  if not assigned(frmSurrogateEdit) then
    Application.CreateForm(TfrmSurrogateEdit, frmSurrogateEdit);
  try
    ResizeAnchoredFormToFont(frmSurrogateEdit);
    with frmSurrogateEdit do
    begin
      setValues(aSurrogate, aStart, aStop, aMin, aMax, aData, bLast);
      Result := ShowModal;
      if Result = mrOK then
      begin
        aData := cboSurrogate.ItemID;
        aSurrogate := cboSurrogate.Text;
        aStart := FormatDateTime(fmtListDateTimeSec, ordtbStart.DateSelected);
        aStop := FormatDateTime(fmtListDateTimeSec, ordtbStop.DateSelected);
      end;
    end;
  finally
    frmSurrogateEdit.Release;
    frmSurrogateEdit := nil;
  end;
end;

procedure TfrmSurrogateEdit.setValues(aName, aStart, aStop, aMin, aMax,
  aData: String; bLast: Boolean = false);
var
  dtStart, dtStop, dtMin, dtMax: TDateTime;
  sTarget: String;

begin
  fSurrogate := aName;
  fData := aData;

  fStart := aStart;
  fStop := aStop;
  fMin := aMin;
  fMax := aMax;

  dtStart := StrDateToDate(aStart);
  dtStop := StrDateToDate(aStop);
  dtMin := StrDateToDate(aMin);
  dtMax := StrDateToDate(aMax);

  ordtbStart.DateRange.MinDate := dtMin;
  ordtbStart.DateRange.MaxDate := dtStop;
  ordtbStart.DateSelected := dtStart;
  ordtbStart.Text := FormatDateTime(fmtListDateTime, ordtbStart.DateSelected);

  ordtbStop.DateRange.MinDate := dtStart;
  ordtbStop.DateRange.MaxDate := dtMax;
  if bLast then
  begin
    ordtbStop.DateSelected := dtStart + defaultSurrPeriod;
    if ordtbStop.DateSelected > dtStop then
      ordtbStop.DateSelected := dtStop;
  end
  else
    ordtbStop.DateSelected := dtStop;

  ordtbStop.Text := FormatDateTime(fmtListDateTime, ordtbStop.DateSelected);

  if aData <> '' then
  begin
    sTarget := piece(aName, ',', 1);
    if length(sTarget) > 1 then
      sTarget := copy(sTarget, 1, length(sTarget) - 1);
    cboSurrogate.InitLongList(sTarget);
    cboSurrogate.SelectByID(aData);
  end;

  stxtRange.Caption := aMin + ' .. ' + aMax;

  setButtonStatus;
end;

procedure TfrmSurrogateEdit.btnCancelClick(Sender: TObject);
begin
  inherited;
  fCancel := true;
end;

procedure TfrmSurrogateEdit.btnRestoreClick(Sender: TObject);
begin
  inherited;
  setValues(fSurrogate, fStart, fStop, fMin, fMax, fData);
  stxtChanged.Visible := false;
  btnRestore.Enabled := false;
end;

procedure TfrmSurrogateEdit.cboSurrogateChange(Sender: TObject);
begin
  inherited;
  setButtonStatus;
end;

procedure TfrmSurrogateEdit.cboSurrogateNeedData(Sender: TObject;
  const StartFrom: string; Direction, InsertAt: Integer);
begin
  inherited;
  cboSurrogate.ForDataUse(SubSetOfPersons(StartFrom, Direction));
end;

procedure TfrmSurrogateEdit.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
var
  msg: String;

  function DateTimeErrorReport(aSelector: TORDateBox): String;
  var
    FMDT: TFMDateTime;
  begin
    if not assigned(aSelector) then
      Result := 'Selector was not defined'
    else
    begin
      FMDT := ServerParseFMDate(aSelector.Text);
      if FMDT < 0 then
        Result := 'Invalid Date/time: ' + aSelector.Text + CRLF
      else
      begin
        Result := '';
        aSelector.DateSelected := FmDateTimeToDateTime(FMDT);
        aSelector.Validate(Result);
        if Result <> '' then
          Result := Result + CRLF;
      end;
    end;
  end;

begin
  inherited;
  if fCancel then
    exit;

  msg := msg + DateTimeErrorReport(ordtbStart);
  msg := msg + DateTimeErrorReport(ordtbStop);

  if (cboSurrogate.Text = '') or (cboSurrogate.ItemID = 0) then
    msg := 'Please Select the Surrogate Name' + CRLF;
  if ordtbStop.DateSelected < ordtbStart.DateSelected then
    msg := msg + 'Start Date can''t be greater than Stop date' + CRLF;

  CanClose := msg = '';
  if not CanClose then
    MessageDLG(msg, mtError, [mbOK], 0);
end;

procedure TfrmSurrogateEdit.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  inherited;
  if Key = VK_ESCAPE then
    ModalResult := mrCancel;
end;

procedure TfrmSurrogateEdit.FormShow(Sender: TObject);
begin
  inherited;
  cboSurrogate.SetFocus;
end;

procedure TfrmSurrogateEdit.ordtbStartDateDialogClosed(Sender: TObject);
var
  dt: TDateTime;
begin
  inherited;
  dt := ordtbStart.DateSelected;
  if dt = 0 then
    exit;
  ordtbStop.DateRange.MinDate := dt;
  stxtChanged.Visible := (cboSurrogate.Text <> fSurrogate) or
    (ordtbStop.DateSelected <> StrDateToDate(fStart)) or
    (ordtbStart.DateSelected <> StrDateToDate(fStop));
  btnRestore.Enabled := stxtChanged.Visible;
end;

procedure TfrmSurrogateEdit.ordtbStopDateDialogClosed(Sender: TObject);
var
  dt: TDateTime;
begin
  inherited;
  dt := ordtbStop.DateSelected;
  if dt = 0 then
    exit;
  ordtbStart.DateRange.MaxDate := dt;
  stxtChanged.Visible := (cboSurrogate.Text <> fSurrogate) or
    (ordtbStop.DateSelected <> strToDate(fStart)) or
    (ordtbStart.DateSelected <> strToDate(fStop));
  btnRestore.Enabled := stxtChanged.Visible;
end;

procedure TfrmSurrogateEdit.setButtonStatus;
begin
  btnOK.Enabled := cboSurrogate.Text <> '';
end;

end.
