unit fOptionsProcessedAlerts;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ORCtrls, ORDtTmRng, ORFn, ExtCtrls, fBase508Form,
  VA508AccessibilityManager;

type
  TfrmOptionsProcessedAlerts = class(TfrmBase508Form)
    pnlBottom: TPanel;
    bvlBottom: TBevel;
    btnCancel: TButton;
    btnOK: TButton;
    btnDefaults: TButton;
    edDays: TEdit;
    edMaxRecords: TEdit;
    sTxtMaxRecords: TVA508StaticText;
    sTxtLogDays: TVA508StaticText;
    Panel1: TPanel;
    procedure btnDefaultsClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
    procedure setDefaults;
    procedure setInfo(aValue:String);
    function getInfo:String;
    procedure Init508;
  public
    { Public declarations }
    property Info:String read getInfo write setInfo;
  end;

var
  frmOptionsProcessedAlerts: TfrmOptionsProcessedAlerts;
  paLogDaysMax: Real;
  paLogDays: Real;
  paLogRecordsMax: Integer;
  ProcessedAlertsSessionInfo:String;

function UpdateProcessedAlertsPreferences:Integer;
function getProcessedAlertsInfo:String;
procedure setProcessedAlertsInfo(anInfo:String);
procedure loadProcessedAlertsInfo;

implementation

uses
  rOptions, uOptions, rCore, VAUtils
  , System.UITypes ;

{$R *.DFM}
const
  defLogDays = 7.0;
  defLogRecordMax = 100;
  posLogDays = 1;  // position of the LogDays value in the string
  posRecordMax = 2;// position of the LogRecordMax value

procedure setPaGUIDefaults;
begin
  paLogDays := defLogDays;
  paLogRecordsMax := defLogRecordMax;
end;

procedure setPaSiteDefaults;
begin
  paLogDays := defLogDays;
  paLogDaysMax := rpcGetDaysBeforeAlertPurge; // server max for the user(?)
  // UPDATE with RPC call for the case the defaults are coming from the server
  paLogDays := paLogDaysMax;
  paLogRecordsMax := defLogRecordMax;
end;

function getProcessedAlertsInfo:String;
begin
  Result := Format('%g^%d',[paLogDays,paLogRecordsMax]);
end;

procedure setProcessedAlertsInfo(anInfo:String);
begin
  paLogDays := StrToFloatDef(Piece(anInfo,U,posLogDays),paLogDays);
  paLogRecordsMax := StrToIntDef(Piece(anInfo,U,posRecordMax),paLogRecordsMax);
end;

procedure loadProcessedAlertsInfo;
var
  sInfo:String;
begin
  if ProcessedAlertsSessionInfo = '' then
    sInfo := rpcGetNotificationDefaults
  else
    sInfo := ProcessedAlertsSessionInfo;
  paLogDays := StrToFloatDef(Piece(sInfo,U,4),paLogDays);
  paLogRecordsMax := StrToIntDef(Piece(sInfo,U,5),paLogRecordsMax);
  if ProcessedAlertsSessionInfo = '' then
    ProcessedAlertsSessionInfo := getProcessedAlertsInfo;
end;
////////////////////////////////////////////////////////////////////////////////

function UpdateProcessedAlertsPreferences:Integer;
begin
  setPaSiteDefaults;

  frmOptionsProcessedAlerts := TfrmOptionsProcessedAlerts.Create(Application);

  try
    with frmOptionsProcessedAlerts do
    begin
      Init508;
      ResizeAnchoredFormToFont(frmOptionsProcessedAlerts);
      LoadProcessedAlertsInfo;
      setInfo(getProcessedAlertsInfo);
      Result := ShowModal;
      if Result <> mrCancel then
        begin
          paLogDays := StrToFloatDef(edDays.Text,paLogDays);  // save new values in unit var
          paLogRecordsMax := StrToIntDef(edMaxRecords.Text,paLogRecordsMax);  // save new values in unit var
        end;
    end;
  finally
    frmOptionsProcessedAlerts.Release;
    frmOptionsProcessedAlerts := nil;
  end;
end;

////////////////////////////////////////////////////////////////////////////////

procedure TfrmOptionsProcessedAlerts.setDefaults;
begin
  setPaSiteDefaults;
  edDays.Text := Format('%g',[defLogDays]);
  edMaxRecords.Text := Format('%d',[defLogRecordMax]);
end;

procedure TfrmOptionsProcessedAlerts.setInfo(aValue:String);
begin
  edDays.Text := piece(aValue,U,1);
  edMaxRecords.Text := piece(aValue,U,2);
end;

procedure TfrmOptionsProcessedAlerts.btnDefaultsClick(Sender: TObject);
begin
  inherited;
  SetDefaults;
end;

procedure TfrmOptionsProcessedAlerts.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
var
  sErr: String;
  i: integer;
  f: Real;
const
  fmtTooSmall = 'The selected value %s is too small';
  fmtInvalidValue = 'The value selected as the max number of records %s is not valid';
begin
  inherited;
  f := StrToFloatDef(edDays.Text,paLogDays);
  if (f > paLogDaysMax) or (f<0) then
    begin
      sErr := 'The requested number of days '+FloatToStr(f) + CRLF +
        'is out of the range of "0..'+FloatToStr(paLogDaysMax) + '" (days)';
    end;
  try
    i := strToInt(edMaxRecords.Text);
    if i < 1 then
      sErr := sErr + CRLF + format(fmtTooSmall,[edMaxRecords.Text]);
  except
    on E: Exception do
        sErr := sErr + CRLF + format(fmtInvalidValue,[edMaxRecords.Text]);
  end;

  CanClose := sErr = '';
  if not CanClose then
      MessageDlg(trim(sErr) + CRLF + CRLF +
        'Please update the value(s) or cancel the changes.',
        mtError,[mbOK],0);

end;

function TfrmOptionsProcessedAlerts.getInfo:String;
begin
  Result := edDays.Text + U + edMaxRecords.Text;
end;

procedure TfrmOptionsProcessedAlerts.Init508;
var
  b: Boolean;
begin
  b := ScreenReaderActive;
  sTxtMaxRecords.TabStop := b;
  sTxtLogDays.TabStop := b;
end;

initialization

  setPaGUIDefaults;

end.

