unit fAlertRangeEdit;

{
  This unit implements class TfrmAlertRangeEdit that provides data for
  Notification Alert Processing Improvement (GUI)
  (Request #20081008)
}

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, fBase508Form, VA508AccessibilityManager,
  Vcl.StdCtrls, ORDtTm, ORCtrls, Vcl.ExtCtrls, Vcl.ComCtrls, ORDtTmRng,
  Vcl.Buttons;

type
  TfrmAlertRangeEdit = class(TfrmBase508Form)
    pnlBottom: TPanel;
    bvlBottom: TBevel;
    Panel1: TPanel;
    btnOK: TButton;
    btnCancel: TButton;
    ordtbStart: TORDateBox;
    ordtbStop: TORDateBox;
    stxtStart: TVA508StaticText;
    stxtStop: TVA508StaticText;
    stxtChanged: TStaticText;
    btnRestore: TButton;
    stxtRangeInfo: TVA508StaticText;
    stxtRange: TVA508StaticText;
    pnlTop: TPanel;
    stxtRangeHint: TVA508StaticText;
    sbDebug: TSpeedButton;
    procedure btnRestoreClick(Sender: TObject);
    procedure ordtbStartDateDialogClosed(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure sbDebugClick(Sender: TObject);
  private
    { Private declarations }
    fStart,
    fStop,
    fMin,
    fMax: String;

    procedure setValues(aStart, aStop, aMin, aMax: String);
  public
    { Public declarations }
  end;

var
  frmAlertRangeEdit: TfrmAlertRangeEdit;

const
  fmtDateTime = 'mm/dd/yyyy@hh:nn';
  fmtDateOnly = 'mmm dd yyyy';
  fmtLimit = 'Please note that range can''t exceed %d day(s) limit set for this site.';

function editAlertRange(var aStart, aStop, aMin, aMax: String; Limit:Integer): Integer;
function StrDateToDate(aDate: String): TDateTime;
implementation

uses
  ORFn, rCore, System.UITypes, fFrame;

{$R *.dfm}

function StrDateToDate(aDate: String): TDateTime;
var
  dtDate, dtTime: Real;
  sDate, sTime: String;
  delim: Char;
begin
  delim := '@';
  if pos('@', aDate) = 0 then
    delim := ' ';

  sDate := piece(aDate, delim, 1);
  sTime := piece(aDate, delim, 2);

  dtDate := strToDate(sDate);
  dtTime := strToTime(sTime);

  Result := dtDate + dtTime;
end;

function editAlertRange(var aStart, aStop, aMin, aMax: String; Limit:Integer): Integer;
begin
  if not assigned(frmAlertRangeEdit) then
    Application.CreateForm(TfrmAlertRangeEdit, frmAlertRangeEdit);
  try
    ResizeAnchoredFormToFont(frmAlertRangeEdit);
    with frmAlertRangeEdit do
    begin
{$IFDEF DEBUG_AA}
      sbDebug.Visible := True;
{$ENDIF}
      stxtRangeHint.Caption := Format(fmtLimit,[Limit]);
      setValues(aStart, aStop, aMin, aMax);
      Result := ShowModal;
      if Result = mrOK then
      begin
        aStart := FormatDateTime(fmtDateTime, ordtbStart.DateSelected);
        aStop := FormatDateTime(fmtDateTime, ordtbStop.DateSelected);
      end;
    end;
  finally
    frmAlertRangeEdit.Release;
    frmAlertRangeEdit := nil;
  end;
end;

procedure TfrmAlertRangeEdit.setValues(aStart, aStop, aMin, aMax: String);
var
  dtStart, dtStop, dtMin, dtMax: TDateTime;

begin
  fStart := aStart;
  fStop := aStop;
  fMin := aMin;
  fMax := aMax;

  dtStart := StrDateToDate(aStart);
  dtStop := StrDateToDate(aStop);
  dtMin := StrDateToDate(aMin);
  dtMax := trunc(StrDateToDate(aMax)) + 0.99999;

  ordtbStart.DateRange.MinDate := dtMin;
  ordtbStart.DateRange.MaxDate := dtStop;
  ordtbStart.DateSelected := dtStart;
  ordtbStart.DateOnly := True;
  ordtbStart.Text := FormatDateTime(fmtDateOnly, dtStart);

  ordtbStop.DateRange.MinDate := dtStart;
  ordtbStop.DateRange.MaxDate := dtMax;
  ordtbStop.DateSelected := dtStop;
  ordtbStop.DateOnly := True;
  ordtbStop.Text := FormatDateTime(fmtDateOnly, dtStop);

  stxtRange.Caption := FormatDateTime(fmtDateOnly,dtMin) + ' .. ' +
    FormatDateTime(fmtDateOnly,dtMax);
end;

procedure TfrmAlertRangeEdit.sbDebugClick(Sender: TObject);
{$IFDEF DEBUG_AA}
var
  i: Integer;
{$ENDIF}
begin
  inherited;
{$IFDEF DEBUG_AA}
  i := Application.MainForm.Font.Size;
  case i of
    8,10,12: i := i + 2;
    14: i := 18;
    18: i := 8;
  end;
  TfrmFrame(Application.MainForm).ChangeFont(i);
  ResizeAnchoredFormToFont(self);
{$ENDIF}
end;

procedure TfrmAlertRangeEdit.btnRestoreClick(Sender: TObject);
begin
  inherited;
  setValues(fStart, fStop, fMin, fMax);
  btnRestore.Enabled := false;
  stxtChanged.Visible := false;
end;

procedure TfrmAlertRangeEdit.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  inherited;
  if Key = VK_ESCAPE then
    ModalResult := mrCancel;
end;

procedure TfrmAlertRangeEdit.ordtbStartDateDialogClosed(Sender: TObject);
var
  dt: TDateTime;
begin
  inherited;
  dt := TORDateBox(Sender).DateSelected;
  if dt = 0 then
    exit;
  if Sender = ordtbStart then
    ordtbStop.DateRange.MinDate := dt
  else if Sender = ordtbStop then
    ordtbStart.DateRange.MaxDate := dt;

  btnRestore.Enabled :=
    (ordtbStop.DateSelected <> strDateToDate(fStart)) or
    (ordtbStart.DateSelected <> strDateToDate(fStop));

  stxtChanged.Visible := btnRestore.Enabled;
end;

end.
