unit fImmunization;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fPCEBase, StdCtrls, ORCtrls, CheckLst, ExtCtrls, Buttons, uPCE, rPCE, ORFn,
  fPCELex, fPCEOther, ComCtrls, fPCEBaseMain, VA508AccessibilityManager;

type
  TfrmImmunizations = class(TfrmPCEBaseMain)
    btnEdit: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure btnOtherClick(Sender: TObject);
    procedure btnOtherExit(Sender: TObject);
    procedure btnOtherMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure btnEditClick(Sender: TObject);
  private
  protected
    procedure UpdateNewItemStr(var x: string); override;
    procedure UpdateControls; override;
  public
//    procedure ChangeProvider;
  end;

var
  frmImmunizations: TfrmImmunizations;

implementation

{$R *.DFM}

uses
  fEncounterFrame, VA508AccessibilityRouter, fVimm, rvimm, uCore;


procedure TfrmImmunizations.btnEditClick(Sender: TObject);
var
  i: Integer;
  APCEItem: TPCEImm;
  temp: String;
  inputList, resultList: TStringList;

begin
  inherited;
  FUpdatingGrid := TRUE;
  resultList := TStringList.Create;
  inputList := TStringList.create;
  try
    inputList.add('noGrid^0');
    inputList.Add('makeNote^0');
    inputList.Add('patientName^' + patient.Name);
    inputList.Add('patientIEN^' + patient.DFN);
    inputList.Add('userName^' + user.Name);
    inputList.Add('userIEN^' + IntToStr(user.DUZ));
    inputList.Add('encounterProviderName^' + encounter.ProviderName);
    inputList.Add('encounterProviderIEN^' + IntToStr(encounter.Provider));
    inputList.Add('encounterLocation^' + IntToStr(uEncPCEData.Location));
    inputList.Add('encounterCategory^' + uEncPCEData.VisitCategory);
    inputList.Add('dateEncounterDateTime^' + FloatToSTr(uEncPCEData.VisitDateTime));
    inputList.Add('visitString^' + uEncPCEData.VisitString);

    for i := lstRenameMe.Items.Count-1 downto 0 do if(lstRenameMe.Items[i].Selected) then
    begin
      APCEItem := TPCEImm(lstRenameMe.Objects[i]);
      if not assigned(APCEItem) then continue;
      temp := APceItem.getVimmStr;
      inputList.Add('EDIT' + U + temp);
      APCEItem.Free;
    end;
      if performVimm(inputList, resultList, false) = false then exit;
  finally
    FUpdatingGrid := FALSE;
    FreeAndNil(inputLIst);
    FreeAndNil(resultList);
  end;
end;

procedure TfrmImmunizations.btnOtherClick(Sender: TObject);
begin
//  inherited;
end;

procedure TfrmImmunizations.btnOtherExit(Sender: TObject);
begin
////  inherited;
end;

procedure  TfrmImmunizations.btnOtherMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
//var
//immList, tmpSL, resultList: TStringList;
//data: TVimmResult;
//i: integer;
//str: string;
//imm: TPCEImm;
//PCEObj: TPCEData;
//APCEItem: TPCEItem;
begin
  inherited;
//   tmpSL := TStringList.Create;
//   resultList := TStringList.Create;
//   immList := TStringList.Create;
//   try
//      begin
//
//        uEncPCEData.getVimmResults(tmpSL);
////        if openVimmForm(tmpSL, resultList, uEncPCEData) = false then exit;
//        infoBox('out of vimm', 'caption' , mb_ok);
//        for I := 0 to resultList.Count - 1 do
//          begin
//            data := TVimmResult(resultList.Objects[i]);
//            if data.isComplete = false then continue;
//            setPiece(str, U, pnumCode, data.id);
//            setPiece(str, U, pnumNarrative, data.name);
//            setPiece(str, u, pnumImmSeries, data.series );
//            setPiece(str, U, pnumImmLot, data.lot);
//            setPiece(str, U, pnumImmRoute, data.route);
//            setPiece(str, U, pnumImmSite, data.site);
//            setPiece(str, U, pnumImmdosage, data.dosage);
//            setPiece(str, U, pnumImmAdminBy, data.adminBy);
//            setPiece(str, U, pnumImmOrderBy, data.orderBy);
//
//
//            setPiece(str, U, pnumImmDocumType   , data.documType);
//            setPiece(str, U, pnumImmRouteIEN    , data.routeIEN);
//            setPiece(str, U, pnumImmSiteIEN     , data.siteIEN);
//            setPiece(str, U, pnumImmAdminByIEN  , data.adminByIEN);
//            setPiece(str, U, pnumImmOrderByIEN, data.orderByIEN);
//            try
//              APCEItem := FPCEItemClass.Create;
//              APCEItem.SetFromString(str);
//              GridIndex := lstRenameMe.Add(APCEItem.ItemStr, APCEItem);
////              imm := TPCEImm.Create;
////              imm.SetFromString(str);
////              immList.AddObject('', imm);
////              PCEObj.SetImmunizations(immList, true);
////              immList.clear;
//            finally
//
//            end;
////            TPCEImm.setfromString(str);
//          end;
////          if immList <> nil then PCEObj.SetImmunizations(immList, FALSE);
//
//      end;
//   finally
//    tmpSL.Free;
//    ResultList.Free;
//    immList.Free;
//   end;
end;

procedure TfrmImmunizations.FormCreate(Sender: TObject);
begin
  inherited;
  FTabName := CT_ImmNm;
  FPCEListCodesProc := ListImmunizCodes;
  FPCEItemClass := TPCEImm;
  FPCECode := 'IMM';
end;

procedure TfrmImmunizations.FormPaint(Sender: TObject);
begin
inherited;
//  if ckbContra.Focused = True then
//  begin
//    frmImmunizations.Canvas.Pen.Width := 1;
//    frmImmunizations.Canvas.Pen.Style := psDot;
//    frmImmunizations.Canvas.MoveTo(lblContra.Left - 2,lblContra.Top - 1);
//    frmImmunizations.Canvas.LineTo(lblContra.Left + lblContra.Width + 2,lblContra.Top - 1);
//    frmImmunizations.Canvas.LineTo(lblContra.Left + lblContra.Width + 2,lblContra.Top + lblContra.Height);
//    frmImmunizations.Canvas.LineTo(lblContra.Left - 2,lblContra.Top + lblContra.Height);
//    frmImmunizations.Canvas.LineTo(lblContra.Left - 2,lblContra.Top - 1);
//  end;
end;

procedure TfrmImmunizations.UpdateNewItemStr(var x: string);
begin
  inherited;
  SetPiece(x, U, pnumImmSeries, NoPCEValue);
  SetPiece(x, U, pnumImmReaction, NoPCEValue);
  SetPiece(x, U, pnumImmRefused, '0');
  SetPiece(x, U, pnumImmContra, '0');
end;

procedure TfrmImmunizations.UpdateControls;
var
  ok, Contra, First: boolean;
  SameS, SameR, SameC: boolean;
  i: integer;
  Ser, React: string;
  Obj: TPCEImm;

begin
  inherited;
  if(NotUpdating) then
  begin
    BeginUpdate;
    try
      ok := (lstRenameMe.SelCount > 0);
      if(ok) then
      begin
        First := TRUE;
        SameS := TRUE;
        SameR := TRUE;
        SameC := TRUE;
        Contra := FALSE;
        Ser := NoPCEValue;
        React := NoPCEValue;
        for i := 0 to lstRenameMe.Items.Count-1 do
        begin
          if lstRenameMe.Items[i].Selected then
          begin
            Obj := TPCEImm(lstRenameMe.Objects[i]);
            if(First) then
            begin
              First := FALSE;
              Contra := Obj.Contraindicated;
              Ser := Obj.Series;
              React := Obj.Reaction;
            end
            else
            begin
              if(SameS) then
                SameS := (Ser = Obj.Series);
              if(SameR) then
                SameR := (React = Obj.Reaction);
              if(SameC) then
                SameC := (Contra = Obj.Contraindicated);
            end;
          end;
        end;
      end;
    finally
      EndUpdate;
    end;
  end;
end;

initialization
  SpecifyFormIsNotADialog(TfrmImmunizations);

end.
