package gov.va.vamf.service.shifttransition.watchlist;

import org.junit.Test;

import javax.ws.rs.WebApplicationException;

public class PersonTests {
    @Test(expected = WebApplicationException.class)
    public void nullPersonIdentity() {
        Person person = new Person();
        person.validateInput();
    }

    @Test(expected = WebApplicationException.class)
    public void nullUniqueId() {
        Person person = new Person();
        person.identity = new PersonIdentity("123", null);

        person.validateInput();
    }

    @Test(expected = WebApplicationException.class)
    public void emptyStringUniqueId() {
        Person person = new Person();
        person.identity = new PersonIdentity("123", "");

        person.validateInput();
    }

    @Test(expected = WebApplicationException.class)
    public void nullAssigningAuthority() {
        Person person = new Person();
        person.identity = new PersonIdentity(null, "asc");

        person.validateInput();
    }

    @Test(expected = WebApplicationException.class)
    public void emptyStringAssigningAuthority() {
        Person person = new Person();
        person.identity = new PersonIdentity("", "dec");

        person.validateInput();
    }
}
